/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.nbt.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.IBlockData;
import net.minecraft.server.v1_12_R1.MojangsonParseException;
import net.minecraft.server.v1_12_R1.MojangsonParser;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import net.minecraft.server.v1_12_R1.TileEntity;
import net.minecraft.server.v1_12_R1.WorldServer;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.event.Event;

@Name(value="NBT - Tile Entity")
@Description(value={"NBT of a tile entity, such as a furnace"})
@Examples(value={"add \"{RequiredPlayerRange:0s}\" to targeted block's nbt", "add \"{SpawnData:{id:\"\"minecraft:wither\"\"}}\" to nbt of clicked block"})
public class ExprTileEntityNBT
extends SimplePropertyExpression<Block, String> {
    @Nullable
    public String convert(Block b) {
        WorldServer w = ((CraftWorld)b.getWorld()).getHandle();
        TileEntity te = w.getTileEntity(new BlockPosition(b.getX(), b.getY(), b.getZ()));
        if (te == null) {
            return null;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        te.save(nbt);
        return nbt.toString();
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        Block b = (Block)this.getExpr().getSingle(event);
        String value = (String)delta[0];
        NBTTagCompound nbt = new NBTTagCompound();
        WorldServer w = ((CraftWorld)b.getWorld()).getHandle();
        TileEntity te = w.getTileEntity(new BlockPosition(b.getX(), b.getY(), b.getZ()));
        if (te != null) {
            switch (mode) {
                case ADD: {
                    NBTTagCompound nbtv;
                    te.save(nbt);
                    try {
                        nbtv = MojangsonParser.parse((String)value);
                        nbt.a(nbtv);
                        te.load(nbt);
                    }
                    catch (MojangsonParseException ex) {
                        Skript.warning((String)("NBT parse error: " + ex.getMessage()));
                    }
                    break;
                }
                case SET: {
                    NBTTagCompound nbtv;
                    try {
                        nbtv = MojangsonParser.parse((String)value);
                        te.load(nbtv);
                    }
                    catch (MojangsonParseException ex) {
                        Skript.warning((String)("NBT parse error: " + ex.getMessage()));
                    }
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            te.update();
            IBlockData tet = w.getType(new BlockPosition(b.getX(), b.getY(), b.getZ()));
            w.notify(te.getPosition(), tet, tet, 3);
        }
    }

    protected String getPropertyName() {
        return "tile entity nbt";
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        ExprTileEntityNBT.register(ExprTileEntityNBT.class, String.class, (String)"[(block|tile[[ ]entity])( |-)]nbt", (String)"block");
    }
}

