/*
 * Decompiled with CFR 0.152.
 */
package me.shoko.plugins.shosko.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.event.Event;

public class EffDefineRegion
extends Effect {
    private Expression<String> name;
    private Expression<Location> loc1;
    private Expression<Location> loc2;
    private Expression<org.bukkit.World> world;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.name = expressions[0];
        this.loc1 = expressions[1];
        this.loc2 = expressions[2];
        this.world = expressions[3];
        return true;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "Define a world guard region effect named " + this.name.toString(event, debug) + " from " + this.loc1.toString(event, debug) + " to " + this.loc2.toString(event, debug) + " in " + this.world.toString(event, debug);
    }

    protected void execute(Event event) {
        if (this.name == null) {
            return;
        }
        if (this.loc1 == null) {
            return;
        }
        if (this.loc2 == null) {
            return;
        }
        if (this.world == null) {
            return;
        }
        String _name = (String)this.name.getSingle(event);
        Location _loc1 = (Location)this.loc1.getSingle(event);
        Location _loc2 = (Location)this.loc2.getSingle(event);
        World _world = BukkitAdapter.adapt((org.bukkit.World)((org.bukkit.World)this.world.getSingle(event)));
        BlockVector3 min = BlockVector3.at((double)_loc1.getX(), (double)_loc1.getY(), (double)_loc1.getZ());
        BlockVector3 max = BlockVector3.at((double)_loc2.getX(), (double)_loc2.getY(), (double)_loc2.getZ());
        ProtectedCuboidRegion region = new ProtectedCuboidRegion(_name, min, max);
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager regions = container.get(_world);
        regions.addRegion((ProtectedRegion)region);
    }

    static {
        Skript.registerEffect(EffDefineRegion.class, (String[])new String[]{"define region %string% from %location% to %location% in %world%"});
    }
}

