/*
 * Decompiled with CFR 0.152.
 */
package me.sharpjaws.sharpSK.hooks.WorldEdit;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.ClipboardHolder;
import javax.annotation.Nullable;
import me.sharpjaws.sharpSK.main;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.Event;

public class EffSaveSelectionToClipboard
extends Effect {
    private Expression<Location> point1;
    private Expression<Location> point2;
    private Expression<Location> origin;
    private Expression<org.bukkit.entity.Player> pl;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.point1 = expr[0];
        this.point2 = expr[1];
        this.origin = expr[2];
        this.pl = expr[3];
        return true;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "[sharpsk] [worldedit] save [selection] p[oint][ ]1 %location% p[oint][ ]2 %location% [with origin %-location%] to clip[board] of [player] %player%";
    }

    protected void execute(Event e) {
        WorldEditPlugin wep = (WorldEditPlugin)Bukkit.getServer().getPluginManager().getPlugin("WorldEdit");
        LocalSession session = wep.getSession((org.bukkit.entity.Player)this.pl.getSingle(e));
        Location point1loc = (Location)this.point1.getSingle(e);
        Location point2loc = (Location)this.point2.getSingle(e);
        Vector min = new Vector((double)point1loc.getBlockX(), (double)point1loc.getBlockY(), point1loc.getZ());
        Vector max = new Vector((double)point2loc.getBlockX(), (double)point2loc.getBlockY(), point2loc.getZ());
        CuboidRegion cr = new CuboidRegion(min, max);
        BlockArrayClipboard bc = new BlockArrayClipboard((Region)cr);
        EditSession es = wep.createEditSession((org.bukkit.entity.Player)this.pl.getSingle(e));
        try {
            if (this.origin == null) {
                bc.setOrigin(session.getPlacementPosition((Player)wep.wrapPlayer((org.bukkit.entity.Player)this.pl.getSingle(e))));
            } else {
                Location originloc = (Location)this.origin.getSingle(e);
                Vector originvec = new Vector(originloc.getBlockX(), originloc.getBlockY(), originloc.getBlockZ());
                bc.setOrigin(originvec);
            }
            session.setClipboard(new ClipboardHolder((Clipboard)bc, es.getWorld().getWorldData()));
            ForwardExtentCopy copy = new ForwardExtentCopy((Extent)es, (Region)cr, (Extent)bc, cr.getMinimumPoint());
            Operations.complete((Operation)copy);
        }
        catch (WorldEditException e1) {
            main core = (main)Bukkit.getPluginManager().getPlugin("SharpSK");
            core.getLogger().warning("Failed to save selection. Something went wrong");
            return;
        }
    }
}

