/*
 * Decompiled with CFR 0.152.
 */
package me.sharpjaws.sharpSK.hooks.WorldEdit;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.schematic.SchematicFormat;
import java.io.File;
import java.util.regex.Matcher;
import me.sharpjaws.sharpSK.hooks.WorldEdit.enums.SchemFacingDirection;
import me.sharpjaws.sharpSK.main;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.Event;

public class EffPasteSchematic
extends Effect {
    private Expression<?> name;
    private Expression<?> loc;
    private Expression<?> exair;
    private Expression<Number> angle;
    private int mark = 0;

    public boolean init(Expression<?>[] expression, int i, Kleenean kleenean, SkriptParser.ParseResult Result) {
        this.name = expression[0];
        this.loc = expression[1];
        this.exair = expression[2];
        this.angle = expression[3];
        this.mark = Result.mark;
        return true;
    }

    public String toString(Event e, boolean debug) {
        return "Paste schematic \"" + this.name + "\" at " + this.loc;
    }

    protected void execute(Event event) {
        String name = (String)this.name.getSingle(event);
        Location loc = (Location)this.loc.getSingle(event);
        Boolean exair = false;
        exair = this.exair != null ? (Boolean)this.exair.getSingle(event) : Boolean.valueOf(false);
        try {
            switch (((Number)this.angle.getSingle(event)).intValue()) {
                case 0: 
                case 360: {
                    EffPasteSchematic.paste(name, loc, exair, SchemFacingDirection.NORTH);
                    break;
                }
                case 90: {
                    EffPasteSchematic.paste(name, loc, exair, SchemFacingDirection.EAST);
                    break;
                }
                case 180: {
                    EffPasteSchematic.paste(name, loc, exair, SchemFacingDirection.SOUTH);
                    break;
                }
                case 270: {
                    EffPasteSchematic.paste(name, loc, exair, SchemFacingDirection.WEST);
                    break;
                }
                default: {
                    EffPasteSchematic.paste(name, loc, exair, SchemFacingDirection.INVALID);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean paste(String f, Location loc, Boolean exair, SchemFacingDirection facing) throws Exception {
        File file = f.startsWith("/") ? new File((f + ".schematic").replaceAll("/", Matcher.quoteReplacement(File.separator))) : new File(("plugins/WorldEdit/schematics/" + (f.contains(".") ? f : String.valueOf(f) + ".schematic")).replaceAll("/", Matcher.quoteReplacement(File.separator)));
        Vector v = new Vector(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        SchematicFormat format = SchematicFormat.getFormat((File)file);
        if (!file.exists() && file.isDirectory()) {
            return false;
        }
        EditSession es = WorldEdit.getInstance().getEditSessionFactory().getEditSession((LocalWorld)new BukkitWorld(loc.getWorld()), 400000);
        CuboidClipboard cc = null;
        try {
            cc = format.load(file);
            if (facing != null) {
                if (SchemFacingDirection.getDegree(facing) != -1) {
                    cc.rotate2D(SchemFacingDirection.getDegree(facing).intValue());
                } else {
                    main core = (main)Bukkit.getPluginManager().getPlugin("SharpSK");
                    core.getLogger().warning("Invalid rotation angle for schematic: \"" + f + "\"");
                    core.getLogger().warning("Valid angles are: 0, 90, 180, 270, 360");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!exair.booleanValue()) {
            cc.paste(es, v, false);
        } else {
            cc.paste(es, v, true);
        }
        return true;
    }
}

