/*
 * Decompiled with CFR 0.152.
 */
package com.codingforcookies.armorequip;

import com.codingforcookies.armorequip.ArmorEquipEvent;
import com.codingforcookies.armorequip.ArmorType;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Dispenser;
import org.bukkit.plugin.Plugin;

public class ArmorListener
implements Listener {
    private final List<String> blockedMaterials;

    public ArmorListener(List<String> blockedMaterials, Plugin main2) {
        this.blockedMaterials = blockedMaterials;
        main2.getServer().getPluginManager().registerEvents((Listener)this, main2);
    }

    @EventHandler
    public final void onInventoryClick(InventoryClickEvent e) {
        if (e.getClick().equals((Object)ClickType.CREATIVE)) {
            ArmorEquipEvent.EquipMethod method = ArmorEquipEvent.EquipMethod.DRAG;
            if (ArmorType.matchType(e.getCursor()) == null) {
                return;
            }
            ArmorType newArmorType2 = ArmorType.matchType(e.getCurrentItem());
            if (!e.getWhoClicked().getItemOnCursor().equals(null) && e.getSlotType().equals((Object)InventoryType.SlotType.CONTAINER) || e.getSlotType().equals((Object)InventoryType.SlotType.QUICKBAR)) {
                return;
            }
            ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent((Player)e.getWhoClicked(), method, newArmorType2, e.getCursor());
            Bukkit.getServer().getPluginManager().callEvent((Event)armorEquipEvent);
            if (armorEquipEvent.isCancelled()) {
                e.setCancelled(true);
            }
        } else {
            boolean shift = false;
            boolean numberkey = false;
            if (e.isCancelled()) {
                return;
            }
            if (e.getClick().equals((Object)ClickType.SHIFT_LEFT) || e.getClick().equals((Object)ClickType.SHIFT_RIGHT)) {
                shift = true;
            }
            if (e.getClick().equals((Object)ClickType.NUMBER_KEY)) {
                numberkey = true;
            }
            if (!(e.getSlotType() == InventoryType.SlotType.ARMOR && e.getSlotType() == InventoryType.SlotType.QUICKBAR || e.getInventory().getType().equals((Object)InventoryType.CRAFTING))) {
                return;
            }
            if (!(e.getWhoClicked() instanceof Player)) {
                return;
            }
            if (e.getCurrentItem() == null) {
                return;
            }
            ArmorType newArmorType = ArmorType.matchType(shift ? e.getCurrentItem() : e.getCursor());
            if (!shift && newArmorType != null && e.getRawSlot() != newArmorType.getSlot()) {
                return;
            }
            if (shift) {
                if (!e.getClickedInventory().getType().equals((Object)InventoryType.PLAYER)) {
                    return;
                }
                newArmorType = ArmorType.matchType(e.getCurrentItem());
                if (newArmorType != null) {
                    if (e.getSlotType() == InventoryType.SlotType.ARMOR) {
                        return;
                    }
                    boolean equipping = true;
                    if (e.getRawSlot() == newArmorType.getSlot()) {
                        equipping = false;
                    }
                    if (newArmorType.equals((Object)ArmorType.HELMET) && !(equipping ? e.getWhoClicked().getInventory().getHelmet() != null : e.getWhoClicked().getInventory().getHelmet() == null) || newArmorType.equals((Object)ArmorType.CHESTPLATE) && !(equipping ? e.getWhoClicked().getInventory().getChestplate() != null : e.getWhoClicked().getInventory().getChestplate() == null) || newArmorType.equals((Object)ArmorType.LEGGINGS) && !(equipping ? e.getWhoClicked().getInventory().getLeggings() != null : e.getWhoClicked().getInventory().getLeggings() == null) || newArmorType.equals((Object)ArmorType.BOOTS) && (equipping ? e.getWhoClicked().getInventory().getBoots() == null : e.getWhoClicked().getInventory().getBoots() != null)) {
                        ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent((Player)e.getWhoClicked(), ArmorEquipEvent.EquipMethod.SHIFT_CLICK, newArmorType, e.getCurrentItem());
                        Bukkit.getServer().getPluginManager().callEvent((Event)armorEquipEvent);
                        if (armorEquipEvent.isCancelled()) {
                            Player p = (Player)e.getWhoClicked();
                            p.updateInventory();
                            e.setCancelled(true);
                        }
                    }
                }
            } else {
                ItemStack newArmorPiece = e.getCursor();
                ItemStack oldArmorPiece = e.getCurrentItem();
                if (numberkey && e.getClickedInventory().getType().equals((Object)InventoryType.PLAYER)) {
                    ItemStack hotbarItem = e.getClickedInventory().getItem(e.getHotbarButton());
                    if (hotbarItem != null) {
                        newArmorType = ArmorType.matchType(hotbarItem);
                        newArmorPiece = hotbarItem;
                        oldArmorPiece = e.getClickedInventory().getItem(e.getSlot());
                    } else if (newArmorPiece.getType().equals((Object)Material.AIR)) {
                        return;
                    }
                }
                if (newArmorType != null && e.getRawSlot() == newArmorType.getSlot()) {
                    ArmorEquipEvent.EquipMethod method = ArmorEquipEvent.EquipMethod.DRAG;
                    ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent((Player)e.getWhoClicked(), method, newArmorType, e.getWhoClicked().getItemOnCursor());
                    if (e.getAction().equals((Object)InventoryAction.HOTBAR_SWAP) || numberkey) {
                        method = ArmorEquipEvent.EquipMethod.HOTBAR_SWAP;
                    }
                    if (e.getClick().equals((Object)ClickType.RIGHT) || e.getClick().equals((Object)ClickType.LEFT)) {
                        armorEquipEvent = new ArmorEquipEvent((Player)e.getWhoClicked(), method, newArmorType, e.getWhoClicked().getItemOnCursor());
                    } else if (e.getClick().equals((Object)ClickType.NUMBER_KEY)) {
                        armorEquipEvent = new ArmorEquipEvent((Player)e.getWhoClicked(), method, newArmorType, newArmorPiece);
                    }
                    Bukkit.getServer().getPluginManager().callEvent((Event)armorEquipEvent);
                    if (armorEquipEvent.isCancelled()) {
                        e.setCancelled(true);
                    }
                }
            }
        }
    }

    @EventHandler
    public void playerInteractEvent(PlayerInteractEvent e) {
        if (e.getAction() == Action.PHYSICAL) {
            return;
        }
        if (e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Player player = e.getPlayer();
            ArmorType newArmorType = ArmorType.matchType(e.getItem());
            if (newArmorType != null && (newArmorType.equals((Object)ArmorType.HELMET) && e.getPlayer().getInventory().getHelmet() == null || newArmorType.equals((Object)ArmorType.CHESTPLATE) && e.getPlayer().getInventory().getChestplate() == null || newArmorType.equals((Object)ArmorType.LEGGINGS) && e.getPlayer().getInventory().getLeggings() == null || newArmorType.equals((Object)ArmorType.BOOTS) && e.getPlayer().getInventory().getBoots() == null)) {
                if (newArmorType.equals(null)) {
                    return;
                }
                if (e.getClickedBlock() == null || e.getClickedBlock() != null && !newArmorType.equals(null)) {
                    if (e.getClickedBlock() != null && (e.getClickedBlock().getType().equals((Object)Material.CHEST) || e.getClickedBlock().getType().equals((Object)Material.DISPENSER) || e.getClickedBlock().getType().equals((Object)Material.HOPPER) || e.getClickedBlock().getType().equals((Object)Material.STORAGE_MINECART) || e.getClickedBlock().getType().equals((Object)Material.HOPPER_MINECART) || e.getClickedBlock().getType().equals((Object)Material.ENCHANTMENT_TABLE) || e.getClickedBlock().getType().equals((Object)Material.FURNACE))) {
                        return;
                    }
                    ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent(e.getPlayer(), ArmorEquipEvent.EquipMethod.HOTBAR, newArmorType, e.getItem());
                    Bukkit.getServer().getPluginManager().callEvent((Event)armorEquipEvent);
                    if (armorEquipEvent.isCancelled()) {
                        e.setCancelled(true);
                        player.updateInventory();
                    } else {
                        return;
                    }
                }
            }
        }
    }

    @EventHandler
    public void dispenserFireEvent(BlockDispenseEvent e) {
        ArmorType type = ArmorType.matchType(e.getItem());
        if (ArmorType.matchType(e.getItem()) != null) {
            Location loc = e.getBlock().getLocation();
            for (Player p : loc.getWorld().getPlayers()) {
                org.bukkit.block.Dispenser dispenser;
                Dispenser dis;
                BlockFace directionFacing;
                if (loc.getBlockY() - p.getLocation().getBlockY() < -1 || loc.getBlockY() - p.getLocation().getBlockY() > 1 || !(p.getInventory().getHelmet() == null && type.equals((Object)ArmorType.HELMET) || p.getInventory().getChestplate() == null && type.equals((Object)ArmorType.CHESTPLATE) || p.getInventory().getLeggings() == null && type.equals((Object)ArmorType.LEGGINGS)) && (p.getInventory().getBoots() != null || !type.equals((Object)ArmorType.BOOTS)) || !((directionFacing = (dis = (Dispenser)(dispenser = (org.bukkit.block.Dispenser)e.getBlock().getState()).getData()).getFacing()) == BlockFace.EAST && p.getLocation().getBlockX() != loc.getBlockX() && p.getLocation().getX() <= loc.getX() + 2.3 && p.getLocation().getX() >= loc.getX() || directionFacing == BlockFace.WEST && p.getLocation().getX() >= loc.getX() - 1.3 && p.getLocation().getX() <= loc.getX() || directionFacing == BlockFace.SOUTH && p.getLocation().getBlockZ() != loc.getBlockZ() && p.getLocation().getZ() <= loc.getZ() + 2.3 && p.getLocation().getZ() >= loc.getZ()) && (directionFacing != BlockFace.NORTH || !(p.getLocation().getZ() >= loc.getZ() - 1.3) || !(p.getLocation().getZ() <= loc.getZ()))) continue;
                ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent(p, ArmorEquipEvent.EquipMethod.DISPENSER, ArmorType.matchType(e.getItem()), e.getItem());
                Bukkit.getServer().getPluginManager().callEvent((Event)armorEquipEvent);
                if (armorEquipEvent.isCancelled()) {
                    e.setCancelled(true);
                }
                return;
            }
        }
    }

    @EventHandler
    public void itemBreakEvent(PlayerItemBreakEvent e) {
        ArmorType type = ArmorType.matchType(e.getBrokenItem());
        if (type != null) {
            Player p = e.getPlayer();
            ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent(p, ArmorEquipEvent.EquipMethod.BROKE, type, e.getBrokenItem());
            Bukkit.getServer().getPluginManager().callEvent((Event)armorEquipEvent);
            if (armorEquipEvent.isCancelled()) {
                ItemStack i = e.getBrokenItem().clone();
                i.setAmount(1);
                i.setDurability((short)(i.getDurability() - 1));
                if (type.equals((Object)ArmorType.HELMET)) {
                    p.getInventory().setHelmet(i);
                } else if (type.equals((Object)ArmorType.CHESTPLATE)) {
                    p.getInventory().setChestplate(i);
                } else if (type.equals((Object)ArmorType.LEGGINGS)) {
                    p.getInventory().setLeggings(i);
                } else if (type.equals((Object)ArmorType.BOOTS)) {
                    p.getInventory().setBoots(i);
                }
            }
        }
    }

    @EventHandler
    public void playerDeathEvent(PlayerDeathEvent e) {
        Player p = e.getEntity();
        ItemStack[] itemStackArray = p.getInventory().getArmorContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack i = itemStackArray[n2];
            if (i != null && !i.getType().equals((Object)Material.AIR)) {
                ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent(p, ArmorEquipEvent.EquipMethod.DEATH, ArmorType.matchType(i), i);
                Bukkit.getServer().getPluginManager().callEvent((Event)armorEquipEvent);
            }
            ++n2;
        }
    }

    @EventHandler
    public void playerDragInventoryEvent(InventoryDragEvent e) {
        ArmorType newArmorType = ArmorType.matchType(e.getOldCursor());
        if (newArmorType == null) {
            return;
        }
        ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent((Player)e.getWhoClicked(), ArmorEquipEvent.EquipMethod.DRAG, newArmorType, e.getOldCursor());
        if (!e.getRawSlots().contains(newArmorType.getSlot())) {
            return;
        }
        Bukkit.getServer().getPluginManager().callEvent((Event)armorEquipEvent);
        if (armorEquipEvent.isCancelled()) {
            e.setCancelled(true);
        }
    }
}

