/*
 * Decompiled with CFR 0.152.
 */
package lib.PatPeter.SQLibrary;

import com.mysql.jdbc.jdbc2.optional.MysqlDataSource;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import lib.PatPeter.SQLibrary.DBMS;
import lib.PatPeter.SQLibrary.HostnameDatabase;
import lib.PatPeter.SQLibrary.StatementEnum;

public class MySQL
extends HostnameDatabase {
    @Deprecated
    public MySQL(Logger log, String prefix, String hostname, String port, String database, String username, String password) {
        super(log, prefix, DBMS.MySQL, hostname, Integer.parseInt(port), database, username, password);
    }

    public MySQL(Logger log, String prefix, String hostname, int port, String database, String username, String password) {
        super(log, prefix, DBMS.MySQL, hostname, port, database, username, password);
    }

    public MySQL(Logger log, String prefix, String database, String username, String password) {
        super(log, prefix, DBMS.MySQL, "localhost", 3306, database, username, password);
    }

    public MySQL(Logger log, String prefix, String database, String username) {
        super(log, prefix, DBMS.MySQL, "localhost", 3306, database, username, "");
    }

    public MySQL(Logger log, String prefix, String database) {
        super(log, prefix, DBMS.MySQL, "localhost", 3306, database, "", "");
    }

    @Override
    protected boolean initialize() {
        try {
            Class.forName("com.mysql.jdbc.jdbc2.optional.MysqlDataSource");
            return true;
        }
        catch (ClassNotFoundException e) {
            this.warning("MySQL DataSource class missing: " + e.getMessage() + ".");
            return false;
        }
    }

    @Override
    public boolean open() {
        String url;
        block3: {
            try {
                url = "jdbc:mysql://" + this.getHostname() + ":" + this.getPort() + "/" + this.getDatabase();
                if (!this.initialize()) break block3;
                MysqlDataSource ds = new MysqlDataSource();
                ds.setUrl(url);
                this.connection = ds.getConnection(this.getUsername(), this.getPassword());
                return true;
            }
            catch (SQLException e) {
                this.error("Could not establish a MySQL connection, SQLException: " + e.getMessage());
                return false;
            }
        }
        this.connection = DriverManager.getConnection(url, this.getUsername(), this.getPassword());
        return true;
    }

    @Override
    protected void queryValidation(StatementEnum statement) throws SQLException {
        switch ((Statements)statement) {
            case USE: {
                this.warning("Please create a new connection to use a different database.");
                throw new SQLException("Please create a new connection to use a different database.");
            }
            case PREPARE: 
            case EXECUTE: 
            case DEALLOCATE: {
                this.warning("Please use the prepare() method to prepare a query.");
                throw new SQLException("Please use the prepare() method to prepare a query.");
            }
        }
    }

    @Override
    public Statements getStatement(String query) throws SQLException {
        String[] statement = query.trim().split(" ", 2);
        try {
            Statements converted = Statements.valueOf(statement[0].toUpperCase());
            return converted;
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Unknown statement: \"" + statement[0] + "\".");
        }
    }

    @Deprecated
    public boolean createTable(String query) {
        Statement statement = null;
        if (query == null || query.equals("")) {
            this.writeError("Could not create table: query is empty or null.", true);
            return false;
        }
        try {
            statement = this.connection.createStatement();
            statement.execute(query);
            statement.close();
        }
        catch (SQLException e) {
            this.writeError("Could not create table, SQLException: " + e.getMessage(), true);
            return false;
        }
        return true;
    }

    @Override
    public boolean isTable(String table) {
        Statement statement;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException e) {
            this.error("Could not create a statement in checkTable(), SQLException: " + e.getMessage());
            return false;
        }
        try {
            statement.executeQuery("SELECT * FROM " + table);
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public boolean truncate(String table) {
        String query;
        Statement statement;
        block3: {
            statement = null;
            query = null;
            try {
                if (this.isTable(table)) break block3;
                this.error("Table \"" + table + "\" does not exist.");
                return false;
            }
            catch (SQLException e) {
                this.error("Could not wipe table, SQLException: " + e.getMessage());
                return false;
            }
        }
        statement = this.connection.createStatement();
        query = "DELETE FROM " + table + ";";
        statement.executeUpdate(query);
        statement.close();
        return true;
    }

    public static enum Statements implements StatementEnum
    {
        SELECT("SELECT"),
        INSERT("INSERT"),
        UPDATE("UPDATE"),
        DELETE("DELETE"),
        DO("DO"),
        REPLACE("REPLACE"),
        LOAD("LOAD"),
        HANDLER("HANDLER"),
        CALL("CALL"),
        CREATE("CREATE"),
        ALTER("ALTER"),
        DROP("DROP"),
        TRUNCATE("TRUNCATE"),
        RENAME("RENAME"),
        START("START"),
        COMMIT("COMMIT"),
        SAVEPOINT("SAVEPOINT"),
        ROLLBACK("ROLLBACK"),
        RELEASE("RELEASE"),
        LOCK("LOCK"),
        UNLOCK("UNLOCK"),
        PREPARE("PREPARE"),
        EXECUTE("EXECUTE"),
        DEALLOCATE("DEALLOCATE"),
        SET("SET"),
        SHOW("SHOW"),
        DESCRIBE("DESCRIBE"),
        EXPLAIN("EXPLAIN"),
        HELP("HELP"),
        USE("USE");

        private String string;

        private Statements(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }
    }
}

