/*
 * Decompiled with CFR 0.152.
 */
package lib.PatPeter.SQLibrary;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import lib.PatPeter.SQLibrary.Builders.Builder;
import lib.PatPeter.SQLibrary.DBMS;
import lib.PatPeter.SQLibrary.DatabaseException;
import lib.PatPeter.SQLibrary.StatementEnum;

public abstract class Database {
    protected Logger log;
    protected final String prefix;
    protected DBMS driver;
    protected Connection connection;
    protected Map<PreparedStatement, StatementEnum> preparedStatements = new HashMap<PreparedStatement, StatementEnum>();
    protected int lastUpdate;

    public Database(Logger log, String prefix, DBMS dbms) throws DatabaseException {
        if (log == null) {
            throw new DatabaseException("Logger cannot be null.");
        }
        if (prefix == null || prefix.length() == 0) {
            throw new DatabaseException("Plugin prefix cannot be null or empty.");
        }
        this.log = log;
        this.prefix = prefix;
        this.driver = dbms;
    }

    protected final String prefix(String message) {
        return String.valueOf(this.prefix) + (Object)((Object)this.driver) + message;
    }

    @Deprecated
    public final void writeInfo(String toWrite) {
        this.info(toWrite);
    }

    @Deprecated
    public final void writeError(String toWrite, boolean severe) {
        if (severe) {
            this.error(toWrite);
        } else {
            this.warning(toWrite);
        }
    }

    public final void info(String info) {
        if (info != null && !info.isEmpty()) {
            this.log.info(this.prefix(info));
        }
    }

    public final void warning(String warning) {
        if (warning != null && !warning.isEmpty()) {
            this.log.warning(this.prefix(warning));
        }
    }

    public final void error(String error) {
        if (error != null && !error.isEmpty()) {
            this.log.severe(this.prefix(error));
        }
    }

    protected abstract boolean initialize();

    public final DBMS getDriver() {
        return this.getDBMS();
    }

    public final DBMS getDBMS() {
        return this.driver;
    }

    public abstract boolean open();

    public final boolean close() {
        if (this.connection != null) {
            try {
                this.connection.close();
                return true;
            }
            catch (SQLException e) {
                this.writeError("Could not close connection, SQLException: " + e.getMessage(), true);
                return false;
            }
        }
        this.writeError("Could not close connection, it is null.", true);
        return false;
    }

    @Deprecated
    public final boolean isConnected() {
        return this.isOpen();
    }

    public final Connection getConnection() {
        return this.connection;
    }

    public final boolean isOpen() {
        return this.isOpen(1);
    }

    public final boolean isOpen(int seconds) {
        if (this.connection != null) {
            try {
                if (this.connection.isValid(seconds)) {
                    return true;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return false;
    }

    @Deprecated
    public final boolean checkConnection() {
        return this.isOpen();
    }

    public final int getLastUpdateCount() {
        return this.lastUpdate;
    }

    protected abstract void queryValidation(StatementEnum var1) throws SQLException;

    public final ResultSet query(String query) throws SQLException {
        int uc;
        this.queryValidation(this.getStatement(query));
        Statement statement = this.getConnection().createStatement();
        if (statement.execute(query)) {
            return statement.getResultSet();
        }
        this.lastUpdate = uc = statement.getUpdateCount();
        return this.getConnection().createStatement().executeQuery("SELECT " + uc);
    }

    protected final ResultSet query(PreparedStatement ps, StatementEnum statement) throws SQLException {
        int uc;
        this.queryValidation(statement);
        if (ps.execute()) {
            return ps.getResultSet();
        }
        this.lastUpdate = uc = ps.getUpdateCount();
        return this.connection.createStatement().executeQuery("SELECT " + uc);
    }

    public final ResultSet query(PreparedStatement ps) throws SQLException {
        ResultSet output = this.query(ps, this.preparedStatements.get(ps));
        this.preparedStatements.remove(ps);
        return output;
    }

    public final PreparedStatement prepare(String query) throws SQLException {
        StatementEnum s = this.getStatement(query);
        PreparedStatement ps = this.connection.prepareStatement(query);
        this.preparedStatements.put(ps, s);
        return ps;
    }

    public ArrayList<Long> insert(String query) throws SQLException {
        ArrayList<Long> keys = new ArrayList<Long>();
        PreparedStatement ps = this.connection.prepareStatement(query, 1);
        this.lastUpdate = ps.executeUpdate();
        ResultSet key = ps.getGeneratedKeys();
        if (key.next()) {
            keys.add(key.getLong(1));
        }
        return keys;
    }

    public ArrayList<Long> insert(PreparedStatement ps) throws SQLException {
        this.lastUpdate = ps.executeUpdate();
        this.preparedStatements.remove(ps);
        ArrayList<Long> keys = new ArrayList<Long>();
        ResultSet key = ps.getGeneratedKeys();
        if (key.next()) {
            keys.add(key.getLong(1));
        }
        return keys;
    }

    public final ResultSet query(Builder builder) throws SQLException {
        return this.query(builder.toString());
    }

    public abstract StatementEnum getStatement(String var1) throws SQLException;

    @Deprecated
    public boolean createTable() {
        return false;
    }

    @Deprecated
    public boolean checkTable(String table) {
        return this.isTable(table);
    }

    @Deprecated
    public boolean wipeTable(String table) {
        return this.truncate(table);
    }

    public abstract boolean isTable(String var1);

    public abstract boolean truncate(String var1);
}

