/*
 * Decompiled with CFR 0.152.
 */
package lib.PatPeter.SQLibrary;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Logger;
import lib.PatPeter.SQLibrary.DBMS;
import lib.PatPeter.SQLibrary.Database;
import lib.PatPeter.SQLibrary.Delegates.HostnameDatabase;
import lib.PatPeter.SQLibrary.Factory.DatabaseFactory;
import lib.PatPeter.SQLibrary.StatementEnum;

public class Ingres
extends Database {
    private HostnameDatabase delegate = DatabaseFactory.hostname();

    public Ingres(Logger log, String prefix, String hostname, int port, String database, String username, String password) {
        super(log, prefix, "[Ingres] ");
        this.setHostname(hostname);
        this.setPort(port);
        this.setDatabase(database);
        this.setUsername(username);
        this.setPassword(password);
        this.driver = DBMS.Ingres;
    }

    public Ingres(Logger log, String prefix, String database, String username, String password) {
        super(log, prefix, "[Ingres] ");
        this.setHostname("localhost");
        this.setPort(21017);
        this.setDatabase(database);
        this.setUsername(username);
        this.setPassword(password);
        this.driver = DBMS.Ingres;
    }

    public Ingres(Logger log, String prefix, String database, String username) {
        super(log, prefix, "[Ingres] ");
        this.setHostname("localhost");
        this.setPort(21017);
        this.setDatabase(database);
        this.setUsername(username);
        this.setPassword("");
        this.driver = DBMS.Ingres;
    }

    public Ingres(Logger log, String prefix, String database) {
        super(log, prefix, "[Ingres] ");
        this.setHostname("localhost");
        this.setPort(21017);
        this.setDatabase(database);
        this.setUsername("");
        this.setPassword("");
        this.driver = DBMS.Ingres;
    }

    public String getHostname() {
        return this.delegate.getHostname();
    }

    private void setHostname(String hostname) {
        this.delegate.setHostname(hostname);
    }

    public int getPort() {
        return this.delegate.getPort();
    }

    private void setPort(int port) {
        this.delegate.setPort(port);
    }

    public String getUsername() {
        return this.delegate.getUsername();
    }

    private void setUsername(String username) {
        this.delegate.setUsername(username);
    }

    private String getPassword() {
        return this.delegate.getPassword();
    }

    private void setPassword(String password) {
        this.delegate.setPassword(password);
    }

    public String getDatabase() {
        return this.delegate.getDatabase();
    }

    private void setDatabase(String database) {
        this.delegate.setDatabase(database);
    }

    @Override
    public boolean initialize() {
        try {
            Class.forName("com.ingres.jdbc.IngresDriver");
            return true;
        }
        catch (ClassNotFoundException e) {
            this.writeError("Ingres driver class missing: " + e.getMessage() + ".", true);
            return false;
        }
    }

    @Override
    public boolean open() {
        if (this.initialize()) {
            String url = "";
            url = "jdbc:ingres://" + this.getHostname() + ":" + this.getPort() + "/" + this.getDatabase();
            try {
                this.connection = DriverManager.getConnection(url, this.getUsername(), this.getPassword());
                return true;
            }
            catch (SQLException e) {
                this.writeError("Could not establish a Ingres connection, SQLException: " + e.getMessage(), true);
                return false;
            }
        }
        return false;
    }

    @Override
    protected void queryValidation(StatementEnum statement) throws SQLException {
    }

    @Override
    public Statements getStatement(String query) throws SQLException {
        String[] statement = query.trim().split(" ", 2);
        try {
            Statements converted = Statements.valueOf(statement[0].toUpperCase());
            return converted;
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Unknown statement: \"" + statement[0] + "\".");
        }
    }

    @Override
    public boolean isTable(String table) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean truncate(String table) {
        throw new UnsupportedOperationException();
    }

    protected static enum Statements implements StatementEnum
    {

    }
}

