/*
 * Decompiled with CFR 0.152.
 */
package lib.PatPeter.SQLibrary;

import java.io.File;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Logger;
import lib.PatPeter.SQLibrary.DBMS;
import lib.PatPeter.SQLibrary.Database;
import lib.PatPeter.SQLibrary.Delegates.FilenameDatabase;
import lib.PatPeter.SQLibrary.Factory.DatabaseFactory;
import lib.PatPeter.SQLibrary.StatementEnum;

public class H2
extends Database {
    private FilenameDatabase delegate = DatabaseFactory.filename();

    public H2(Logger log, String prefix, String directory, String filename) {
        super(log, prefix, "[H2] ");
        this.setFile(directory, filename);
        this.driver = DBMS.H2;
    }

    public H2(Logger log, String prefix, String directory, String filename, String extension) {
        super(log, prefix, "[H2] ");
        this.setFile(directory, filename, extension);
        this.driver = DBMS.H2;
    }

    private File getFile() {
        return this.delegate.getFile();
    }

    private void setFile(String directory, String filename) {
        this.delegate.setFile(directory, filename);
    }

    private void setFile(String directory, String filename, String extension) {
        this.delegate.setFile(directory, filename, extension);
    }

    @Override
    protected boolean initialize() {
        try {
            Class.forName("org.h2.Driver");
            return true;
        }
        catch (ClassNotFoundException e) {
            this.writeError("H2 driver class missing: " + e.getMessage() + ".", true);
            return false;
        }
    }

    @Override
    public boolean open() {
        if (this.initialize()) {
            try {
                this.connection = DriverManager.getConnection("jdbc:h2:file:" + this.getFile().getAbsolutePath());
                return true;
            }
            catch (SQLException e) {
                this.writeError("Could not establish an H2 connection, SQLException: " + e.getMessage(), true);
                return false;
            }
        }
        return false;
    }

    @Override
    protected void queryValidation(StatementEnum statement) throws SQLException {
    }

    @Override
    public StatementEnum getStatement(String query) throws SQLException {
        String[] statement = query.trim().split(" ", 2);
        try {
            Statements converted = Statements.valueOf(statement[0].toUpperCase());
            return converted;
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Unknown statement: \"" + statement[0] + "\".");
        }
    }

    @Override
    public boolean isTable(String table) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean truncate(String table) {
        throw new UnsupportedOperationException();
    }

    private static enum Statements implements StatementEnum
    {
        SELECT("SELECT"),
        INSERT("INSERT"),
        UPDATE("UPDATE"),
        DELETE("DELETE"),
        BACKUP("BACKUP"),
        CALL("CALL"),
        EXPLAIN("EXPLAIN"),
        MERGE("MERGE"),
        RUNSCRIPT("RUNSCRIPT"),
        SCRIPT("SCRIPT"),
        SHOW("SHOW"),
        ALTER("ALTER"),
        CONSTRAINT("CONSTRAINT"),
        ANALYZE("ANALYZE"),
        COMMENT("COMMENT"),
        CREATE("CREATE"),
        DROP("DROP"),
        TRUNCATE("TRUNCATE"),
        CHECKPOINT("CHECKPOINT"),
        COMMIT("COMMIT"),
        GRANT("GRANT"),
        HELP("HELP"),
        PREPARE("PREPARE"),
        REVOKE("REVOKE"),
        ROLLBACK("ROLLBACK"),
        SAVEPOINT("SAVEPOINT"),
        SET("SET"),
        SHUTDOWN("SHUTDOWN");

        private String string;

        private Statements(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }
    }
}

