/*
 * Decompiled with CFR 0.152.
 */
package lib.PatPeter.SQLibrary.Factory;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lib.PatPeter.SQLibrary.DBMS;

public enum Parameter {
    PREFIX(DBMS.Other),
    HOST(DBMS.MySQL, DBMS.MicrosoftSQL, DBMS.Oracle, DBMS.PostgreSQL),
    PORT(DBMS.MySQL, DBMS.MicrosoftSQL, DBMS.Oracle, DBMS.PostgreSQL),
    DATABASE(DBMS.MySQL, DBMS.MicrosoftSQL, DBMS.Oracle, DBMS.PostgreSQL),
    USERNAME(DBMS.MySQL, DBMS.MicrosoftSQL, DBMS.Oracle, DBMS.PostgreSQL),
    PASSWORD(DBMS.MySQL, DBMS.MicrosoftSQL, DBMS.Oracle, DBMS.PostgreSQL),
    LOCATION(DBMS.SQLite, DBMS.H2),
    FILENAME(DBMS.SQLite, DBMS.H2);

    private Set<DBMS> types = new HashSet<DBMS>();
    private static Map<DBMS, Integer> count;

    static {
        count = new EnumMap<DBMS, Integer>(DBMS.class);
    }

    private Parameter(DBMS ... type) {
        int i = 0;
        while (i < type.length) {
            this.types.add(type[i]);
            Parameter.updateCount(type[i]);
            ++i;
        }
    }

    public boolean validParam(DBMS check) {
        if (this.types.contains((Object)DBMS.Other)) {
            return true;
        }
        return this.types.contains((Object)check);
    }

    private static void updateCount(DBMS type) {
        Integer nb = count.get((Object)type);
        nb = nb == null ? Integer.valueOf(1) : Integer.valueOf(nb + 1);
        count.put(type, nb);
    }

    public static int getCount(DBMS type) {
        int nb = count.get((Object)DBMS.Other) + count.get((Object)type);
        return nb;
    }
}

