/*
 * Decompiled with CFR 0.152.
 */
package lib.PatPeter.SQLibrary.Factory;

import lib.PatPeter.SQLibrary.Database;
import lib.PatPeter.SQLibrary.Delegates.FilenameDatabase;
import lib.PatPeter.SQLibrary.Delegates.FilenameDatabaseImpl;
import lib.PatPeter.SQLibrary.Delegates.HostnameDatabase;
import lib.PatPeter.SQLibrary.Delegates.HostnameDatabaseImpl;
import lib.PatPeter.SQLibrary.Factory.DatabaseConfig;
import lib.PatPeter.SQLibrary.Factory.InvalidConfigurationException;
import lib.PatPeter.SQLibrary.Factory.Parameter;
import lib.PatPeter.SQLibrary.MySQL;
import lib.PatPeter.SQLibrary.SQLite;

public class DatabaseFactory {
    public static Database createDatabase(DatabaseConfig config) throws InvalidConfigurationException {
        if (!config.isValid()) {
            throw new InvalidConfigurationException("The configuration is invalid, you don't have enought parameters for that DB : " + (Object)((Object)config.getType()));
        }
        switch (config.getType()) {
            case MySQL: {
                return new MySQL(config.getLog(), config.getParameter(Parameter.PREFIX), config.getParameter(Parameter.HOST), Integer.parseInt(config.getParameter(Parameter.PORT)), config.getParameter(Parameter.DATABASE), config.getParameter(Parameter.USERNAME), config.getParameter(Parameter.PASSWORD));
            }
            case SQLite: {
                return new SQLite(config.getLog(), config.getParameter(Parameter.PREFIX), config.getParameter(Parameter.LOCATION), config.getParameter(Parameter.FILENAME));
            }
        }
        return null;
    }

    public static HostnameDatabase hostname() {
        return new HostnameDatabaseImpl();
    }

    public static FilenameDatabase filename() {
        return new FilenameDatabaseImpl();
    }
}

