/*
 * Decompiled with CFR 0.152.
 */
package lib.PatPeter.SQLibrary.Builders.MySQL;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import lib.PatPeter.SQLibrary.Builders.Builder;
import lib.PatPeter.SQLibrary.Builders.BuilderException;
import lib.PatPeter.SQLibrary.Database;
import lib.PatPeter.SQLibrary.DatabaseException;

public class Select
implements Builder {
    private Database db;
    private String[] conditionals = new String[]{"OR", "||", "XOR", "AND", "&&"};
    private HashSet<String> columns = new HashSet();
    private HashSet<String> tables = new HashSet();
    public Duplicates duplicates = null;
    public Cache cache = null;
    private boolean high = false;
    private boolean join = false;
    private boolean small = false;
    private boolean big = false;
    private boolean buffer = false;
    private boolean calc = false;
    private ArrayList<String> where = new ArrayList();
    private ArrayList<String> groupBy = new ArrayList();
    private ArrayList<String> having = new ArrayList();
    private ArrayList<String> orderBy = new ArrayList();
    private int[] limit = null;
    private String procedure = "";
    private Into into = null;
    private String file = "";
    private String charset = "";
    private String options = "";
    private HashSet<String> variables = new HashSet();
    private Boolean update = null;

    public Select(Database db) {
        this.setDatabase(db);
    }

    public Database getDatabase() {
        return this.db;
    }

    private void setDatabase(Database db) throws DatabaseException {
        if (db == null) {
            throw new DatabaseException("Database cannot be null in SELECT statement.");
        }
        this.db = db;
    }

    public ArrayList<String> getColumns() {
        return new ArrayList<String>(this.columns);
    }

    public Select columns(String ... columns) {
        int counter = 0;
        String[] stringArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            String column = stringArray[n2];
            if (column != null && column.length() != 0) {
                if (!column.contains("`")) {
                    this.columns.add(column);
                } else {
                    this.db.writeError("Column " + column + " in SELECT statement cannot have backticks.", false);
                }
            } else {
                this.db.writeError("Column at position " + counter + " cannot be null or empty in SELECT statement.", false);
            }
            ++counter;
            ++n2;
        }
        return this;
    }

    public ArrayList<String> getTables() {
        return new ArrayList<String>(this.tables);
    }

    public Select tables(String ... tables) {
        int counter = 0;
        String[] stringArray = tables;
        int n = tables.length;
        int n2 = 0;
        while (n2 < n) {
            String table = stringArray[n2];
            if (table != null && !table.isEmpty()) {
                if (!table.contains("`")) {
                    this.tables.add(table);
                } else {
                    this.db.writeError("Skipping table " + table + " in SELECT statement that has backticks.", false);
                }
            } else {
                this.db.writeError("Skipping table in SELECT statement at position " + counter + " for being null or empty.", false);
            }
            ++counter;
            ++n2;
        }
        return this;
    }

    public Select duplicates(Integer duplicates) {
        if (duplicates == null) {
            this.duplicates = null;
            return this;
        }
        this.duplicates = Duplicates.byID(duplicates);
        return this;
    }

    public Select high(boolean high) {
        this.high = high;
        return this;
    }

    public Select join(boolean join) {
        this.join = join;
        return this;
    }

    public Select small(boolean small) {
        this.small = small;
        return this;
    }

    public Select big(boolean big) {
        this.big = big;
        return this;
    }

    public Select buffer(boolean buffer) {
        this.buffer = buffer;
        return this;
    }

    public Select cache(Boolean cache) {
        if (cache == null) {
            this.cache = null;
            return this;
        }
        if (cache.booleanValue()) {
            this.cache = Cache.SQL_CACHE;
        } else if (!cache.booleanValue()) {
            this.cache = Cache.SQL_NO_CACHE;
        }
        return this;
    }

    public Select calc(boolean calc) {
        this.calc = calc;
        return this;
    }

    public Select where(String condition) {
        if (!this.checkCondition(condition)) {
            return this;
        }
        this.where.add(condition);
        return this;
    }

    public Select where(String conditional, String condition) {
        if (this.where.size() != 0) {
            if (!this.checkConditional(conditional)) {
                return this;
            }
        } else {
            this.db.writeError("Cannot add conditional " + conditional + " to the front of a WHERE statement.", false);
        }
        if (!this.checkCondition(condition)) {
            return this;
        }
        if (this.where.size() != 0) {
            this.where.add(conditional);
        }
        this.where.add(condition);
        return this;
    }

    public Select groupBy(String expression) {
        if (!this.validString(expression, "Skipping null or empty GROUP BY expression.")) {
            return this;
        }
        this.groupBy.add(expression);
        return this;
    }

    public Select groupBy(String expression, boolean ascending) {
        if (!this.validString(expression, "Skipping null or empty GROUP BY expression.")) {
            return this;
        }
        this.groupBy.add(expression);
        this.groupBy.add(ascending ? "ASC" : "DESC");
        return this;
    }

    public Select having(String condition) {
        if (!this.checkCondition(condition)) {
            return this;
        }
        this.having.add(condition);
        return this;
    }

    public Select having(String conditional, String condition) {
        if (this.having.size() != 0) {
            if (!this.checkConditional(conditional)) {
                return this;
            }
        } else {
            this.db.writeError("Cannot add conditional " + conditional + " to the front of a HAVING statement.", false);
        }
        if (!this.checkCondition(condition)) {
            return this;
        }
        if (this.having.size() != 0) {
            this.having.add(conditional);
        }
        this.having.add(condition);
        return this;
    }

    public Select orderBy(String expression) {
        if (!this.validString(expression, "Skipping null or empty ORDER BY expression.")) {
            return this;
        }
        this.orderBy.add(expression);
        return this;
    }

    public Select orderBy(String expression, boolean ascending) {
        if (!this.validString(expression, "Skipping null or empty ORDER BY expression.")) {
            return this;
        }
        this.orderBy.add(expression);
        this.orderBy.add(ascending ? "ASC" : "DESC");
        return this;
    }

    public Select limit(int rows) {
        this.limit = new int[2];
        this.limit[0] = 0;
        this.limit[1] = rows;
        return this;
    }

    public Select limit(int offset, int rows) {
        this.limit = new int[2];
        this.limit[0] = offset;
        this.limit[1] = rows;
        return this;
    }

    public Select limit() {
        this.limit = null;
        return null;
    }

    public Select procedure(String procedure) {
        if (!this.validString(procedure, "Skipped null or empty procedure.")) {
            return this;
        }
        this.procedure = procedure;
        return this;
    }

    public Select outfile(String filename) {
        this.into = Into.OUT;
        this.file = filename;
        this.charset = "";
        this.options = "";
        this.variables = new HashSet();
        return this;
    }

    public Select outfile(String filename, String options) {
        this.into = Into.OUT;
        this.file = filename;
        this.charset = "";
        this.options = options;
        this.variables = new HashSet();
        return this;
    }

    public Select outfile(String filename, String charset, String options) {
        this.into = Into.OUT;
        this.file = filename;
        this.charset = charset;
        this.options = options;
        this.variables = new HashSet();
        return this;
    }

    public Select dumpfile(String filename) {
        this.into = Into.DUMP;
        this.file = filename;
        this.variables = new HashSet();
        return this;
    }

    public Select into(String variable) {
        this.into = Into.VARIABLE;
        this.file = "";
        this.variables.add(variable);
        return this;
    }

    public Select update(Boolean update) {
        this.update = update;
        return this;
    }

    public String toString() {
        if (this.columns.isEmpty()) {
            throw new BuilderException("Cannot build SELECT statement");
        }
        String string = "SELECT " + (this.duplicates != null ? (Object)((Object)this.duplicates) + " " : "");
        string = String.valueOf(string) + (this.high ? "HIGH_PRIORITY " : "");
        string = String.valueOf(string) + (this.join ? "STRAIGHT_JOIN " : "");
        string = String.valueOf(string) + (this.small ? "SQL_SMALL_RESULT " : "");
        string = String.valueOf(string) + (this.big ? "SQL_BIG_RESULT " : "");
        string = String.valueOf(string) + (this.buffer ? "SQL_BUFFER_RESULT " : "");
        string = String.valueOf(string) + (this.cache != null ? (Object)((Object)this.cache) + " " : "");
        string = String.valueOf(string) + (this.calc ? "SQL_CALC_FOUND_ROWS " : "");
        string = String.valueOf(string) + this.addCommas(this.columns);
        if (!this.tables.isEmpty()) {
            string = String.valueOf(string) + this.addCommas(this.tables);
            if (!this.where.isEmpty()) {
                string = String.valueOf(string) + "WHERE ";
                for (String w : this.where) {
                    string = String.valueOf(string) + w + " ";
                }
            }
            if (!this.groupBy.isEmpty()) {
                string = String.valueOf(string) + "GROUP BY ";
                string = String.valueOf(string) + this.addCommas(this.groupBy);
            }
            if (!this.having.isEmpty()) {
                string = String.valueOf(string) + "HAVING ";
                for (String h : this.having) {
                    string = String.valueOf(string) + h + " ";
                }
            }
            if (!this.orderBy.isEmpty()) {
                string = String.valueOf(string) + "ORDER BY ";
                string = String.valueOf(string) + this.addCommas(this.orderBy);
            }
            if (this.limit != null) {
                string = String.valueOf(string) + "LIMIT " + this.limit[0] + ", " + this.limit[1];
            }
            if (this.procedure != "") {
                string = String.valueOf(string) + "PROCEDURE " + this.procedure;
            }
            switch (this.into) {
                case OUT: {
                    string = String.valueOf(string) + "INTO OUTFILE '" + this.file + "' ";
                    if (this.charset != "") {
                        string = String.valueOf(string) + "CHARACTER SET " + this.charset + " ";
                    }
                    string = String.valueOf(string) + this.options;
                    break;
                }
                case DUMP: {
                    string = String.valueOf(string) + "INTO DUMPFILE '" + this.file + "' ";
                    break;
                }
                case VARIABLE: {
                    string = String.valueOf(string) + "INTO ";
                    string = String.valueOf(string) + this.addCommas(this.variables);
                }
            }
            string = String.valueOf(string) + (this.update != null ? (this.update.booleanValue() ? "FOR UPDATE" : "LOCK IN SHARE MODE") : "");
        }
        return string;
    }

    public ResultSet execute() throws SQLException {
        if (this.columns.isEmpty()) {
            throw new BuilderException("Must specify at least one column in a SELECT statement.");
        }
        return this.db.query(this);
    }

    @Deprecated
    private boolean checkCondition(String condition) {
        if (condition == null || condition.length() == 0) {
            this.db.writeError("Skipping null or empty WHERE condition.", false);
            return false;
        }
        return true;
    }

    private boolean checkConditional(String conditional) {
        this.validString(conditional, "Skipping null or empty WHERE conditional.");
        String[] stringArray = this.conditionals;
        int n = this.conditionals.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            if (conditional.equals(c)) {
                return true;
            }
            ++n2;
        }
        this.db.writeError("Skipping unknown conditional " + conditional + ".", false);
        return false;
    }

    private boolean validString(String string, String error) {
        if (string == null || string.length() == 0) {
            this.db.writeError(error, false);
            return false;
        }
        return true;
    }

    private String addCommas(Collection<String> strings) {
        String output = "";
        boolean first = true;
        for (String string : strings) {
            if (first) {
                output = String.valueOf(output) + string;
                first = false;
                continue;
            }
            output = String.valueOf(output) + ", " + string;
        }
        return output;
    }

    private static enum Cache {
        SQL_CACHE,
        SQL_NO_CACHE;

    }

    private static enum Duplicates {
        ALL(0),
        DISTINCT(1),
        DISTINCTROW(2);

        private String[] strings = new String[]{"ALL", "DISTINCT", "DISTINCTROW"};
        private int id;

        private Duplicates(int id) {
            this.id = id;
        }

        public String toString() {
            return this.strings[this.id];
        }

        public static Duplicates byID(int id) throws BuilderException {
            if (id < 0 || 2 < id) {
                throw new BuilderException("Duplicates must be between 0 and 2.");
            }
            return Duplicates.values()[id];
        }
    }

    private static enum Into {
        OUT,
        DUMP,
        VARIABLE;

    }
}

