/*
 * Decompiled with CFR 0.152.
 */
package cheatchki.SKPermissionsEx.GroupCommands;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import cheatchki.SKPermissionsEx.SKPermissionsEx;
import javax.annotation.Nullable;
import org.bukkit.World;
import org.bukkit.event.Event;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.bukkit.PermissionsEx;

@Name(value="suffix of group")
@Description(value={"Gets the suffix of a PermissionsEx group"})
@Examples(value={"message \"%group \"\"admin\"\" suffix in world player's world%\"", "set group \"admin\" suffix to \"[admin]\"", "delete group \"admin\" suffix"})
@Since(value="0.4.0")
public class ExprSuffix
extends SimpleExpression<String> {
    private Expression<String> groupName;
    private Expression<World> world;

    static {
        Skript.registerExpression(ExprSuffix.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[pex] group %string% Suffix [in [world] %-world%]"});
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] arg0, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.groupName = arg0[0];
        this.world = arg0[1];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "[pex] group %string% Suffix [in [world] %-world%]";
    }

    @Nullable
    protected String[] get(Event arg0) {
        String groupName = (String)this.groupName.getSingle(arg0);
        String worldName = this.world != null ? ((World)this.world.getSingle(arg0)).getName() : null;
        PermissionGroup group = PermissionsEx.getPermissionManager().getGroup(groupName);
        if (group == null) {
            SKPermissionsEx.getInstance().getLogger().severe("Group " + groupName + " doesn't exist");
            return null;
        }
        return new String[]{group.getSuffix(worldName)};
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        String groupName = (String)this.groupName.getSingle(e);
        String worldName = this.world != null ? ((World)this.world.getSingle(e)).getName() : null;
        PermissionGroup group = PermissionsEx.getPermissionManager().getGroup(groupName);
        if (group == null) {
            SKPermissionsEx.getInstance().getLogger().severe("Group " + groupName + " doesn't exist");
            return;
        }
        if (mode == Changer.ChangeMode.SET) {
            String suffix = (String)delta[0];
            group.setSuffix(suffix, worldName);
        } else if (mode == Changer.ChangeMode.DELETE) {
            group.setSuffix(null, worldName);
        }
    }
}

