/*
 * Decompiled with CFR 0.152.
 */
package cheatchki.SKPermissionsEx.GroupCommands;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import cheatchki.SKPermissionsEx.SKPermissionsEx;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.World;
import org.bukkit.event.Event;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.bukkit.PermissionsEx;

@Name(value="permissions of group")
@Description(value={"Gets the permissions of a PermissionsEx group"})
@Examples(value={"message \"%group \"\"admin\"\" permissions in world player's world with parents%\"", "add \"test.perm\" to group \"admin\" permissions"})
@Since(value="0.4.0")
public class ExprPermission
extends SimpleExpression<String> {
    private Expression<String> groupName;
    private Expression<World> world;
    private boolean withParents;
    private Expression<Number> time;

    static {
        Skript.registerExpression(ExprPermission.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[pex] group %string% permission[s] [in [world] %-world%]", "[pex] group %string% permission[s] [in [world] %-world%] (with|includ(e|ing)) parents"});
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] arg0, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.groupName = arg0[0];
        this.world = arg0[1];
        this.withParents = arg1 == 1;
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "[pex] group %string% permission[s] [in %-world%] [(with|includ(e|ing)) parents]";
    }

    @Nullable
    protected String[] get(Event arg0) {
        String groupName = (String)this.groupName.getSingle(arg0);
        String worldName = this.world != null ? ((World)this.world.getSingle(arg0)).getName() : null;
        PermissionGroup group = PermissionsEx.getPermissionManager().getGroup(groupName);
        if (group == null) {
            SKPermissionsEx.getInstance().getLogger().severe("Group " + groupName + " doesn't exist");
            return null;
        }
        List permissions = this.withParents ? group.getPermissions(worldName) : group.getOwnPermissions(worldName);
        return permissions.toArray(new String[permissions.size()]);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        String groupName = (String)this.groupName.getSingle(e);
        String worldName = this.world != null ? ((World)this.world.getSingle(e)).getName() : null;
        PermissionGroup group = PermissionsEx.getPermissionManager().getGroup(groupName);
        if (group == null) {
            SKPermissionsEx.getInstance().getLogger().severe("Group " + groupName + " doesn't exist");
            return;
        }
        if (mode == Changer.ChangeMode.ADD) {
            String permission = (String)delta[0];
            group.addPermission(permission, worldName);
        } else if (mode == Changer.ChangeMode.REMOVE) {
            String permission = (String)delta[0];
            group.removePermission(permission, worldName);
        } else if (mode == Changer.ChangeMode.DELETE) {
            List permissions = group.getOwnPermissions(worldName);
            int i = permissions.size() - 1;
            while (i >= 0) {
                group.removePermission((String)permissions.get(i), worldName);
                --i;
            }
        }
    }
}

