/*
 * Decompiled with CFR 0.152.
 */
package cheatchki.SKPermissionsEx.GroupCommands;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import cheatchki.SKPermissionsEx.SKPermissionsEx;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.World;
import org.bukkit.event.Event;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.bukkit.PermissionsEx;

@Name(value="Group's users")
@Description(value={"Gets the users in a PermissionsEx group"})
@Examples(value={"message \"%group \"\"admin\"\" users%\"", "add player's name to group \"admin\" users in world player's world"})
@Since(value="0.4.0")
public class ExprGroupUsers
extends SimpleExpression<String> {
    private Expression<String> group;
    private Expression<World> world;

    static {
        Skript.registerExpression(ExprGroupUsers.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[pex] group %string% user[s] [in [world] %-world%]"});
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] arg0, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.group = arg0[0];
        this.world = arg0[1];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "[pex] group %string% user[s] [in [world] %-world%]";
    }

    @Nullable
    protected String[] get(Event arg0) {
        String groupName = (String)this.group.getSingle(arg0);
        String worldName = this.world != null ? ((World)this.world.getSingle(arg0)).getName() : null;
        Set users = PermissionsEx.getPermissionManager().getUsers(groupName, worldName);
        if (users == null) {
            SKPermissionsEx.getInstance().getLogger().severe("Group " + groupName + " doesn't exist");
            return null;
        }
        if (users.isEmpty()) {
            SKPermissionsEx.getInstance().getLogger().warning("Group " + groupName + " has no users.");
            return null;
        }
        ArrayList<String> userNames = new ArrayList<String>();
        for (PermissionUser user : users) {
            userNames.add(user.getName());
        }
        return userNames.toArray(new String[userNames.size()]);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        String worldName;
        String groupName = (String)this.group.getSingle(e);
        String string = worldName = this.world != null ? ((World)this.world.getSingle(e)).getName() : null;
        if (mode == Changer.ChangeMode.ADD) {
            String userName = (String)delta[0];
            PermissionUser user = PermissionsEx.getPermissionManager().getUser(userName);
            if (user == null) {
                SKPermissionsEx.getInstance().getLogger().severe("User " + userName + " doesn't exist.");
                return;
            }
            user.addGroup(groupName, worldName);
        } else if (mode == Changer.ChangeMode.REMOVE) {
            String userName = (String)delta[0];
            PermissionUser user = PermissionsEx.getPermissionManager().getUser(userName);
            if (user == null) {
                SKPermissionsEx.getInstance().getLogger().severe("User " + userName + " doesn't exist.");
                return;
            }
            user.removeGroup(groupName, worldName);
        } else if (mode == Changer.ChangeMode.DELETE) {
            Set users = PermissionsEx.getPermissionManager().getUsers(groupName, worldName);
            if (users == null) {
                SKPermissionsEx.getInstance().getLogger().severe("Group " + groupName + " doesn't exist");
                return;
            }
            if (users.isEmpty()) {
                SKPermissionsEx.getInstance().getLogger().warning("Group " + groupName + " has no users.");
                return;
            }
            for (PermissionUser user : users) {
                user.removeGroup(groupName, worldName);
            }
        }
    }
}

