/*
 * Decompiled with CFR 0.152.
 */
package cheatchki.SKPermissionsEx.GroupCommands;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import cheatchki.SKPermissionsEx.SKPermissionsEx;
import javax.annotation.Nullable;
import org.bukkit.World;
import org.bukkit.event.Event;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.bukkit.PermissionsEx;

@Name(value="Adding/removing timed permissions")
@Description(value={"Adds or removes a timed permission to a PermissionsEx group"})
@Examples(value={"group \"admin\" timed add \"test.timedPerm\" 50", "group \"mod\" timed remove \"coolperm.lamest\" in player's world"})
@Since(value="0.4.0")
public class EffTimedPermission
extends Effect {
    private Expression<String> groupName;
    private Expression<String> permissionName;
    private Expression<Number> time;
    private Expression<World> world;

    static {
        Skript.registerEffect(EffTimedPermission.class, (String[])new String[]{"[pex] group %string% timed add %string% %number% [in [world] %-world%]", "[pex] group %string% timed remove %string% [in [world] %-world%]"});
    }

    public boolean init(Expression<?>[] arg0, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.groupName = arg0[0];
        this.permissionName = arg0[1];
        this.time = arg1 == 0 ? arg0[2] : null;
        this.world = arg0[arg1 == 0 ? 3 : 2];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "[pex] group %string% timed (add|removed) %string% [%number%] [in [world] %world%]";
    }

    protected void execute(Event arg0) {
        String groupName = (String)this.groupName.getSingle(arg0);
        String permissionName = (String)this.permissionName.getSingle(arg0);
        Integer time = this.time != null ? Integer.valueOf(((Number)this.time.getSingle(arg0)).intValue()) : null;
        String worldName = this.world != null ? ((World)this.world.getSingle(arg0)).getName() : null;
        PermissionGroup group = PermissionsEx.getPermissionManager().getGroup(groupName);
        if (group == null) {
            SKPermissionsEx.getInstance().getLogger().severe("Group " + groupName + " doesn't exist.");
            return;
        }
        if (time != null) {
            group.addTimedPermission(permissionName, worldName, time.intValue());
        } else {
            group.removeTimedPermission(permissionName, worldName);
        }
    }
}

