/*
 * Decompiled with CFR 0.152.
 */
package cheatchki.SKPermissionsEx.GroupCommands;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import cheatchki.SKPermissionsEx.SKPermissionsEx;
import javax.annotation.Nullable;
import org.bukkit.World;
import org.bukkit.event.Event;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.bukkit.PermissionsEx;

@Name(value="Get option of group")
@Description(value={"Gets the option of a PermissionsEx group"})
@Examples(value={"message \"%group \"\"admin\"\" option \"\"rank-ladder\"\" in world player's world%\"", "set group \"admin\" option \"rank-ladder\" to \"default\""})
@Since(value="0.4.0")
public class ExprOption
extends SimpleExpression<String> {
    private Expression<String> groupName;
    private Expression<String> optionName;
    private Expression<World> world;

    static {
        Skript.registerExpression(ExprOption.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"pex group %string% option %string% [in [world] %-world%]"});
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] arg0, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.groupName = arg0[0];
        this.optionName = arg0[1];
        this.world = arg0[2];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "pex group %string% option %string% [in [world] %-world%]";
    }

    @Nullable
    protected String[] get(Event arg0) {
        String groupName = (String)this.groupName.getSingle(arg0);
        String optionName = (String)this.optionName.getSingle(arg0);
        String worldName = this.world != null ? ((World)this.world.getSingle(arg0)).getName() : null;
        PermissionGroup group = PermissionsEx.getPermissionManager().getGroup(groupName);
        if (group == null) {
            SKPermissionsEx.getInstance().getLogger().severe("Group " + groupName + " doesn't exist");
            return null;
        }
        return new String[]{group.getOption(optionName)};
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        String groupName = (String)this.groupName.getSingle(e);
        String optionName = (String)this.optionName.getSingle(e);
        String worldName = this.world != null ? ((World)this.world.getSingle(e)).getName() : null;
        PermissionGroup group = PermissionsEx.getPermissionManager().getGroup(groupName);
        if (group == null) {
            SKPermissionsEx.getInstance().getLogger().severe("Group " + groupName + " doesn't exist");
            return;
        }
        String optionValue = (String)delta[0];
        group.setOption(optionName, optionValue, worldName);
    }
}

