/*
 * Decompiled with CFR 0.152.
 */
package cheatchki.SKPermissionsEx.GroupCommands;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import cheatchki.SKPermissionsEx.SKPermissionsEx;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.bukkit.PermissionsEx;

@Name(value="Get All Groups")
@Description(value={"Gets all groups currently registered by PermissionsEx"})
@Examples(value={"message \"%pex groups\"", "add \"testGroup\" to groups", "delete pex groups"})
@Since(value="0.4.0")
public class ExprGroup
extends SimpleExpression<String> {
    static {
        Skript.registerExpression(ExprGroup.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[pex] group[s]"});
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] arg0, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "[pex] group[s]";
    }

    @Nullable
    protected String[] get(Event arg0) {
        ArrayList<String> groups = new ArrayList<String>();
        for (PermissionGroup g : PermissionsEx.getPermissionManager().getGroupList()) {
            groups.add(g.getName());
        }
        return groups.toArray(new String[groups.size()]);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD) {
            this.addGroup((String)delta[0]);
        } else if (mode == Changer.ChangeMode.REMOVE) {
            this.removeGroup((String)delta[0]);
        } else if (mode == Changer.ChangeMode.DELETE) {
            for (PermissionGroup g : PermissionsEx.getPermissionManager().getGroupList()) {
                this.removeGroup(g.getName());
            }
        }
    }

    private void addGroup(String groupName) {
        PermissionGroup group = PermissionsEx.getPermissionManager().getGroup(groupName);
        if (group == null) {
            SKPermissionsEx.getInstance().getLogger().severe("Group " + groupName + " doesn't exist");
            return;
        }
        if (!group.isVirtual()) {
            SKPermissionsEx.getInstance().getLogger().severe("Group " + groupName + " already exist");
            return;
        }
        group.save();
    }

    private void removeGroup(String groupName) {
        PermissionGroup group = PermissionsEx.getPermissionManager().getGroup(groupName);
        if (group == null) {
            SKPermissionsEx.getInstance().getLogger().severe("Group " + groupName + " doesn't exist");
            return;
        }
        group.remove();
        PermissionsEx.getPermissionManager().resetGroup(group.getIdentifier());
    }
}

