/*
 * Decompiled with CFR 0.152.
 */
package cheatchki.SKPermissionsEx.GroupCommands;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import cheatchki.SKPermissionsEx.SKPermissionsEx;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.bukkit.World;
import org.bukkit.event.Event;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.bukkit.PermissionsEx;

@Name(value="Get default group(s)")
@Description(value={"Gets the default PermissionsEx group(s)"})
@Examples(value={"message \"%default group in world player's world%\"", "set default group \"admin\" to true"})
@Since(value="0.4.0")
public class ExprDefault
extends SimpleExpression<String> {
    private Expression<String> groupName;
    private Expression<World> world;

    static {
        Skript.registerExpression(ExprDefault.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[pex] default group[s] [%-string%] [in [world] %-world%]"});
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] arg0, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.world = arg0[1];
        this.groupName = arg0[0];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "[pex] default group [in [world] %-world%]";
    }

    @Nullable
    protected String[] get(Event arg0) {
        String worldName = this.world != null ? ((World)this.world.getSingle(arg0)).getName() : null;
        ArrayList<String> groups = new ArrayList<String>();
        for (PermissionGroup defaultGroup : PermissionsEx.getPermissionManager().getDefaultGroups(worldName)) {
            groups.add(defaultGroup.getName());
        }
        return groups.toArray(new String[groups.size()]);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        String worldName = this.world != null ? ((World)this.world.getSingle(e)).getName() : null;
        String groupName = this.groupName != null ? (String)this.groupName.getSingle(e) : null;
        PermissionGroup group = PermissionsEx.getPermissionManager().getGroup(groupName);
        if (group == null) {
            SKPermissionsEx.getInstance().getLogger().severe("Group " + groupName + " doesn't exist");
            return;
        }
        if (mode == Changer.ChangeMode.SET) {
            boolean val = (Boolean)delta[0];
            group.setDefault(val, worldName);
        }
    }
}

