/*
 * Decompiled with CFR 0.152.
 */
package com.republicansensei.repuska.util.nbt;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.coll.CollectionUtils;
import ch.njol.yggdrasil.Fields;
import com.republicansensei.repuska.Repuska;
import com.republicansensei.repuska.util.nbt.NMSInterface;
import com.republicansensei.repuska.util.nbt.ReflectionUtils;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.annotation.Nullable;
import net.minecraft.server.v1_11_R1.BlockPosition;
import net.minecraft.server.v1_11_R1.EntityInsentient;
import net.minecraft.server.v1_11_R1.EntityLiving;
import net.minecraft.server.v1_11_R1.IBlockData;
import net.minecraft.server.v1_11_R1.Item;
import net.minecraft.server.v1_11_R1.ItemStack;
import net.minecraft.server.v1_11_R1.MinecraftKey;
import net.minecraft.server.v1_11_R1.MojangsonParseException;
import net.minecraft.server.v1_11_R1.MojangsonParser;
import net.minecraft.server.v1_11_R1.NBTBase;
import net.minecraft.server.v1_11_R1.NBTCompressedStreamTools;
import net.minecraft.server.v1_11_R1.NBTTagByte;
import net.minecraft.server.v1_11_R1.NBTTagCompound;
import net.minecraft.server.v1_11_R1.NBTTagDouble;
import net.minecraft.server.v1_11_R1.NBTTagFloat;
import net.minecraft.server.v1_11_R1.NBTTagInt;
import net.minecraft.server.v1_11_R1.NBTTagList;
import net.minecraft.server.v1_11_R1.NBTTagLong;
import net.minecraft.server.v1_11_R1.NBTTagShort;
import net.minecraft.server.v1_11_R1.NBTTagString;
import net.minecraft.server.v1_11_R1.PathfinderGoal;
import net.minecraft.server.v1_11_R1.PathfinderGoalSelector;
import net.minecraft.server.v1_11_R1.TileEntity;
import net.minecraft.server.v1_11_R1.WorldServer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_11_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_11_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_11_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_11_R1.inventory.CraftItemStack;
import org.bukkit.entity.Entity;

public class NMS_v1_11_R1
implements NMSInterface {
    @Override
    public Object getNBTTag(Object compound, String tag) {
        if (compound instanceof NBTTagCompound) {
            return ((NBTTagCompound)compound).get(tag);
        }
        return null;
    }

    @Override
    public void setNBTTag(Object compound, String tag, Object toSet) {
        if (compound instanceof NBTTagCompound && (toSet instanceof NBTBase || toSet instanceof Number || toSet instanceof String)) {
            Object converted = null;
            converted = toSet instanceof Number ? this.convertToNBT((Number)toSet) : (toSet instanceof String ? this.convertToNBT((String)toSet) : (NBTBase)toSet);
            ((NBTTagCompound)compound).set(tag, converted);
        }
    }

    @Override
    public void removeNBTTag(Object compound, String tag) {
        if (compound instanceof NBTTagCompound) {
            ((NBTTagCompound)compound).remove(tag);
        }
    }

    @Override
    public byte getTypeId(Object nbtBase) {
        if (nbtBase instanceof NBTBase) {
            return ((NBTBase)nbtBase).getTypeId();
        }
        return 0;
    }

    @Override
    public Object getNBTTagValue(Object compound, String tag, byte typeId) {
        if (compound instanceof NBTTagCompound) {
            switch (typeId) {
                case 1: {
                    return ((NBTTagCompound)compound).getByte(tag);
                }
                case 2: {
                    return ((NBTTagCompound)compound).getShort(tag);
                }
                case 3: {
                    return ((NBTTagCompound)compound).getInt(tag);
                }
                case 4: {
                    return ((NBTTagCompound)compound).getLong(tag);
                }
                case 5: {
                    return Float.valueOf(((NBTTagCompound)compound).getFloat(tag));
                }
                case 6: {
                    return ((NBTTagCompound)compound).getDouble(tag);
                }
                case 7: {
                    break;
                }
                case 8: {
                    return ((NBTTagCompound)compound).getString(tag);
                }
                case 9: {
                    NBTTagList list = null;
                    int i = 1;
                    while (i <= 11) {
                        list = ((NBTTagCompound)compound).getList(tag, i);
                        if (!list.isEmpty()) break;
                        ++i;
                    }
                    return list;
                }
                case 10: {
                    return ((NBTTagCompound)compound).getCompound(tag);
                }
                case 11: {
                    return ((NBTTagCompound)compound).getIntArray(tag);
                }
            }
        }
        return null;
    }

    @Override
    public void addToCompound(Object compound, Object toAdd) {
        if (compound instanceof NBTTagCompound && toAdd instanceof NBTTagCompound) {
            ((NBTTagCompound)compound).a((NBTTagCompound)toAdd);
        }
    }

    @Override
    public void removeFromCompound(Object compound, String ... toRemove) {
        if (compound instanceof NBTTagCompound) {
            String[] stringArray = toRemove;
            int n = toRemove.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                ((NBTTagCompound)compound).remove(s);
                ++n2;
            }
        }
    }

    public NBTTagCompound parseRawNBT(String rawNBT) {
        NBTTagCompound parsedNBT = null;
        try {
            parsedNBT = MojangsonParser.parse((String)rawNBT);
        }
        catch (MojangsonParseException ex) {
            Repuska.severe("NBT Tag Error! ( " + rawNBT + " )");
            return null;
        }
        return parsedNBT;
    }

    @Override
    public Object[] getContents(Object nbtList) {
        if (nbtList instanceof NBTTagList) {
            Object[] contents = new Object[((NBTTagList)nbtList).size()];
            int i = 0;
            while (i < ((NBTTagList)nbtList).size()) {
                if (this.getIndex(nbtList, i) != null) {
                    contents[i] = this.getIndex(nbtList, i);
                }
                ++i;
            }
            return contents;
        }
        return null;
    }

    @Override
    public void addToList(Object nbtList, Object toAdd) {
        if (nbtList instanceof NBTTagList && toAdd instanceof NBTBase) {
            ((NBTTagList)nbtList).add((NBTBase)toAdd);
        }
    }

    @Override
    public void removeFromList(Object nbtList, int index) {
        if (nbtList instanceof NBTTagList && index >= 0 && index < ((NBTTagList)nbtList).size()) {
            ((NBTTagList)nbtList).remove(index);
        }
    }

    @Override
    public void setIndex(Object nbtList, int index, Object toSet) {
        if (nbtList instanceof NBTTagList && index >= 0 && index < ((NBTTagList)nbtList).size()) {
            if (toSet instanceof NBTBase) {
                ((NBTTagList)nbtList).a(index, (NBTBase)toSet);
            } else if (toSet instanceof Number) {
                ((NBTTagList)nbtList).a(index, this.convertToNBT((Number)toSet));
            } else if (toSet instanceof String) {
                ((NBTTagList)nbtList).a(index, (NBTBase)this.convertToNBT((String)toSet));
            }
        }
    }

    @Override
    public Object getIndex(Object nbtList, int index) {
        if (nbtList instanceof NBTTagList && index >= 0 && index < ((NBTTagList)nbtList).size()) {
            NBTBase value = ((NBTTagList)nbtList).h(index);
            if (value instanceof NBTTagByte) {
                return ((NBTTagByte)value).g();
            }
            if (value instanceof NBTTagShort) {
                return ((NBTTagShort)value).f();
            }
            if (value instanceof NBTTagInt) {
                return ((NBTTagInt)value).e();
            }
            if (value instanceof NBTTagLong) {
                return ((NBTTagLong)value).d();
            }
            if (value instanceof NBTTagFloat) {
                return Float.valueOf(((NBTTagFloat)value).i());
            }
            if (value instanceof NBTTagDouble) {
                return ((NBTTagDouble)value).asDouble();
            }
            if (value instanceof NBTTagString) {
                return ((NBTTagString)value).c_();
            }
            if (value instanceof NBTBase) {
                return value;
            }
        }
        return null;
    }

    @Override
    public void clearPathfinderGoals(Entity entity) {
        EntityInsentient nmsEnt = (EntityInsentient)((CraftEntity)entity).getHandle();
        ((LinkedHashSet)ReflectionUtils.getField("b", PathfinderGoalSelector.class, nmsEnt.goalSelector)).clear();
        ((LinkedHashSet)ReflectionUtils.getField("c", PathfinderGoalSelector.class, nmsEnt.goalSelector)).clear();
        ((LinkedHashSet)ReflectionUtils.getField("b", PathfinderGoalSelector.class, nmsEnt.targetSelector)).clear();
        ((LinkedHashSet)ReflectionUtils.getField("c", PathfinderGoalSelector.class, nmsEnt.targetSelector)).clear();
    }

    @Override
    public void removePathfinderGoal(Object entity, Class<?> goalClass, boolean isTargetSelector) {
        block4: {
            if (!(entity instanceof EntityInsentient)) break block4;
            ((EntityInsentient)entity).setGoalTarget(null);
            if (isTargetSelector) {
                Iterator goals = ((LinkedHashSet)ReflectionUtils.getField("b", PathfinderGoalSelector.class, ((EntityInsentient)entity).targetSelector)).iterator();
                while (goals.hasNext()) {
                    Object goal = goals.next();
                    if (ReflectionUtils.getField("a", goal.getClass(), goal).getClass() != goalClass) continue;
                    goals.remove();
                }
            } else {
                Iterator goals = ((LinkedHashSet)ReflectionUtils.getField("b", PathfinderGoalSelector.class, ((EntityInsentient)entity).goalSelector)).iterator();
                while (goals.hasNext()) {
                    Object goal = goals.next();
                    if (ReflectionUtils.getField("a", goal.getClass(), goal).getClass() != goalClass) continue;
                    goals.remove();
                }
            }
        }
    }

    @Override
    public void addPathfinderGoal(Object entity, int priority, Object goal, boolean isTargetSelector) {
        if (entity instanceof EntityInsentient && goal instanceof PathfinderGoal) {
            if (isTargetSelector) {
                ((EntityInsentient)entity).targetSelector.a(priority, (PathfinderGoal)goal);
            } else {
                ((EntityInsentient)entity).goalSelector.a(priority, (PathfinderGoal)goal);
            }
        }
    }

    @Override
    public void registerCompoundClassInfo() {
        Classes.registerClass((ClassInfo)new ClassInfo(NBTTagCompound.class, "compound").user(new String[]{"((nbt)?( ?tag)?) ?compounds?"}).name("NBT Compound").changer((Changer)new Changer<NBTTagCompound>(){

            @Nullable
            public Class<?>[] acceptChange(Changer.ChangeMode mode) {
                if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
                    return (Class[])CollectionUtils.array((Object[])new Class[]{String.class, NBTTagCompound.class});
                }
                return null;
            }

            public void change(NBTTagCompound[] NBT, @Nullable Object[] delta, Changer.ChangeMode mode) {
                if (mode == Changer.ChangeMode.ADD) {
                    if (delta[0] instanceof String) {
                        NBTTagCompound parsedNBT = NMS_v1_11_R1.this.parseRawNBT((String)delta[0]);
                        NMS_v1_11_R1.this.addToCompound(NBT[0], parsedNBT);
                    } else {
                        NMS_v1_11_R1.this.addToCompound(NBT[0], delta[0]);
                    }
                } else if (mode == Changer.ChangeMode.REMOVE) {
                    if (delta[0] instanceof NBTTagCompound) {
                        return;
                    }
                    Object[] objectArray = delta;
                    int n = delta.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object s = objectArray[n2];
                        NBT[0].remove((String)s);
                        ++n2;
                    }
                }
            }
        }).parser((Parser)new Parser<NBTTagCompound>(){

            public String getVariableNamePattern() {
                return ".+";
            }

            @Nullable
            public NBTTagCompound parse(String rawNBT, ParseContext context) {
                if (rawNBT.startsWith("nbt:{") && rawNBT.endsWith("}")) {
                    NBTTagCompound NBT = NMS_v1_11_R1.this.parseRawNBT(rawNBT.substring(4));
                    return NBT;
                }
                return null;
            }

            public String toString(NBTTagCompound compound, int arg1) {
                return compound.toString();
            }

            public String toVariableNameString(NBTTagCompound compound) {
                return compound.toString();
            }
        }).serializer((Serializer)new Serializer<NBTTagCompound>(){

            public Fields serialize(NBTTagCompound compound) throws NotSerializableException {
                Fields f = new Fields();
                f.putObject("asString", (Object)compound.toString());
                return f;
            }

            public void deserialize(NBTTagCompound compound, Fields f) throws StreamCorruptedException, NotSerializableException {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            protected boolean canBeInstantiated() {
                return false;
            }

            protected NBTTagCompound deserialize(Fields fields) throws StreamCorruptedException, NotSerializableException {
                String raw = (String)fields.getObject("asString", String.class);
                NBTTagCompound compound = NMS_v1_11_R1.this.parseRawNBT(raw);
                if (compound == null) {
                    throw new StreamCorruptedException("Unable to parse NBT from a variable: " + raw);
                }
                return compound;
            }

            @Nullable
            public NBTTagCompound deserialize(String s) {
                NBTTagCompound compound = NMS_v1_11_R1.this.parseRawNBT(s);
                return compound;
            }

            public boolean mustSyncDeserialization() {
                return true;
            }
        }));
    }

    @Override
    public void registerNBTListClassInfo() {
        Classes.registerClass((ClassInfo)new ClassInfo(NBTTagList.class, "nbtlist").user(new String[]{"nbt ?list ?(tag)?"}).name("NBT List").changer((Changer)new Changer<NBTTagList>(){

            @Nullable
            public Class<?>[] acceptChange(Changer.ChangeMode mode) {
                if (mode == Changer.ChangeMode.ADD) {
                    return (Class[])CollectionUtils.array((Object[])new Class[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, NBTTagCompound.class, NBTTagList.class});
                }
                return null;
            }

            public void change(NBTTagList[] nbtList, @Nullable Object[] delta, Changer.ChangeMode mode) {
                if (delta.length == 0) {
                    return;
                }
                if (delta[0] instanceof Number) {
                    NMS_v1_11_R1.this.addToList(nbtList[0], NMS_v1_11_R1.this.convertToNBT((Number)delta[0]));
                } else if (delta[0] instanceof String) {
                    NMS_v1_11_R1.this.addToList(nbtList[0], NMS_v1_11_R1.this.convertToNBT((String)delta[0]));
                } else if (delta[0] instanceof NBTBase) {
                    NMS_v1_11_R1.this.addToList(nbtList[0], delta[0]);
                }
            }
        }).parser((Parser)new Parser<NBTTagList>(){

            public String getVariableNamePattern() {
                return ".+";
            }

            @Nullable
            public NBTTagList parse(String listString, ParseContext context) {
                if ((listString.startsWith("nbt:[") || listString.startsWith("nbtlist:[")) && listString.endsWith("]")) {
                    int substring = listString.startsWith("nbt:[") ? 4 : 8;
                    NBTTagCompound tempNBT = NMS_v1_11_R1.this.parseRawNBT("{temp:" + listString.substring(substring) + "}");
                    NBTTagList parsedList = (NBTTagList)tempNBT.get("temp");
                    return parsedList;
                }
                return null;
            }

            public String toString(NBTTagList nbtList, int arg1) {
                return nbtList.toString();
            }

            public String toVariableNameString(NBTTagList nbtList) {
                return nbtList.toString();
            }
        }).serializer((Serializer)new Serializer<NBTTagList>(){

            public Fields serialize(NBTTagList nbtList) throws NotSerializableException {
                Fields f = new Fields();
                f.putObject("asString", (Object)nbtList.toString());
                return f;
            }

            public void deserialize(NBTTagList nbtList, Fields f) throws StreamCorruptedException, NotSerializableException {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            protected boolean canBeInstantiated() {
                return false;
            }

            protected NBTTagList deserialize(Fields fields) throws StreamCorruptedException, NotSerializableException {
                String s = (String)fields.getObject("asString", String.class);
                NBTTagCompound tempNBT = NMS_v1_11_R1.this.parseRawNBT("{temp:" + s + "}");
                if (tempNBT == null || !tempNBT.hasKey("temp")) {
                    throw new StreamCorruptedException("Unable to parse NBT list from a variable: " + s);
                }
                NBTTagList nbtList = (NBTTagList)tempNBT.get("temp");
                return nbtList;
            }

            @Nullable
            public NBTTagList deserialize(String s) {
                NBTTagCompound tempNBT = NMS_v1_11_R1.this.parseRawNBT("{temp:" + s + "}");
                NBTTagList nbtList = (NBTTagList)tempNBT.get("temp");
                return nbtList;
            }

            public boolean mustSyncDeserialization() {
                return true;
            }
        }));
    }

    public NBTTagCompound getEntityNBT(Entity entity) {
        net.minecraft.server.v1_11_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        NBTTagCompound NBT = new NBTTagCompound();
        nmsEntity.e(NBT);
        return NBT;
    }

    public NBTTagCompound getTileNBT(Block block) {
        NBTTagCompound NBT = new NBTTagCompound();
        WorldServer nmsWorld = ((CraftWorld)block.getWorld()).getHandle();
        TileEntity tileEntity = nmsWorld.getTileEntity(new BlockPosition(block.getX(), block.getY(), block.getZ()));
        if (tileEntity == null) {
            return null;
        }
        tileEntity.save(NBT);
        return NBT;
    }

    public NBTTagCompound getItemNBT(org.bukkit.inventory.ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return null;
        }
        NBTTagCompound itemNBT = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)itemStack).getTag();
        if (itemNBT == null) {
            itemNBT = new NBTTagCompound();
        }
        return itemNBT;
    }

    @Override
    public void setEntityNBT(Entity entity, Object newCompound) {
        if (newCompound instanceof NBTTagCompound) {
            net.minecraft.server.v1_11_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
            nmsEntity.f((NBTTagCompound)newCompound);
        }
    }

    @Override
    public void setTileNBT(Block block, Object newCompound) {
        if (newCompound instanceof NBTTagCompound) {
            WorldServer nmsWorld = ((CraftWorld)block.getWorld()).getHandle();
            TileEntity tileEntity = nmsWorld.getTileEntity(new BlockPosition(block.getX(), block.getY(), block.getZ()));
            if (tileEntity == null) {
                return;
            }
            tileEntity.a((NBTTagCompound)newCompound);
            tileEntity.update();
            IBlockData tileEntType = nmsWorld.getType(new BlockPosition(block.getX(), block.getY(), block.getZ()));
            nmsWorld.notify(tileEntity.getPosition(), tileEntType, tileEntType, 3);
        }
    }

    @Override
    public org.bukkit.inventory.ItemStack getItemWithNBT(org.bukkit.inventory.ItemStack itemStack, Object compound) {
        ItemStack nmsItem = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)itemStack);
        if (compound instanceof NBTTagCompound && itemStack != null) {
            if (itemStack.getType() == Material.AIR) {
                return null;
            }
            if (((NBTTagCompound)compound).isEmpty()) {
                return itemStack;
            }
            nmsItem.setTag((NBTTagCompound)compound);
            org.bukkit.inventory.ItemStack newItem = CraftItemStack.asBukkitCopy((ItemStack)nmsItem);
            return newItem;
        }
        if (compound == null) {
            nmsItem.setTag(null);
            org.bukkit.inventory.ItemStack newItem = CraftItemStack.asBukkitCopy((ItemStack)nmsItem);
            return newItem;
        }
        return itemStack;
    }

    public NBTTagCompound getFileNBT(File file) {
        NBTTagCompound fileNBT;
        block4: {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
            }
            catch (FileNotFoundException ex) {
                return null;
            }
            fileNBT = null;
            try {
                fileNBT = NBTCompressedStreamTools.a((InputStream)fis);
                fis.close();
            }
            catch (IOException ex) {
                if (ex instanceof EOFException) break block4;
                ex.printStackTrace();
            }
        }
        return fileNBT;
    }

    @Override
    public void setFileNBT(File file, Object newCompound) {
        block5: {
            if (newCompound instanceof NBTTagCompound) {
                FileOutputStream os = null;
                try {
                    os = new FileOutputStream(file);
                }
                catch (FileNotFoundException ex) {
                    ex.printStackTrace();
                }
                try {
                    NBTCompressedStreamTools.a((NBTTagCompound)((NBTTagCompound)newCompound), (OutputStream)os);
                    ((OutputStream)os).close();
                }
                catch (IOException ex) {
                    if (ex instanceof EOFException) break block5;
                    ex.printStackTrace();
                }
            }
        }
    }

    public NBTBase convertToNBT(Number number) {
        if (number instanceof Byte) {
            return new NBTTagByte(((Byte)number).byteValue());
        }
        if (number instanceof Short) {
            return new NBTTagShort(((Short)number).shortValue());
        }
        if (number instanceof Integer) {
            return new NBTTagInt(((Integer)number).intValue());
        }
        if (number instanceof Long) {
            return new NBTTagLong(((Long)number).longValue());
        }
        if (number instanceof Float) {
            return new NBTTagFloat(((Float)number).floatValue());
        }
        if (number instanceof Double) {
            return new NBTTagDouble(((Double)number).doubleValue());
        }
        return null;
    }

    public NBTTagString convertToNBT(String string) {
        return new NBTTagString(string);
    }

    @Override
    public String getMCId(org.bukkit.inventory.ItemStack itemStack) {
        ItemStack nmsItem = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)itemStack);
        MinecraftKey mcKey = (MinecraftKey)Item.REGISTRY.b((Object)nmsItem.getItem());
        return mcKey.toString();
    }

    @Override
    public org.bukkit.inventory.ItemStack getItemFromMcId(String mcId) {
        MinecraftKey mcKey = new MinecraftKey(mcId);
        Item nmsItem = (Item)Item.REGISTRY.get((Object)mcKey);
        return CraftItemStack.asNewCraftStack((Item)nmsItem);
    }

    @Override
    public boolean getNoClip(Entity entity) {
        net.minecraft.server.v1_11_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.noclip;
    }

    @Override
    public void setNoClip(Entity entity, boolean noclip) {
        net.minecraft.server.v1_11_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.noclip = noclip;
    }

    @Override
    public boolean getFireProof(Entity entity) {
        net.minecraft.server.v1_11_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.isFireProof();
    }

    @Override
    public void setFireProof(Entity entity, boolean fireProof) {
        net.minecraft.server.v1_11_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        ReflectionUtils.setField("fireProof", nmsEntity.getClass(), nmsEntity, (Object)fireProof);
    }

    @Override
    public Location getLastLocation(Entity entity) {
        net.minecraft.server.v1_11_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        CraftWorld world = nmsEntity.world.getWorld();
        Location lastEntLoc = new Location((World)world, nmsEntity.M, nmsEntity.N, nmsEntity.O);
        return lastEntLoc;
    }

    @Override
    public float getEntityStepLength(Entity entity) {
        net.minecraft.server.v1_11_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.P;
    }

    @Override
    public void setEntityStepLength(Entity entity, float length) {
        net.minecraft.server.v1_11_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.P = length;
    }

    @Override
    public boolean getElytraGlideState(Entity entity) {
        EntityLiving nmsEntity = ((CraftLivingEntity)entity).getHandle();
        return nmsEntity.getFlag(7);
    }

    @Override
    public void setElytraGlideState(Entity entity, boolean glide) {
        EntityLiving nmsEntity = ((CraftLivingEntity)entity).getHandle();
        nmsEntity.setFlag(7, glide);
    }

    @Override
    public boolean getNoGravity(Entity entity) {
        net.minecraft.server.v1_11_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.isNoGravity();
    }

    @Override
    public void setNoGravity(Entity entity, boolean noGravity) {
        net.minecraft.server.v1_11_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.setNoGravity(noGravity);
    }
}

