/*
 * Decompiled with CFR 0.152.
 */
package com.republicansensei.repuska.listeners;

import com.republicansensei.repuska.Repuska;
import com.republicansensei.repuska.gui.v2.SkriptGUIEvent;
import com.republicansensei.repuska.util.data.InventoryUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

public abstract class GUIListener {
    private Inventory gui;
    private boolean isStarted = false;
    private static HashMap<String, String> names = new HashMap();

    public GUIListener(Inventory gui) {
        this.gui = gui;
    }

    public abstract void onClick(InventoryClickEvent var1, int var2);

    public abstract void onClose(InventoryCloseEvent var1);

    public abstract void onDrag(InventoryDragEvent var1, int var2);

    public void onEvent(Event event) {
        block13: {
            block12: {
                Inventory click;
                if (!(event instanceof InventoryClickEvent) || ((InventoryClickEvent)event).isCancelled()) break block12;
                InventoryClickEvent e = (InventoryClickEvent)event;
                names.put(e.getWhoClicked().getName(), e.getView().getTitle());
                if (!this.isAllowedType(e.getClick()) || (click = InventoryUtils.getClickedInventory(e)) == null) break block13;
                Inventory op = InventoryUtils.getOpositiveInventory(e.getView(), click);
                if (op == null || !click.equals(this.gui) && !op.equals(this.gui)) {
                    return;
                }
                int slot = e.getSlot();
                switch (e.getAction()) {
                    case MOVE_TO_OTHER_INVENTORY: {
                        if (!this.gui.equals(op)) break;
                        click = op;
                        slot = InventoryUtils.getSlotTo(op, e.getCurrentItem());
                        break;
                    }
                    case COLLECT_TO_CURSOR: {
                        click = this.gui;
                        slot = InventoryUtils.getSlotTo(click, e.getCursor());
                        break;
                    }
                    case HOTBAR_MOVE_AND_READD: 
                    case HOTBAR_SWAP: {
                        if (!this.gui.getType().equals((Object)InventoryType.PLAYER)) break;
                        slot = e.getHotbarButton();
                        click = this.gui;
                        break;
                    }
                }
                if (!click.equals(this.gui)) break block13;
                this.onClick(e, slot);
                break block13;
            }
            if (event instanceof InventoryCloseEvent) {
                InventoryCloseEvent e = (InventoryCloseEvent)event;
                if (e.getInventory().equals(this.gui)) {
                    if (e.getViewers().size() == 1) {
                        Bukkit.getScheduler().runTask((Plugin)Repuska.getInstance(), this::stop);
                    }
                    this.onClose(e);
                }
            } else if (event instanceof InventoryDragEvent && ((InventoryDragEvent)event).getInventory().equals(this.gui)) {
                Iterator iterator = ((InventoryDragEvent)event).getRawSlots().iterator();
                while (iterator.hasNext()) {
                    int slot = (Integer)iterator.next();
                    if (slot >= ((InventoryDragEvent)event).getInventory().getSize()) continue;
                    slot = ((InventoryDragEvent)event).getView().convertSlot(slot);
                    this.onDrag((InventoryDragEvent)event, slot);
                    if (((InventoryDragEvent)event).isCancelled()) break;
                }
            }
        }
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void stop() {
        if (this.isStarted() && this.gui.getViewers().size() == 0) {
            SkriptGUIEvent.getInstance().unregister(this);
            this.isStarted = false;
        }
    }

    public void start() {
        if (!this.isStarted()) {
            this.isStarted = true;
            SkriptGUIEvent.getInstance().register(this);
        }
    }

    public void setInventory(Inventory inv) {
        this.gui = inv;
    }

    public static Set<String> getEntities() {
        return names.keySet();
    }

    public static String getName(String name) {
        return names.get(name);
    }

    private boolean isAllowedType(ClickType ct) {
        if (ct != null) {
            switch (ct) {
                case WINDOW_BORDER_LEFT: 
                case WINDOW_BORDER_RIGHT: 
                case CREATIVE: 
                case UNKNOWN: {
                    return false;
                }
            }
        }
        return true;
    }

    public void finalize() {
        this.gui.clear();
    }
}

