/*
 * Decompiled with CFR 0.152.
 */
package com.republicansensei.repuska.fawe;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.boydti.fawe.FaweAPI;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Countable;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockState;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="All blocks")
@Description(value={"Get all blocks types in a cuboidregion."})
@Since(value="2.0")
public class ExprCuboidRegionBlocks
extends SimpleExpression<ItemType> {
    private Expression<CuboidRegion> cuboid;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.cuboid = expressions[0];
        return true;
    }

    protected ItemType[] get(Event e) {
        CuboidRegion cuboid = (CuboidRegion)this.cuboid.getSingle(e);
        if (cuboid == null) {
            return null;
        }
        EditSession session = FaweAPI.getEditSessionBuilder((World)FaweAPI.getWorld((String)Bukkit.getServer().getWorld(cuboid.getWorld().getName()).getName())).autoQueue(Boolean.valueOf(true)).build();
        List blocks = session.getBlockDistributionWithData((Region)cuboid);
        ArrayList<ItemType> materials = new ArrayList<ItemType>();
        if (blocks == null) {
            return null;
        }
        for (Countable block : blocks) {
            materials.add(new ItemType(new ItemStack(Material.valueOf((String)((BlockState)block.getID()).getBlockType().getName().replace(" ", "_").toUpperCase()))));
        }
        return materials.toArray(new ItemType[0]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    public String toString(Event e, boolean debug) {
        return "blocks in " + this.cuboid.toString(e, debug);
    }
}

