/*
 * Decompiled with CFR 0.152.
 */
package com.republicansensei.repuska.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.republicansensei.repuska.Repuska;
import com.republicansensei.repuska.api.PropertyFrom;
import com.republicansensei.repuska.api.PropertyTo;
import com.republicansensei.repuska.api.UsePropertyPatterns;
import com.republicansensei.repuska.listeners.GUIListener;
import com.republicansensei.repuska.util.data.Collect;
import com.republicansensei.repuska.util.nbt.Version12Utils;
import com.republicansensei.repuska.util.nbt.Version13Utils;
import com.republicansensei.repuska.util.nbt.Version14Utils;
import com.republicansensei.repuska.util.nbt.Version15Utils;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

@UsePropertyPatterns
@PropertyFrom(value="inventory")
@PropertyTo(value="inventory name")
public class ExprInventoryName
extends SimplePropertyExpression<Inventory, String> {
    Event event;

    protected String getPropertyName() {
        return "inventory name";
    }

    public String convert(Inventory inventory) {
        if (Repuska.getServerVersion() >= 14) {
            InventoryHolder holder = inventory.getHolder();
            if (holder == null) {
                for (HumanEntity entity : inventory.getViewers()) {
                    for (String name : GUIListener.getEntities()) {
                        if (!entity.getName().equals(name)) continue;
                        return GUIListener.getName(name);
                    }
                }
            }
            if (Repuska.getServerVersion() == 15) {
                return Version15Utils.getInventoryName(holder);
            }
            return Version14Utils.getInventoryName(holder);
        }
        if (Repuska.getServerVersion() == 13) {
            return Version13Utils.getInventoryName(inventory);
        }
        return Version12Utils.getInventoryName(inventory);
    }

    protected String[] get(Event e, Inventory[] source) {
        this.event = e;
        return (String[])super.get((Object[])source, (Converter)this);
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode == Changer.ChangeMode.SET ? Collect.asArray(String.class) : null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        String s = delta[0] == null ? "" : (String)delta[0];
        Inventory i = (Inventory)this.getExpr().getSingle(e);
        if (i.getType() != InventoryType.CHEST) {
            return;
        }
        Inventory copy = Bukkit.createInventory((InventoryHolder)i.getHolder(), (int)i.getSize(), (String)s);
        for (HumanEntity h : new ArrayList(i.getViewers())) {
            h.openInventory(copy);
        }
        copy.setContents(i.getContents());
    }
}

