/*
 * Decompiled with CFR 0.152.
 */
package com.republicansensei.repuska.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.republicansensei.repuska.Repuska;
import com.republicansensei.repuska.util.data.SchemFacingDirection;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.world.World;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import org.bukkit.Location;
import org.bukkit.event.Event;

public class EffPasteSchematic
extends Effect {
    private Expression<?> name;
    private Expression<?> loc;
    private Expression<?> exair;
    private Expression<Number> angle;
    private int mark = 0;

    public boolean init(Expression<?>[] expression, int i, Kleenean kleenean, SkriptParser.ParseResult Result) {
        this.name = expression[0];
        this.loc = expression[1];
        this.exair = expression[2];
        this.angle = expression[3];
        this.mark = Result.mark;
        return true;
    }

    public String toString(Event e, boolean debug) {
        return "Paste schematic \"" + this.name + "\" at " + this.loc;
    }

    protected void execute(Event event) {
        String name = (String)this.name.getSingle(event);
        Location loc = (Location)this.loc.getSingle(event);
        Boolean exair = false;
        exair = this.exair != null ? (Boolean)this.exair.getSingle(event) : Boolean.valueOf(false);
        try {
            switch (((Number)this.angle.getSingle(event)).intValue()) {
                case 0: 
                case 360: {
                    EffPasteSchematic.paste(name, loc, exair, SchemFacingDirection.NORTH);
                    break;
                }
                case 90: {
                    EffPasteSchematic.paste(name, loc, exair, SchemFacingDirection.EAST);
                    break;
                }
                case 180: {
                    EffPasteSchematic.paste(name, loc, exair, SchemFacingDirection.SOUTH);
                    break;
                }
                case 270: {
                    EffPasteSchematic.paste(name, loc, exair, SchemFacingDirection.WEST);
                    break;
                }
                default: {
                    EffPasteSchematic.paste(name, loc, exair, SchemFacingDirection.INVALID);
                    break;
                }
            }
        }
        catch (Exception e) {
            try {
                EffPasteSchematic.paste(name, loc, exair, SchemFacingDirection.NORTH);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private static boolean paste(String f, Location loc, Boolean exair, SchemFacingDirection facing) throws Exception {
        block21: {
            File file = f.startsWith("/") ? new File((String.valueOf(f) + ".schematic").replaceAll("/", Matcher.quoteReplacement(File.separator))) : new File(("plugins/WorldEdit/schematics/" + (f.contains(".") ? f : String.valueOf(f) + ".schematic")).replaceAll("/", Matcher.quoteReplacement(File.separator)));
            BlockVector3 v = BlockVector3.at((int)loc.getBlockX(), (int)loc.getBlockY(), (int)loc.getBlockZ());
            if (!file.exists() && file.isDirectory()) {
                return false;
            }
            Clipboard clipboard = null;
            ClipboardFormat format = ClipboardFormats.findByFile((File)file);
            try {
                Throwable throwable = null;
                Object var9_11 = null;
                try (ClipboardReader reader = format.getReader((InputStream)new FileInputStream(file));){
                    clipboard = reader.read();
                    reader.close();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try (EditSession editSession = null;){
                try {
                    editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession((World)new BukkitWorld(loc.getWorld()), 800000);
                    if (facing == null) break block21;
                    if (SchemFacingDirection.getDegree(facing) != -1) {
                        ClipboardHolder holder = new ClipboardHolder(clipboard);
                        AffineTransform transform = new AffineTransform();
                        transform = transform.rotateY((double)(-(SchemFacingDirection.getDegree(facing) != null ? SchemFacingDirection.getDegree(facing) : 0)));
                        holder.setTransform(holder.getTransform().combine((Transform)transform));
                        Operation operation = holder.createPaste((Extent)editSession).to(v).ignoreAirBlocks(exair.booleanValue()).build();
                        Operations.complete((Operation)operation);
                        break block21;
                    }
                    Repuska.warning("Invalid rotation angle for schematic: \"" + f + "\"");
                    Repuska.warning("Valid angles are: 0, 90, 180, 270, 360");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (editSession != null) {
                        editSession.close();
                    }
                }
            }
        }
        return true;
    }
}

