/*
 * Decompiled with CFR 0.152.
 */
package com.republicansensei.repuska.mysql;

import com.republicansensei.repuska.Repuska;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.bukkit.ChatColor;
import org.bukkit.event.Listener;

public class MySQLManager
implements Listener {
    private static Connection con;

    public static Connection getConnection() {
        return con;
    }

    public static void setConnection(String host, String user, String password, String database) {
        try {
            con = Repuska.mysqlData.getBoolean("MySQLSetup.SQLite") ? DriverManager.getConnection(String.valueOf(Repuska.mysqlData.getString("ClassPath", "jdbc:mysql://")) + host + ":" + Repuska.mysqlData.getInt("MySQLSetup.Port", 3306) + "/" + database + "?allowMultiQueries=" + Repuska.mysqlData.getBoolean("allowMultiQueries", true)) : DriverManager.getConnection(String.valueOf(Repuska.mysqlData.getString("ClassPath", "jdbc:mysql://")) + host + ":" + Repuska.mysqlData.getInt("MySQLSetup.Port", 3306) + "/" + database + "?allowMultiQueries=" + Repuska.mysqlData.getBoolean("allowMultiQueries", true), user, password);
            Repuska.log("MySQL connected! Host: " + host + " Port: " + Repuska.mysqlData.getInt("MySQLSetup.Port", 3306) + " User: " + user + " Password: " + password.replaceAll("", "*") + " user: " + user);
        }
        catch (SQLException e) {
            Repuska.log("MySQL connect error: " + e.getMessage());
            Repuska.log("Host: " + host + " Port: " + Repuska.mysqlData.getInt("MySQLSetup.Port", 3306) + " User: " + user + " Password: " + password + " user: " + user);
        }
    }

    public static void connect() {
        String host = Repuska.mysqlData.getString("MySQLSetup.Host", "");
        String user = Repuska.mysqlData.getString("MySQLSetup.Username", "");
        String password = Repuska.mysqlData.getString("MySQLSetup.Password", "");
        String database = Repuska.mysqlData.getString("MySQLSetup.Database", "");
        if (host.equalsIgnoreCase("")) {
            Repuska.log("MySQL error: Host is blank");
        } else if (user.equalsIgnoreCase("")) {
            Repuska.log("MySQL error: Username is blank");
        } else if (password.equalsIgnoreCase("")) {
            Repuska.log("MySQL error: Password is blank");
        } else if (database.equalsIgnoreCase("")) {
            Repuska.log("MySQL error: Database is blank");
        } else if (MySQLManager.getConnection() == null) {
            MySQLManager.setConnection(host, user, password, database);
        }
    }

    public static void disconnect() {
        try {
            if (MySQLManager.getConnection() != null) {
                con.close();
                Repuska.log("MySQL disconnected.");
            }
        }
        catch (SQLException e) {
            Repuska.log("MySQL disconnect error: " + e.getMessage());
        }
    }

    public static void update(String command) {
        if (command == null) {
            return;
        }
        MySQLManager.connect();
        try {
            Statement st = MySQLManager.getConnection().createStatement();
            st.executeUpdate(command);
            st.close();
        }
        catch (SQLException e) {
            Repuska.log(ChatColor.RED + "MySQL Update:");
            Repuska.log(ChatColor.RED + "Command: " + command);
            Repuska.log(ChatColor.RED + "Error: " + e.getMessage());
        }
    }

    public static ResultSet query(String command) {
        if (command == null) {
            return null;
        }
        MySQLManager.connect();
        ResultSet rs = null;
        try {
            Statement st = MySQLManager.getConnection().createStatement();
            rs = st.executeQuery(command);
        }
        catch (SQLException e) {
            Repuska.log(ChatColor.RED + "MySQL Query:");
            Repuska.log(ChatColor.RED + "Command: " + command);
            Repuska.log(ChatColor.RED + "Error: " + e.getMessage());
        }
        return rs;
    }
}

