/*
 * Decompiled with CFR 0.152.
 */
package com.republicansensei.repuska.holograms;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.handler.PickupHandler;
import com.gmail.filoghost.holographicdisplays.api.handler.TouchHandler;
import com.gmail.filoghost.holographicdisplays.api.line.ItemLine;
import com.gmail.filoghost.holographicdisplays.api.line.TextLine;
import com.republicansensei.repuska.holograms.HoloManager;
import com.republicansensei.repuska.holograms.HoloPickupEvent;
import com.republicansensei.repuska.holograms.HoloTouchEvent;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class EffEditHoloObjectLine
extends Effect {
    private Expression<String> text;
    private Expression<String> id;
    private Expression<Boolean> interactive;
    private Expression<Number> lineNumber;

    public boolean init(Expression<?>[] exp, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.id = exp[0];
        this.lineNumber = exp[1];
        this.text = exp[2];
        this.interactive = exp[3];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return null;
    }

    protected void execute(final Event evt) {
        if (HoloManager.getFromHoloMap(((String)this.id.getSingle(evt)).replace("\"", "")) != null) {
            Hologram hologram = HoloManager.getFromHoloMap(((String)this.id.getSingle(evt)).replace("\"", ""));
            if (((Number)this.lineNumber.getSingle(evt)).intValue() <= 0) {
                Skript.error((String)"Please use a line number greater than 0");
                return;
            }
            final int finalLineNumber = ((Number)this.lineNumber.getSingle(evt)).intValue() - 1;
            boolean check = false;
            if (this.interactive != null && this.interactive.getSingle(evt) != null) {
                check = (Boolean)this.interactive.getSingle(evt);
            }
            hologram.getLine(finalLineNumber).removeLine();
            String line = ((String)this.text.getSingle(evt)).replace("\"", "").replace(";", "");
            if (line.startsWith("ItemStack:")) {
                line = line.substring(line.indexOf(":") + 1);
                int meta = 0;
                if (line.contains(":")) {
                    try {
                        meta = Integer.parseInt(line.substring(line.indexOf(":") + 1));
                    }
                    catch (NumberFormatException exception) {
                        Skript.error((String)"Meta data could not be parsed correctly!");
                        return;
                    }
                    line = line.substring(0, line.indexOf(":"));
                }
                ItemStack stack = new ItemStack(Material.AIR, 1);
                try {
                    Material mat = Material.valueOf((String)line.toUpperCase().replace(" ", "_"));
                    stack = new ItemStack(mat, 1);
                    if (meta != 0) {
                        stack = new ItemStack(mat, 1, (short)((byte)meta));
                    }
                }
                catch (IllegalArgumentException exception) {
                    Skript.error((String)"A item under that name does not exsist!");
                    return;
                }
                ItemLine itemline = hologram.insertItemLine(finalLineNumber, stack);
                if (check) {
                    itemline.setTouchHandler(new TouchHandler(){

                        public void onTouch(Player player) {
                            HoloTouchEvent event = new HoloTouchEvent(player, ((String)EffEditHoloObjectLine.this.id.getSingle(evt)).replace("\"", ""), finalLineNumber);
                            Bukkit.getPluginManager().callEvent((Event)event);
                        }
                    });
                    itemline.setPickupHandler(new PickupHandler(){

                        public void onPickup(Player player) {
                            HoloPickupEvent event = new HoloPickupEvent(player, ((String)EffEditHoloObjectLine.this.id.getSingle(evt)).replace("\"", ""), finalLineNumber);
                            Bukkit.getPluginManager().callEvent((Event)event);
                        }
                    });
                }
            } else {
                TextLine textline = hologram.insertTextLine(finalLineNumber, line);
                if (check) {
                    textline.setTouchHandler(new TouchHandler(){

                        public void onTouch(Player player) {
                            HoloTouchEvent event = new HoloTouchEvent(player, ((String)EffEditHoloObjectLine.this.id.getSingle(evt)).replace("\"", ""), finalLineNumber);
                            Bukkit.getPluginManager().callEvent((Event)event);
                        }
                    });
                }
            }
            HoloManager.editHoloMap(((String)this.id.getSingle(evt)).replace("\"", ""), hologram);
        } else {
            Skript.error((String)"That hologram does not exist!");
        }
    }
}

