/*
 * Decompiled with CFR 0.152.
 */
package com.republicansensei.repuska;

import java.io.IOException;
import java.net.URL;
import java.util.Scanner;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class AdvancedLicense {
    private String licenseKey;
    private Plugin plugin;
    private String validationServer;
    private LogType logType = LogType.NORMAL;
    private String securityKey = "YecoF0I6M05thxLeokoHuW8iUhTdIUInjkfF";
    private boolean debug = false;

    public AdvancedLicense(String licenseKey, String validationServer, Plugin plugin) {
        this.licenseKey = licenseKey;
        this.plugin = plugin;
        this.validationServer = validationServer;
    }

    public AdvancedLicense setSecurityKey(String securityKey) {
        this.securityKey = securityKey;
        return this;
    }

    public AdvancedLicense setConsoleLog(LogType logType) {
        this.logType = logType;
        return this;
    }

    public AdvancedLicense debug() {
        this.debug = true;
        return this;
    }

    public boolean register() {
        this.log(0, "---------- REPUSKA ----------");
        this.log(0, "Confirming data...");
        ValidationType vt = this.isValid();
        if (vt == ValidationType.VALID) {
            this.log(1, "License valid, thank you! (Don't share your license to anyone, it's bannable!)");
            this.log(0, "---------- REPUSKA ----------");
            return true;
        }
        this.log(1, "A problem happened. Please contact 'RepublicanSensei' on SpigotMC with your BUYER account! (" + vt.toString() + ")");
        this.log(0, "---------- REPUSKA ----------");
        Bukkit.getScheduler().cancelTasks(this.plugin);
        Bukkit.getPluginManager().disablePlugin(this.plugin);
        return false;
    }

    public boolean isValidSimple() {
        return this.isValid() == ValidationType.VALID;
    }

    public ValidationType isValid() {
        String rand = this.toBinary(UUID.randomUUID().toString());
        String sKey = this.toBinary(this.securityKey);
        String key = this.toBinary(this.licenseKey);
        try {
            Scanner s;
            URL url = new URL(String.valueOf(this.validationServer) + "?v1=" + AdvancedLicense.xor(rand, sKey) + "&v2=" + AdvancedLicense.xor(rand, key) + "&pl=" + this.plugin.getName());
            if (this.debug) {
                System.out.println("RequestURL -> " + url.toString());
            }
            if ((s = new Scanner(url.openStream())).hasNext()) {
                String response = s.next();
                s.close();
                try {
                    return ValidationType.valueOf(response);
                }
                catch (IllegalArgumentException exc) {
                    String respRand = AdvancedLicense.xor(AdvancedLicense.xor(response, key), sKey);
                    if (rand.substring(0, respRand.length()).equals(respRand)) {
                        return ValidationType.VALID;
                    }
                    return ValidationType.WRONG_RESPONSE;
                }
            }
            s.close();
            return ValidationType.PAGE_ERROR;
        }
        catch (IOException exc) {
            if (this.debug) {
                exc.printStackTrace();
            }
            return ValidationType.URL_ERROR;
        }
    }

    private static String xor(String s1, String s2) {
        String s0 = "";
        int i = 0;
        while (i < (s1.length() < s2.length() ? s1.length() : s2.length())) {
            s0 = String.valueOf(s0) + (Byte.valueOf("" + s1.charAt(i)) ^ Byte.valueOf("" + s2.charAt(i)));
            ++i;
        }
        return s0;
    }

    private String toBinary(String s) {
        byte[] bytes = s.getBytes();
        StringBuilder binary = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            int b;
            int val = b = byArray[n2];
            int i = 0;
            while (i < 8) {
                binary.append((val & 0x80) == 0 ? 0 : 1);
                val <<= 1;
                ++i;
            }
            ++n2;
        }
        return binary.toString();
    }

    private void log(int type, String message) {
        if (this.logType == LogType.NONE || this.logType == LogType.LOW && type == 0) {
            return;
        }
        System.out.println(message);
    }

    public static enum LogType {
        NORMAL,
        LOW,
        NONE;

    }

    public static enum ValidationType {
        WRONG_RESPONSE,
        PAGE_ERROR,
        URL_ERROR,
        KEY_OUTDATED,
        KEY_NOT_FOUND,
        NOT_VALID_IP,
        INVALID_PLUGIN,
        VALID;

    }
}

