/*
 * Decompiled with CFR 0.152.
 */
package com.republicansensei.repuska.worldreset;

import com.google.common.io.Files;
import com.onarandombox.MultiverseCore.MultiverseCore;
import com.republicansensei.repuska.Repuska;
import java.io.File;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WorldReset {
    private static Boolean useMultiverse = true;

    public static void kickPlayers(World world) {
        if (Bukkit.getOnlinePlayers() != null) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!p.getWorld().getName().equals(world.getName())) continue;
                p.saveData();
                Location spawn = ((World)Bukkit.getServer().getWorlds().get(0)).getSpawnLocation();
                p.teleport(spawn);
            }
        }
    }

    public static void kickPlayers(String worldName) {
        WorldReset.kickPlayers(Bukkit.getWorld((String)worldName));
    }

    public static void deleteWorldSave(String worldName) {
        File worldFolder = new File("plugins/Repuska/worldsaves/" + worldName);
        if (worldFolder.exists()) {
            WorldReset.deleteFolder(worldFolder);
        }
    }

    public static void saveWorld(World world) {
        if (world != null) {
            world.save();
            File worldFolder = new File("plugins/Repuska/worldsaves/" + world.getName());
            File srcWorldFolder = new File(world.getName());
            if (worldFolder.exists()) {
                WorldReset.deleteFolder(worldFolder);
            }
            WorldReset.copyWorldFolder(srcWorldFolder, worldFolder);
            YamlConfiguration settings = YamlConfiguration.loadConfiguration((File)new File(worldFolder, "WorldSettings.yml"));
            settings.set("World.Seed", (Object)world.getSeed());
            settings.set("World.Environment", (Object)world.getEnvironment().toString());
            settings.set("World.Structures", (Object)world.canGenerateStructures());
            settings.set("World.Generator", (Object)WorldReset.getChunkGeneratorAsName(world));
            settings.set("World.Type", (Object)world.getWorldType().toString());
            try {
                settings.save(new File(worldFolder, "WorldSettings.yml"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveWorld(String worldName) {
        WorldReset.saveWorld(Bukkit.getWorld((String)worldName));
    }

    public static void resetWorld(String worldName) {
        WorldReset.resetWorld(Bukkit.getWorld((String)worldName));
    }

    public static void resetWorld(final World world) {
        final File srcWorldFolder = new File("plugins/Repuska/worldsaves/" + world.getName());
        final File worldFolder = new File(world.getName());
        if (srcWorldFolder.exists() && worldFolder.exists()) {
            if (world.getName().equals(((World)Bukkit.getServer().getWorlds().get(0)).getName())) {
                System.out.println("[Repuska] This world can't be saved, because it's the main world.");
            } else {
                WorldReset.kickPlayers(world);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Repuska.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        String worldName = world.getName();
                        Boolean saveSett = false;
                        Long seed = null;
                        World.Environment environment = null;
                        Boolean structures = null;
                        String generator = null;
                        WorldType worldType = null;
                        File settingsFile = new File(srcWorldFolder, "WorldSettings.yml");
                        YamlConfiguration settings = YamlConfiguration.loadConfiguration((File)settingsFile);
                        if (settingsFile.exists() && settings.get("World.Seed") != null) {
                            seed = settings.getLong("World.Seed");
                            environment = World.Environment.valueOf((String)settings.getString("World.Environment"));
                            structures = settings.getBoolean("World.Structures");
                            generator = settings.getString("World.Generator");
                            worldType = WorldType.valueOf((String)settings.getString("World.Type"));
                        } else {
                            seed = world.getSeed();
                            environment = world.getEnvironment();
                            structures = world.canGenerateStructures();
                            generator = WorldReset.getChunkGeneratorAsName(world);
                            worldType = world.getWorldType();
                            settings.set("World.Seed", (Object)world.getSeed());
                            settings.set("World.Environment", (Object)world.getEnvironment().toString());
                            settings.set("World.Structures", (Object)world.canGenerateStructures());
                            settings.set("World.Generator", (Object)WorldReset.getChunkGeneratorAsName(world));
                            settings.set("World.Type", (Object)world.getWorldType().toString());
                            saveSett = true;
                        }
                        Bukkit.getServer().unloadWorld(world, true);
                        WorldCreator w = new WorldCreator(world.getName());
                        WorldReset.deleteFolder(worldFolder);
                        WorldReset.copyWorldFolder(srcWorldFolder, worldFolder);
                        if (saveSett.booleanValue()) {
                            try {
                                settings.save(settingsFile);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        w.seed(seed.longValue());
                        w.environment(environment);
                        w.generateStructures(structures.booleanValue());
                        w.generator(generator);
                        w.type(worldType);
                        if (useMultiverse.booleanValue()) {
                            try {
                                MultiverseCore core = (MultiverseCore)Bukkit.getPluginManager().getPlugin("Multiverse-Core");
                                System.out.println(core);
                                System.out.println(core.getMVWorldManager());
                                System.out.println(core.getMVWorldManager().getMVWorlds());
                                System.out.println(core.getMVWorldManager().getTheWorldPurger());
                                System.out.println(core.getMVWorldManager().addWorld(worldName, environment, seed.toString(), worldType, structures, generator));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            Bukkit.getServer().createWorld(w);
                        }
                    }
                }, 20L);
            }
        }
    }

    private static void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    WorldReset.deleteFolder(file);
                } else {
                    file.delete();
                }
                ++n2;
            }
        }
        folder.delete();
    }

    private static String getChunkGeneratorAsName(World world) {
        Plugin[] pluginArray = Bukkit.getPluginManager().getPlugins();
        int n = pluginArray.length;
        int n2 = 0;
        while (n2 < n) {
            Plugin plugin = pluginArray[n2];
            WorldCreator wc = new WorldCreator("ThisMapWillNeverBeCreated");
            if (!plugin.getName().equalsIgnoreCase("MultiWorld")) {
                wc.generator(plugin.getName());
                if (wc.generator() != null && world.getGenerator() != null && wc.generator().getClass().getName() != null && wc.generator().getClass().getName().equals(world.getGenerator().getClass().getName())) {
                    return plugin.getName();
                }
            }
            ++n2;
        }
        return null;
    }

    private static void copyWorldFolder(File from, File to) {
        try {
            ArrayList<String> ignore = new ArrayList<String>();
            ignore.add("session.lock");
            ignore.add("WorldSettings.yml");
            if (!ignore.contains(from.getName())) {
                if (from.isDirectory()) {
                    String[] files;
                    if (!to.exists()) {
                        to.mkdirs();
                    }
                    String[] stringArray = files = from.list();
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String file = stringArray[n2];
                        File srcFile = new File(from, file);
                        File destFile = new File(to, file);
                        WorldReset.copyWorldFolder(srcFile, destFile);
                        ++n2;
                    }
                } else {
                    Files.copy((File)from, (File)to);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

