/*
 * Decompiled with CFR 0.152.
 */
package com.republicansensei.repuska.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.republicansensei.repuska.api.PropertyFrom;
import com.republicansensei.repuska.api.PropertyTo;
import com.republicansensei.repuska.api.UsePropertyPatterns;
import com.republicansensei.repuska.util.data.Collect;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

@UsePropertyPatterns
@PropertyFrom(value="inventory")
@PropertyTo(value="inventory name")
public class ExprInventoryName
extends SimplePropertyExpression<Inventory, String> {
    protected String getPropertyName() {
        return "inventory name";
    }

    public String convert(Inventory inventory) {
        return inventory.getName();
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode == Changer.ChangeMode.SET ? Collect.asArray(String.class) : null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        String s = delta[0] == null ? "" : (String)delta[0];
        Inventory i = (Inventory)this.getExpr().getSingle(e);
        if (i.getType() != InventoryType.CHEST) {
            return;
        }
        Inventory copy = Bukkit.createInventory((InventoryHolder)i.getHolder(), (int)i.getSize(), (String)s);
        for (HumanEntity h : new ArrayList(i.getViewers())) {
            h.openInventory(copy);
        }
        copy.setContents(i.getContents());
    }
}

