/*
 * Decompiled with CFR 0.152.
 */
package com.republicansensei.repuska;

import ch.njol.skript.Skript;
import com.republicansensei.repuska.Metrics;
import com.republicansensei.repuska.Updater;
import com.republicansensei.repuska.collections.obfuscator.ObfuscatorElements;
import com.republicansensei.repuska.gui.GUIManager;
import com.republicansensei.repuska.register.Conditions;
import com.republicansensei.repuska.register.Effects;
import com.republicansensei.repuska.register.Events;
import com.republicansensei.repuska.register.Expressions;
import com.republicansensei.repuska.register.Other;
import com.republicansensei.repuska.register.SkQuery;
import com.republicansensei.repuska.register.Types;
import java.io.File;
import java.nio.file.Paths;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public class Repuska
extends JavaPlugin
implements Listener {
    public static Repuska instance;
    private static Repuska repuska;
    public static String version;
    private static GUIManager gui;
    private static boolean enable;
    private static boolean skript;
    public static FileConfiguration mysqlData;

    public static Repuska getPluginInstance() {
        return (Repuska)Repuska.getPlugin(Repuska.class);
    }

    public void onEnable() {
        repuska = this;
        PluginDescriptionFile pdf = this.getDescription();
        version = pdf.getVersion();
        Repuska.log("~ Created by RepublicanSensei, Tuke_Nuke and LimeGlass ~");
        Repuska.log("~ Version: " + version + " ~");
        if (this.cannot()) {
            return;
        }
        Skript.registerAddon((JavaPlugin)this);
        Other.metrics(new Metrics(this));
        Conditions.register();
        Effects.register();
        Events.register();
        Expressions.register();
        Types.register();
        ObfuscatorElements.register();
        SkQuery.enableSnooper();
        Updater spu = new Updater(this, "http://republicansensei.com/updater.html");
        spu.enableOut();
        if (spu.needsUpdate()) {
            spu.update();
        }
    }

    private boolean cannot() {
        Plugin[] pluginArray = Bukkit.getPluginManager().getPlugins();
        int n = pluginArray.length;
        int n2 = 0;
        while (n2 < n) {
            Plugin plugin = pluginArray[n2];
            if (plugin.getName().equalsIgnoreCase("skript")) {
                Repuska.log("Skript hooked!");
                skript = true;
            }
            ++n2;
        }
        if (!skript) {
            Repuska.warning("Skript not found! Stopping registration ...");
            return true;
        }
        enable = true;
        return false;
    }

    public static Repuska getInstance() {
        return repuska;
    }

    public static String getVersion() {
        return version;
    }

    public static void log(String log) {
        Bukkit.getLogger().info("[Repuska] " + log);
    }

    public static void severe(String log) {
        Bukkit.getLogger().warning("[Repuska] " + log);
    }

    public static void warning(String log) {
        Bukkit.getLogger().severe("[Repuska][Error] #!#");
        Bukkit.getLogger().severe("[Repuska][Error] #!# ======={ Repuska Warning }=======");
        Bukkit.getLogger().severe("[Repuska][Error] #!# " + log);
        Bukkit.getLogger().severe("[Repuska][Error] #!#");
    }

    public static void error(String log) {
        Bukkit.getLogger().severe("[Repuska][Error] #!#");
        Bukkit.getLogger().severe("[Repuska][Error] #!# =!!!======{ Repuska Error }======!!!=");
        Bukkit.getLogger().severe("[Repuska][Error] #!# " + log);
        Bukkit.getLogger().severe("[Repuska][Error] #!#");
        Bukkit.getLogger().severe("[Repuska][Error] #!#");
    }

    public static GUIManager getGUIManager() {
        if (gui == null) {
            gui = new GUIManager(Repuska.getInstance());
        }
        return gui;
    }

    public static boolean enabled() {
        return enable;
    }

    public static String getDefaultPath(String pth) {
        String dp = Paths.get("", new String[0]).normalize().toAbsolutePath().toString();
        if (pth.contains(dp)) {
            return String.valueOf(pth) + File.separator;
        }
        return String.valueOf(dp) + File.separator + pth;
    }
}

