/*
 * Decompiled with CFR 0.152.
 */
package com.republicansensei.repuska.util.nbt;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;

public class ReflectionUtils {
    public static Class<?> getNMSClass(String classString) {
        String version = ReflectionUtils.getVersion();
        String name = "net.minecraft.server." + version + classString;
        Class<?> nmsClass = null;
        try {
            nmsClass = Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            Bukkit.getLogger().warning("Unable to get NMS class '" + name + "'! You are probably running an unsupported version!");
            return null;
        }
        return nmsClass;
    }

    public static Class<?> getOBCClass(String classString) {
        String version = String.valueOf(Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3]) + ".";
        String name = "org.bukkit.craftbukkit." + version + classString;
        Class<?> obcClass = null;
        try {
            obcClass = Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            Bukkit.getLogger().warning("Unable to get OBC class '" + name + "'! You are probably running an unsupported version!");
            return null;
        }
        return obcClass;
    }

    public static Object getField(String field, Class<?> clazz, Object object) {
        Field f = null;
        Object obj = null;
        try {
            f = clazz.getDeclaredField(field);
            f.setAccessible(true);
            obj = f.get(object);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            ex.printStackTrace();
        }
        return obj;
    }

    public static void setField(String field, Class<?> clazz, Object object, Object toSet) {
        Field f = null;
        try {
            f = clazz.getDeclaredField(field);
            f.setAccessible(true);
            f.set(object, toSet);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException ex) {
            ex.printStackTrace();
        }
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... params) {
        Constructor<?> constr = null;
        try {
            constr = clazz.getDeclaredConstructor(params);
            constr.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            ex.printStackTrace();
        }
        return constr;
    }

    public static <T> T newInstance(Class<T> clz) {
        try {
            Constructor<T> c = clz.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            return c.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... objects) {
        try {
            return constructor.newInstance(objects);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> boolean setField(Class<T> from, Object obj, String field, Object newValue) {
        try {
            Field f = from.getDeclaredField(field);
            f.setAccessible(true);
            f.set(obj, newValue);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static <T> T getField(Class<?> from, Object obj, String field) {
        try {
            Field f = from.getDeclaredField(field);
            f.setAccessible(true);
            return (T)f.get(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T invokeMethod(Class<?> clz, String method, Object instance, Object ... parameters) {
        try {
            Class[] parameterTypes = new Class[parameters.length];
            int x = 0;
            Object[] objectArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                parameterTypes[x++] = obj.getClass();
                ++n2;
            }
            Method m = clz.getDeclaredMethod(method, parameterTypes);
            m.setAccessible(true);
            return (T)m.invoke(instance, parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T invokeMethod(Method method, Object instance, Object ... parameters) {
        try {
            method.setAccessible(true);
            return (T)method.invoke(instance, parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getVersion() {
        return String.valueOf(Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3]) + ".";
    }
}

