/*
 * Decompiled with CFR 0.152.
 */
package com.republicansensei.repuska.json;

import ch.njol.skript.registrations.Classes;
import ch.njol.skript.variables.SerializedVariable;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.json.simple.JSONObject;

public class Serializers {
    private static Map<String, Serializer> serializers = new HashMap<String, Serializer>();

    public static <T> void register(Class<T> cls, Function<T, JSONObject> serializer, Function<JSONObject, T> deserializer) {
        serializers.put(cls.getName(), new Serializer(serializer, deserializer));
    }

    public static JSONObject serialize(Object o) {
        JSONObject obj;
        String cls = o.getClass().getName();
        if (serializers.containsKey(cls)) {
            obj = Serializers.serializers.get((Object)cls).serializer.apply(o);
            obj.put((Object)"__javaclass__", (Object)cls);
        } else {
            obj = new JSONObject();
            SerializedVariable.Value value = Classes.serialize((Object)o);
            if (value == null) {
                return null;
            }
            obj.put((Object)"__skriptclass__", (Object)value.type);
            obj.put((Object)"value", (Object)Base64.getEncoder().encodeToString(value.data));
        }
        return obj;
    }

    public static Object deserialize(JSONObject obj) {
        String cls = (String)obj.get((Object)"__javaclass__");
        if (cls != null && serializers.containsKey(cls)) {
            return Serializers.serializers.get((Object)cls).deserializer.apply(obj);
        }
        String type = (String)obj.get((Object)"__skriptclass__");
        String content = (String)obj.get((Object)"value");
        if (type == null || content == null) {
            return null;
        }
        return Classes.deserialize((String)type, (byte[])Base64.getDecoder().decode(content));
    }

    private static class Serializer {
        Function<Object, JSONObject> serializer;
        Function<JSONObject, Object> deserializer;

        Serializer(Function<Object, JSONObject> serializer, Function<JSONObject, Object> deserializer) {
            this.serializer = serializer;
            this.deserializer = deserializer;
        }
    }
}

