/*
 * Decompiled with CFR 0.152.
 */
package com.republicansensei.repuska.expressions.gui;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.util.Kleenean;
import com.republicansensei.repuska.util.data.EnumType;
import com.republicansensei.repuska.util.data.InventoryUtils;
import java.util.regex.MatchResult;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

public class ExprVirtualInv
extends SimpleExpression<Inventory> {
    private static Parser<InventoryType> parser = EnumType.getParser(InventoryType.class, null);
    private Expression<InventoryType> it;
    private Expression<Number> size;
    private Expression<String> name;

    public Class<? extends Inventory> getReturnType() {
        return Inventory.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] arg, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        if (arg3.regexes != null && arg3.regexes.size() > 0) {
            String stringType = ((MatchResult)arg3.regexes.get(0)).group(0);
            InventoryType type = (InventoryType)parser.parse(stringType, ParseContext.COMMAND);
            if (type != null) {
                this.it = new SimpleLiteral((Object)type, false);
            } else {
                Skript.error((String)("There is no inventory type called '" + stringType + "'. Check Repuska documentation to search about it."));
                return false;
            }
        }
        if (arg1 > 1) {
            this.name = arg[0];
            this.size = arg[1];
        } else {
            this.size = arg[0];
            this.name = arg[1];
        }
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return "virtual inventory";
    }

    @Nullable
    protected Inventory[] get(Event e) {
        InventoryType type;
        if (this.it != null && (type = (InventoryType)this.it.getSingle(e)) != null) {
            Integer size = this.size != null ? Integer.valueOf(((Number)this.size.getSingle(e)).intValue()) : null;
            String name = this.name != null ? (String)this.name.getSingle(e) : null;
            return new Inventory[]{InventoryUtils.newInventory(type, size, name)};
        }
        return null;
    }
}

