/*
 * Decompiled with CFR 0.152.
 */
package com.republicansensei.repuska.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import com.republicansensei.repuska.api.Patterns;
import com.republicansensei.repuska.util.data.Collect;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChatEvent;

@Patterns(value={"message format"})
public class ExprMessageFormat
extends SimpleExpression<String> {
    protected String[] get(Event event) {
        return Collect.asArray(((AsyncPlayerChatEvent)event).getFormat());
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(@Nullable Event event, boolean b) {
        return "chat message format";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        if (ScriptLoader.isCurrentEvent(PlayerChatEvent.class)) {
            Skript.error((String)"Message format can only be used inside a chat event", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        return true;
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        String format = delta[0] == null ? "" : (String)delta[0];
        ((AsyncPlayerChatEvent)e).setFormat(format);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return Collect.asArray(String.class);
        }
        return null;
    }
}

