/*
 * Decompiled with CFR 0.152.
 */
package com.republicansensei.repuska.effects.we.fawe;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.boydti.fawe.FaweAPI;
import com.republicansensei.repuska.Repuska;
import com.republicansensei.repuska.effects.we.fawe.PasteOptions;
import com.republicansensei.repuska.effects.we.fawe.Schematic;
import com.republicansensei.repuska.effects.we.fawe.SchematicLoader;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.world.World;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Paste schematic")
@Description(value={"Paste a schematic at a location with or without using air"})
@Examples(value={"paste skematic \"plugins/WorldEdit/skematic.schematic\" at player excluding air"})
@Since(value="1.0")
public class EffSchematicPaste
extends Effect {
    private Expression<?> schematic;
    private Expression<Location> location;
    private Expression<PasteOptions> options;
    private Expression<Number> angle;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.schematic = expressions[0];
        this.location = expressions[1];
        this.options = expressions[2];
        this.angle = expressions[3];
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(Event e) {
        Schematic schematic;
        PasteOptions[] pasteOptionsArray;
        Location location = (Location)this.location.getSingle(e);
        if (this.options != null) {
            pasteOptionsArray = (PasteOptions[])this.options.getArray(e);
        } else {
            PasteOptions[] pasteOptionsArray2 = new PasteOptions[1];
            pasteOptionsArray = pasteOptionsArray2;
            pasteOptionsArray2[0] = PasteOptions.DEFAULT;
        }
        PasteOptions[] options = pasteOptionsArray;
        Number angle = this.angle != null ? (Number)((Number)this.angle.getSingle(e)) : (Number)null;
        if (this.schematic == null) return;
        if (location == null) return;
        if (options == null) {
            return;
        }
        if (this.schematic.getSingle(e) instanceof String) {
            String file = (String)this.schematic.getSingle(e);
            if (SchematicLoader.getSchematics().containsKey(file)) {
                schematic = SchematicLoader.get(file);
            } else {
                if (!Paths.get(file, new String[0]).toFile().exists()) {
                    Skript.error((String)("Schematic " + file + " doesn't exist!"));
                    return;
                }
                schematic = new Schematic(new File(file));
            }
        } else {
            if (!(this.schematic.getSingle(e) instanceof Schematic)) return;
            schematic = (Schematic)this.schematic.getSingle(e);
        }
        HashSet<PasteOptions> optionsSet = new HashSet<PasteOptions>(Arrays.asList(options));
        BlockVector3 vector = BlockVector3.at((int)location.getBlockX(), (int)location.getBlockY(), (int)location.getBlockZ());
        Clipboard clipboard = null;
        ClipboardFormat format = ClipboardFormats.findByFile((File)schematic.getFile());
        try {
            Throwable throwable = null;
            Object var11_13 = null;
            try (ClipboardReader reader = format.getReader((InputStream)new FileInputStream(schematic.getFile()));){
                clipboard = reader.read();
                reader.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try (EditSession editSession = null;){
            try {
                editSession = FaweAPI.getEditSessionBuilder((World)FaweAPI.getWorld((String)location.getWorld().getName())).autoQueue(Boolean.valueOf(true)).build();
                if (angle == null) return;
                if (angle.intValue() != -1) {
                    ClipboardHolder holder = new ClipboardHolder(clipboard);
                    AffineTransform transform = new AffineTransform();
                    transform = transform.rotateY((double)(-(angle != null ? angle.intValue() : 0)));
                    holder.setTransform(holder.getTransform().combine((Transform)transform));
                    Operation operation = holder.createPaste((Extent)editSession).to(vector).ignoreAirBlocks(!optionsSet.contains((Object)PasteOptions.AIR)).ignoreEntities(!optionsSet.contains((Object)PasteOptions.ENTITIES)).ignoreBiomes(!optionsSet.contains((Object)PasteOptions.BIOMES)).build();
                    Operations.complete((Operation)operation);
                    return;
                }
                Repuska.warning("Invalid rotation angle for schematic: \"" + schematic.getFile().getName() + "\"");
                Repuska.warning("Valid angles are: 0, 90, 180, 270, 360");
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (editSession == null) return;
                editSession.close();
                return;
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return "paste schematic " + this.schematic.toString(e, debug) + " at " + this.location.toString(e, debug) + (this.angle != null ? " with angle " + this.angle.toString(e, debug) : "");
    }
}

