/*
 * Decompiled with CFR 0.152.
 */
package com.republicansensei.repuska.effects.we;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.republicansensei.repuska.Repuska;
import com.republicansensei.repuska.effects.we.adapter.FAWE_NEW;
import com.republicansensei.repuska.effects.we.adapter.FAWE_OLD;
import com.republicansensei.repuska.effects.we.adapter.WE_NEW;
import com.republicansensei.repuska.effects.we.adapter.WE_OLD;
import com.republicansensei.repuska.util.data.SchemFacingDirection;
import java.io.File;
import java.util.regex.Matcher;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.Event;

public class EffPasteSchematic
extends Effect {
    private Expression<?> name;
    private Expression<?> loc;
    private Expression<?> exair;
    private Expression<Number> angle;
    private int mark = 0;

    public boolean init(Expression<?>[] expression, int i, Kleenean kleenean, SkriptParser.ParseResult Result) {
        this.name = expression[0];
        this.loc = expression[1];
        this.exair = expression[2];
        this.angle = expression[3];
        this.mark = Result.mark;
        return true;
    }

    public String toString(Event e, boolean debug) {
        return "Paste schematic \"" + this.name + "\" at " + this.loc;
    }

    protected void execute(Event event) {
        String name = (String)this.name.getSingle(event);
        if (this.loc.getSingle(event) == null) {
            Repuska.warning("Location for schematic '" + name + "' is null");
            return;
        }
        Location loc = (Location)this.loc.getSingle(event);
        Boolean exair = false;
        exair = this.exair != null ? (Boolean)this.exair.getSingle(event) : Boolean.valueOf(false);
        try {
            switch (((Number)this.angle.getSingle(event)).intValue()) {
                case 0: 
                case 360: {
                    EffPasteSchematic.paste(name, loc, exair, SchemFacingDirection.NORTH);
                    break;
                }
                case 90: {
                    EffPasteSchematic.paste(name, loc, exair, SchemFacingDirection.EAST);
                    break;
                }
                case 180: {
                    EffPasteSchematic.paste(name, loc, exair, SchemFacingDirection.SOUTH);
                    break;
                }
                case 270: {
                    EffPasteSchematic.paste(name, loc, exair, SchemFacingDirection.WEST);
                    break;
                }
                default: {
                    EffPasteSchematic.paste(name, loc, exair, SchemFacingDirection.INVALID);
                    break;
                }
            }
        }
        catch (Exception e) {
            try {
                EffPasteSchematic.paste(name, loc, exair, SchemFacingDirection.NORTH);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private static boolean paste(String f, Location loc, Boolean exair, SchemFacingDirection facing) throws Exception {
        File file = f.startsWith("/") ? new File((String.valueOf(f) + ".schematic").replaceAll("/", Matcher.quoteReplacement(File.separator))) : new File(("plugins/WorldEdit/schematics/" + (f.contains(".") ? f : String.valueOf(f) + ".schematic")).replaceAll("/", Matcher.quoteReplacement(File.separator)));
        if (!file.exists() && file.isDirectory()) {
            return false;
        }
        if (Bukkit.getServer().getPluginManager().getPlugin("FastAsyncWorldEdit") != null) {
            try {
                Class<?> c = Class.forName("com.sk89q.worldedit.math.BlockVector3");
                if (c != null) {
                    FAWE_NEW.paste(file, loc, exair, facing);
                }
            }
            catch (ClassNotFoundException e) {
                FAWE_OLD.paste(file, loc, exair, facing);
            }
        } else if (Bukkit.getServer().getPluginManager().getPlugin("WorldEdit") != null) {
            try {
                Class<?> c = Class.forName("com.sk89q.worldedit.math.BlockVector3");
                if (c != null) {
                    WE_NEW.paste(file, loc, exair, facing);
                }
            }
            catch (ClassNotFoundException e) {
                WE_OLD.paste(file, loc, exair, facing);
            }
        }
        return true;
    }
}

