/*
 * Decompiled with CFR 0.152.
 */
package com.republicansensei.repuska.effects;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.lang.SkriptParser;
import com.republicansensei.repuska.Repuska;
import com.republicansensei.repuska.api.Description;
import com.republicansensei.repuska.api.Examples;
import com.republicansensei.repuska.api.Name;
import com.republicansensei.repuska.api.Patterns;
import com.republicansensei.repuska.collections.Loader;
import com.republicansensei.repuska.util.data.CancellableBukkitTask;
import com.republicansensei.repuska.util.data.OptionsPragma;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;

@Name(value="Developer Mode Option")
@Description(value="Enable the developer mode pragma to auto reload a script as it changes.  This must be placed under the script-local options.")
@Examples(value={"script options:;->$ developer mode"})
@Patterns(value={"$ developer mode"})
public class EffOptionDeveloperMode
extends OptionsPragma {
    private long lastUpdated;

    @Override
    protected void register(final File executingScript, SkriptParser.ParseResult parseResult) {
        this.lastUpdated = executingScript.lastModified();
        CancellableBukkitTask task = new CancellableBukkitTask(){

            @Override
            public void run() {
                if (EffOptionDeveloperMode.this.lastUpdated != executingScript.lastModified()) {
                    Bukkit.broadcastMessage((String)ChatColor.translateAlternateColorCodes((char)'&', (String)("&7[&6Repuska&7] &r(Dev Mode) Starting auto-reload of script '" + executingScript.getName() + "'")));
                    try {
                        Method unloadScript = ScriptLoader.class.getDeclaredMethod("unloadScript", File.class);
                        unloadScript.setAccessible(true);
                        unloadScript.invoke(null, executingScript);
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    Loader.loadFile(executingScript);
                    Bukkit.broadcastMessage((String)ChatColor.translateAlternateColorCodes((char)'&', (String)("&7[&6Repuska&7] &r(Dev Mode) '" + executingScript.getName() + "' has been reloaded.")));
                    this.cancel();
                }
            }
        };
        task.setTaskId(Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Repuska.getInstance(), (Runnable)task, 0L, 100L));
    }
}

