/*
 * Decompiled with CFR 0.152.
 */
package com.republicansensei.repuska;

import ch.njol.skript.Skript;
import com.republicansensei.repuska.Metrics;
import com.republicansensei.repuska.anvil.RegisterAnvilGUI;
import com.republicansensei.repuska.collections.obfuscator.ObfuscatorElements;
import com.republicansensei.repuska.gui.GUIManager;
import com.republicansensei.repuska.register.Conditions;
import com.republicansensei.repuska.register.Effects;
import com.republicansensei.repuska.register.Events;
import com.republicansensei.repuska.register.Expressions;
import com.republicansensei.repuska.register.Other;
import com.republicansensei.repuska.register.SkQuery;
import com.republicansensei.repuska.register.Types;
import com.republicansensei.repuska.versions.V2_3;
import com.republicansensei.repuska.versions.V2_4;
import com.republicansensei.repuska.versions.VersionAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public class Repuska
extends JavaPlugin
implements Listener {
    private static Repuska repuska;
    public static String version;
    private static int serverVersion;
    private static GUIManager gui;
    private static boolean enable;
    private static boolean skript;
    public static FileConfiguration mysqlData;
    private File mysqlFile;
    private boolean usesSkript24;
    private VersionAdapter adapter;

    public static Repuska getPluginInstance() {
        return (Repuska)Repuska.getPlugin(Repuska.class);
    }

    public void onEnable() {
        String initServerVer = Bukkit.getServer().getClass().getPackage().getName().substring(23);
        serverVersion = Integer.parseInt(Character.toString(initServerVer.charAt(3)));
        if (serverVersion == 1 && Integer.parseInt(Character.toString(initServerVer.charAt(4))) >= 0) {
            serverVersion = Integer.parseInt(String.valueOf(Integer.parseInt(Character.toString(initServerVer.charAt(3)))) + Integer.parseInt(Character.toString(initServerVer.charAt(4))));
        }
        repuska = this;
        PluginDescriptionFile pdf = this.getDescription();
        version = pdf.getVersion();
        Repuska.log("~ Created by RepublicanSensei");
        Repuska.log("~ Thanks to @Sashie, @LimeGlass, @Tuke_Nuke, @btk5h, @tim740, @TheBukor and @Nicofisi.");
        Repuska.log("~ Version: " + version + " ~ (1.8.8 - 1.15.x)");
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        if (this.cannot()) {
            return;
        }
        Skript.registerAddon((JavaPlugin)this);
        Other.metrics(new Metrics(this));
        Conditions.register();
        Effects.register();
        Events.register();
        Expressions.register();
        Types.register();
        RegisterAnvilGUI.registerAll();
        ObfuscatorElements.register();
        SkQuery.enableSnooper();
        this.mysqlFile = new File(this.getDataFolder(), "MySQL.yml");
        mysqlData = new YamlConfiguration();
        if (!this.mysqlFile.exists()) {
            this.mysqlFile.getParentFile().mkdirs();
            this.saveResource("MySQL.yml", false);
        }
        try {
            mysqlData.load(this.mysqlFile);
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Boolean reloadMysql = false;
        if (mysqlData.get("ClassPath") == null) {
            mysqlData.set("ClassPath", (Object)"jdbc:mysql://");
            reloadMysql = true;
        }
        if (mysqlData.get("SQLite") == null) {
            mysqlData.set("SQLite", (Object)false);
            reloadMysql = true;
        }
        if (mysqlData.get("autoReconnect") == null) {
            mysqlData.set("autoReconnect", (Object)true);
            reloadMysql = true;
        }
        if (reloadMysql.booleanValue()) {
            try {
                mysqlData.save(this.mysqlFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.usesSkript24 = Skript.getVersion().getMajor() >= 3 ? true : Skript.getVersion().getMajor() == 2 && Skript.getVersion().getMinor() >= 4;
        this.adapter = this.usesSkript24 ? new V2_4() : new V2_3();
    }

    private boolean cannot() {
        Plugin[] pluginArray = Bukkit.getPluginManager().getPlugins();
        int n = pluginArray.length;
        int n2 = 0;
        while (n2 < n) {
            Plugin plugin = pluginArray[n2];
            if (plugin.getName().equalsIgnoreCase("skript")) {
                Repuska.log("Skript hooked!");
                skript = true;
            }
            ++n2;
        }
        if (!skript) {
            Repuska.warning("Skript not found! Stopping registration ...");
            return true;
        }
        enable = true;
        return false;
    }

    public static Repuska getInstance() {
        return repuska;
    }

    public static String getVersion() {
        return version;
    }

    public static int getServerVersion() {
        return serverVersion;
    }

    public static void log(String log) {
        Bukkit.getLogger().info("[Repuska] " + log);
    }

    public static void severe(String log) {
        Bukkit.getLogger().warning("[Repuska] " + log);
    }

    public static void warning(String log) {
        Bukkit.getLogger().severe("[Repuska][Error] #!#");
        Bukkit.getLogger().severe("[Repuska][Error] #!# ======={ Repuska Warning }=======");
        Bukkit.getLogger().severe("[Repuska][Error] #!# " + log);
        Bukkit.getLogger().severe("[Repuska][Error] #!#");
    }

    public static void error(String log) {
        Bukkit.getLogger().severe("[Repuska][Error] #!#");
        Bukkit.getLogger().severe("[Repuska][Error] #!# =!!!======{ Repuska Error }======!!!=");
        Bukkit.getLogger().severe("[Repuska][Error] #!# " + log);
        Bukkit.getLogger().severe("[Repuska][Error] #!#");
        Bukkit.getLogger().severe("[Repuska][Error] #!#");
    }

    public VersionAdapter getVersionAdapter() {
        return this.adapter;
    }

    public static GUIManager getGUIManager() {
        if (gui == null) {
            gui = new GUIManager(Repuska.getInstance());
        }
        return gui;
    }

    public static boolean enabled() {
        return enable;
    }

    public static String getDefaultPath(String pth) {
        String dp = Paths.get("", new String[0]).normalize().toAbsolutePath().toString();
        if (pth.contains(dp)) {
            return String.valueOf(pth) + File.separator;
        }
        return String.valueOf(dp) + File.separator + pth;
    }
}

