/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.utils;

import java.net.URI;
import java.net.URISyntaxException;
import org.junit.Assert;
import org.junit.Test;
import redis.clients.util.JedisURIHelper;

public class JedisURIHelperTest {
    @Test
    public void shouldGetPasswordFromURIWithCredentials() throws URISyntaxException {
        URI uri = new URI("redis://user:password@host:9000/0");
        Assert.assertEquals((Object)"password", (Object)JedisURIHelper.getPassword(uri));
    }

    @Test
    public void shouldReturnNullIfURIDoesNotHaveCredentials() throws URISyntaxException {
        URI uri = new URI("redis://host:9000/0");
        Assert.assertNull((Object)JedisURIHelper.getPassword(uri));
    }

    @Test
    public void shouldGetDbFromURIWithCredentials() throws URISyntaxException {
        URI uri = new URI("redis://user:password@host:9000/3");
        Assert.assertEquals((long)3L, (long)JedisURIHelper.getDBIndex(uri));
    }

    @Test
    public void shouldGetDbFromURIWithoutCredentials() throws URISyntaxException {
        URI uri = new URI("redis://host:9000/4");
        Assert.assertEquals((long)4L, (long)JedisURIHelper.getDBIndex(uri));
    }

    @Test
    public void shouldGetDefaultDbFromURIIfNoDbWasSpecified() throws URISyntaxException {
        URI uri = new URI("redis://host:9000");
        Assert.assertEquals((long)0L, (long)JedisURIHelper.getDBIndex(uri));
    }

    @Test
    public void shouldValidateInvalidURIs() throws URISyntaxException {
        Assert.assertFalse((boolean)JedisURIHelper.isValid(new URI("host:9000")));
        Assert.assertFalse((boolean)JedisURIHelper.isValid(new URI("user:password@host:9000/0")));
        Assert.assertFalse((boolean)JedisURIHelper.isValid(new URI("host:9000/0")));
        Assert.assertFalse((boolean)JedisURIHelper.isValid(new URI("redis://host/0")));
    }
}

