/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.utils;

import java.util.concurrent.atomic.AtomicReference;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.tests.utils.FailoverAbortedException;

public class JedisSentinelTestUtil {
    public static HostAndPort waitForNewPromotedMaster(String masterName, Jedis sentinelJedis, Jedis commandJedis) throws InterruptedException {
        AtomicReference<String> newmaster = new AtomicReference<String>("");
        sentinelJedis.psubscribe(new JedisPubSub(){

            @Override
            public void onPMessage(String pattern, String channel, String message) {
                if (channel.equals("+switch-master")) {
                    newmaster.set(message);
                    this.punsubscribe();
                } else if (channel.startsWith("-failover-abort")) {
                    this.punsubscribe();
                    throw new FailoverAbortedException("Unfortunately sentinel cannot failover... reason(channel) : " + channel + " / message : " + message);
                }
            }

            @Override
            public void onPSubscribe(String pattern, int subscribedChannels) {
                commandJedis.sentinelFailover(masterName);
            }
        }, "*");
        String[] chunks = newmaster.get().split(" ");
        HostAndPort newMaster = new HostAndPort(chunks[3], Integer.parseInt(chunks[4]));
        return newMaster;
    }
}

