/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.utils;

import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisException;

public class JedisClusterTestUtil {
    public static void waitForClusterReady(Jedis ... nodes) throws InterruptedException {
        boolean clusterOk = false;
        while (!clusterOk) {
            boolean isOk = true;
            Jedis[] jedisArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                Jedis node = jedisArray[n2];
                if (!node.clusterInfo().split("\n")[0].contains("ok")) {
                    isOk = false;
                    break;
                }
                ++n2;
            }
            if (isOk) {
                clusterOk = true;
            }
            Thread.sleep(50L);
        }
    }

    public static String getNodeId(String infoOutput) {
        String[] stringArray = infoOutput.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String infoLine = stringArray[n2];
            if (infoLine.contains("myself")) {
                return infoLine.split(" ")[0];
            }
            ++n2;
        }
        return "";
    }

    public static String getNodeId(String infoOutput, HostAndPort node) {
        String[] stringArray = infoOutput.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String infoLine = stringArray[n2];
            if (infoLine.contains(node.toString())) {
                return infoLine.split(" ")[0];
            }
            ++n2;
        }
        return "";
    }

    public static void assertNodeIsKnown(Jedis node, String targetNodeId, int timeoutMs) {
        JedisClusterTestUtil.assertNodeRecognizedStatus(node, targetNodeId, true, timeoutMs);
    }

    public static void assertNodeIsUnknown(Jedis node, String targetNodeId, int timeoutMs) {
        JedisClusterTestUtil.assertNodeRecognizedStatus(node, targetNodeId, false, timeoutMs);
    }

    private static void assertNodeRecognizedStatus(Jedis node, String targetNodeId, boolean shouldRecognized, int timeoutMs) {
        int sleepInterval = 100;
        int sleepTime = 0;
        while (sleepTime <= timeoutMs) {
            boolean known = JedisClusterTestUtil.isKnownNode(node, targetNodeId);
            if (shouldRecognized == known) {
                return;
            }
            try {
                Thread.sleep(sleepInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            sleepTime += sleepInterval;
        }
        throw new JedisException("Node recognize check error");
    }

    private static boolean isKnownNode(Jedis node, String nodeId) {
        String infoOutput = node.clusterNodes();
        String[] stringArray = infoOutput.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String infoLine = stringArray[n2];
            if (infoLine.contains(nodeId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

