/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.utils;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import redis.clients.util.JedisClusterCRC16;
import redis.clients.util.SafeEncoder;

public class JedisClusterCRC16Test {
    @Test
    public void testGetCRC16() throws Exception {
        Map<String, Integer> solutions = this.prepareSolutionSet();
        for (Map.Entry<String, Integer> entry : solutions.entrySet()) {
            Assert.assertEquals((long)entry.getValue().intValue(), (long)JedisClusterCRC16.getCRC16(entry.getKey()));
            Assert.assertEquals((long)entry.getValue().intValue(), (long)JedisClusterCRC16.getCRC16(SafeEncoder.encode(entry.getKey())));
        }
    }

    @Test
    public void testGetSlot() {
        Assert.assertEquals((long)7186L, (long)JedisClusterCRC16.getSlot("51"));
    }

    private Map<String, Integer> prepareSolutionSet() {
        HashMap<String, Integer> solutionMap = new HashMap<String, Integer>();
        solutionMap.put("", 0);
        solutionMap.put("123456789", 12739);
        solutionMap.put("sfger132515", 42076);
        solutionMap.put("hae9Napahngaikeethievubaibogiech", 22734);
        solutionMap.put("AAAAAAAAAAAAAAAAAAAAAA", 37581);
        solutionMap.put("Hello, World!", 20438);
        return solutionMap;
    }
}

