/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.junit.Test;
import redis.clients.jedis.tests.commands.JedisCommandTestBase;

public class VariadicCommandsTest
extends JedisCommandTestBase {
    final byte[] bfoo = new byte[]{1, 2, 3, 4};
    final byte[] bbar = new byte[]{5, 6, 7, 8};
    final byte[] bcar = new byte[]{9, 10, 11, 12};
    final byte[] bfoo1 = new byte[]{1, 2, 3, 4, 10};
    final byte[] bfoo2 = new byte[]{1, 2, 3, 4, 11};

    @Test
    public void hdel() {
        HashMap<String, String> hash = new HashMap<String, String>();
        hash.put("bar", "car");
        hash.put("car", "bar");
        hash.put("foo2", "bar");
        this.jedis.hmset("foo", hash);
        VariadicCommandsTest.assertEquals((long)0L, (long)this.jedis.hdel("bar", "foo", "foo1").intValue());
        VariadicCommandsTest.assertEquals((long)0L, (long)this.jedis.hdel("foo", "foo", "foo1").intValue());
        VariadicCommandsTest.assertEquals((long)2L, (long)this.jedis.hdel("foo", "bar", "foo2").intValue());
        VariadicCommandsTest.assertEquals(null, (Object)this.jedis.hget("foo", "bar"));
        HashMap<byte[], byte[]> bhash = new HashMap<byte[], byte[]>();
        bhash.put(this.bbar, this.bcar);
        bhash.put(this.bcar, this.bbar);
        bhash.put(this.bfoo2, this.bbar);
        this.jedis.hmset(this.bfoo, bhash);
        VariadicCommandsTest.assertEquals((long)0L, (long)this.jedis.hdel(this.bbar, this.bfoo, this.bfoo1).intValue());
        VariadicCommandsTest.assertEquals((long)0L, (long)this.jedis.hdel(this.bfoo, this.bfoo, this.bfoo1).intValue());
        VariadicCommandsTest.assertEquals((long)2L, (long)this.jedis.hdel(this.bfoo, this.bbar, this.bfoo2).intValue());
        VariadicCommandsTest.assertEquals(null, (Object)this.jedis.hget(this.bfoo, this.bbar));
    }

    @Test
    public void rpush() {
        long size = this.jedis.rpush("foo", "bar", "foo");
        VariadicCommandsTest.assertEquals((long)2L, (long)size);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("bar");
        expected.add("foo");
        List<String> values = this.jedis.lrange("foo", 0L, -1L);
        VariadicCommandsTest.assertEquals(expected, values);
        size = this.jedis.rpush(this.bfoo, this.bbar, this.bfoo);
        VariadicCommandsTest.assertEquals((long)2L, (long)size);
        ArrayList<byte[]> bexpected = new ArrayList<byte[]>();
        bexpected.add(this.bbar);
        bexpected.add(this.bfoo);
        List<byte[]> bvalues = this.jedis.lrange(this.bfoo, 0L, -1L);
        this.assertEquals(bexpected, bvalues);
    }

    @Test
    public void lpush() {
        long size = this.jedis.lpush("foo", "bar", "foo");
        VariadicCommandsTest.assertEquals((long)2L, (long)size);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("foo");
        expected.add("bar");
        List<String> values = this.jedis.lrange("foo", 0L, -1L);
        VariadicCommandsTest.assertEquals(expected, values);
        size = this.jedis.lpush(this.bfoo, this.bbar, this.bfoo);
        VariadicCommandsTest.assertEquals((long)2L, (long)size);
        ArrayList<byte[]> bexpected = new ArrayList<byte[]>();
        bexpected.add(this.bfoo);
        bexpected.add(this.bbar);
        List<byte[]> bvalues = this.jedis.lrange(this.bfoo, 0L, -1L);
        this.assertEquals(bexpected, bvalues);
    }

    @Test
    public void sadd() {
        long status = this.jedis.sadd("foo", "bar", "foo1");
        VariadicCommandsTest.assertEquals((long)2L, (long)status);
        status = this.jedis.sadd("foo", "bar", "car");
        VariadicCommandsTest.assertEquals((long)1L, (long)status);
        status = this.jedis.sadd("foo", "bar", "foo1");
        VariadicCommandsTest.assertEquals((long)0L, (long)status);
        status = this.jedis.sadd(this.bfoo, this.bbar, this.bfoo1);
        VariadicCommandsTest.assertEquals((long)2L, (long)status);
        status = this.jedis.sadd(this.bfoo, this.bbar, this.bcar);
        VariadicCommandsTest.assertEquals((long)1L, (long)status);
        status = this.jedis.sadd(this.bfoo, this.bbar, this.bfoo1);
        VariadicCommandsTest.assertEquals((long)0L, (long)status);
    }

    @Test
    public void zadd() {
        HashMap<String, Double> scoreMembers = new HashMap<String, Double>();
        scoreMembers.put("bar", 1.0);
        scoreMembers.put("foo", 10.0);
        long status = this.jedis.zadd("foo", scoreMembers);
        VariadicCommandsTest.assertEquals((long)2L, (long)status);
        scoreMembers.clear();
        scoreMembers.put("car", 0.1);
        scoreMembers.put("bar", 2.0);
        status = this.jedis.zadd("foo", scoreMembers);
        VariadicCommandsTest.assertEquals((long)1L, (long)status);
        HashMap<byte[], Double> bscoreMembers = new HashMap<byte[], Double>();
        bscoreMembers.put(this.bbar, 1.0);
        bscoreMembers.put(this.bfoo, 10.0);
        status = this.jedis.zadd(this.bfoo, bscoreMembers);
        VariadicCommandsTest.assertEquals((long)2L, (long)status);
        bscoreMembers.clear();
        bscoreMembers.put(this.bcar, 0.1);
        bscoreMembers.put(this.bbar, 2.0);
        status = this.jedis.zadd(this.bfoo, bscoreMembers);
        VariadicCommandsTest.assertEquals((long)1L, (long)status);
    }

    @Test
    public void zrem() {
        this.jedis.zadd("foo", 1.0, "bar");
        this.jedis.zadd("foo", 2.0, "car");
        this.jedis.zadd("foo", 3.0, "foo1");
        long status = this.jedis.zrem("foo", "bar", "car");
        LinkedHashSet<String> expected = new LinkedHashSet<String>();
        expected.add("foo1");
        VariadicCommandsTest.assertEquals((long)2L, (long)status);
        VariadicCommandsTest.assertEquals(expected, this.jedis.zrange("foo", 0L, 100L));
        status = this.jedis.zrem("foo", "bar", "car");
        VariadicCommandsTest.assertEquals((long)0L, (long)status);
        status = this.jedis.zrem("foo", "bar", "foo1");
        VariadicCommandsTest.assertEquals((long)1L, (long)status);
        this.jedis.zadd(this.bfoo, 1.0, this.bbar);
        this.jedis.zadd(this.bfoo, 2.0, this.bcar);
        this.jedis.zadd(this.bfoo, 3.0, this.bfoo1);
        status = this.jedis.zrem(this.bfoo, this.bbar, this.bcar);
        LinkedHashSet<byte[]> bexpected = new LinkedHashSet<byte[]>();
        bexpected.add(this.bfoo);
        VariadicCommandsTest.assertEquals((long)2L, (long)status);
        this.assertEquals(bexpected, this.jedis.zrange(this.bfoo, 0L, 100L));
        status = this.jedis.zrem(this.bfoo, this.bbar, this.bcar);
        VariadicCommandsTest.assertEquals((long)0L, (long)status);
        status = this.jedis.zrem(this.bfoo, this.bbar, this.bfoo1);
        VariadicCommandsTest.assertEquals((long)1L, (long)status);
    }
}

