/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.commands;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.junit.Before;
import org.junit.Test;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.Response;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.tests.commands.JedisCommandTestBase;

public class TransactionCommandsTest
extends JedisCommandTestBase {
    final byte[] bfoo = new byte[]{1, 2, 3, 4};
    final byte[] bbar = new byte[]{5, 6, 7, 8};
    final byte[] ba = new byte[]{10};
    final byte[] bb = new byte[]{11};
    final byte[] bmykey = new byte[]{66, 2, 3, 4};
    Jedis nj;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.nj = new Jedis(hnp.getHost(), hnp.getPort(), 500);
        this.nj.connect();
        this.nj.auth("foobared");
        this.nj.flushAll();
    }

    @Test
    public void multi() {
        Transaction trans = this.jedis.multi();
        trans.sadd("foo", "a");
        trans.sadd("foo", "b");
        trans.scard("foo");
        List<Object> response = trans.exec();
        ArrayList<Long> expected = new ArrayList<Long>();
        expected.add(1L);
        expected.add(1L);
        expected.add(2L);
        TransactionCommandsTest.assertEquals(expected, response);
        trans = this.jedis.multi();
        trans.sadd(this.bfoo, new byte[][]{this.ba});
        trans.sadd(this.bfoo, new byte[][]{this.bb});
        trans.scard(this.bfoo);
        response = trans.exec();
        expected = new ArrayList();
        expected.add(1L);
        expected.add(1L);
        expected.add(2L);
        TransactionCommandsTest.assertEquals(expected, response);
    }

    @Test
    public void watch() throws UnknownHostException, IOException {
        this.jedis.watch("mykey", "somekey");
        Transaction t = this.jedis.multi();
        this.nj.connect();
        this.nj.auth("foobared");
        this.nj.set("mykey", "bar");
        this.nj.disconnect();
        t.set("mykey", "foo");
        List<Object> resp = t.exec();
        TransactionCommandsTest.assertEquals(null, resp);
        TransactionCommandsTest.assertEquals((Object)"bar", (Object)this.jedis.get("mykey"));
        this.jedis.watch(this.bmykey, "foobar".getBytes());
        t = this.jedis.multi();
        this.nj.connect();
        this.nj.auth("foobared");
        this.nj.set(this.bmykey, this.bbar);
        this.nj.disconnect();
        t.set(this.bmykey, this.bfoo);
        resp = t.exec();
        TransactionCommandsTest.assertEquals(null, resp);
        TransactionCommandsTest.assertTrue((boolean)Arrays.equals(this.bbar, this.jedis.get(this.bmykey)));
    }

    @Test
    public void unwatch() throws UnknownHostException, IOException {
        this.jedis.watch("mykey");
        String val = this.jedis.get("mykey");
        val = "foo";
        String status = this.jedis.unwatch();
        TransactionCommandsTest.assertEquals((Object)"OK", (Object)status);
        Transaction t = this.jedis.multi();
        this.nj.connect();
        this.nj.auth("foobared");
        this.nj.set("mykey", "bar");
        this.nj.disconnect();
        t.set("mykey", val);
        List<Object> resp = t.exec();
        TransactionCommandsTest.assertEquals((long)1L, (long)resp.size());
        TransactionCommandsTest.assertEquals((Object)"OK", (Object)resp.get(0));
        this.jedis.watch(new byte[][]{this.bmykey});
        byte[] bval = this.jedis.get(this.bmykey);
        bval = this.bfoo;
        status = this.jedis.unwatch();
        TransactionCommandsTest.assertEquals((Object)Protocol.Keyword.OK.name(), (Object)status);
        t = this.jedis.multi();
        this.nj.connect();
        this.nj.auth("foobared");
        this.nj.set(this.bmykey, this.bbar);
        this.nj.disconnect();
        t.set(this.bmykey, bval);
        resp = t.exec();
        TransactionCommandsTest.assertEquals((long)1L, (long)resp.size());
        TransactionCommandsTest.assertEquals((Object)"OK", (Object)resp.get(0));
    }

    @Test(expected=JedisDataException.class)
    public void validateWhenInMulti() {
        this.jedis.multi();
        this.jedis.ping();
    }

    @Test
    public void discard() {
        Transaction t = this.jedis.multi();
        String status = t.discard();
        TransactionCommandsTest.assertEquals((Object)"OK", (Object)status);
    }

    @Test
    public void transactionResponse() {
        this.jedis.set("string", "foo");
        this.jedis.lpush("list", "foo");
        this.jedis.hset("hash", "foo", "bar");
        this.jedis.zadd("zset", 1.0, "foo");
        this.jedis.sadd("set", "foo");
        Transaction t = this.jedis.multi();
        Response<String> string = t.get("string");
        Response<String> list = t.lpop("list");
        Response<String> hash = t.hget("hash", "foo");
        Response<Set<String>> zset = t.zrange("zset", 0L, -1L);
        Response<String> set = t.spop("set");
        t.exec();
        TransactionCommandsTest.assertEquals((Object)"foo", (Object)string.get());
        TransactionCommandsTest.assertEquals((Object)"foo", (Object)list.get());
        TransactionCommandsTest.assertEquals((Object)"bar", (Object)hash.get());
        TransactionCommandsTest.assertEquals((Object)"foo", (Object)zset.get().iterator().next());
        TransactionCommandsTest.assertEquals((Object)"foo", (Object)set.get());
    }

    @Test
    public void transactionResponseBinary() {
        this.jedis.set("string", "foo");
        this.jedis.lpush("list", "foo");
        this.jedis.hset("hash", "foo", "bar");
        this.jedis.zadd("zset", 1.0, "foo");
        this.jedis.sadd("set", "foo");
        Transaction t = this.jedis.multi();
        Response<byte[]> string = t.get("string".getBytes());
        Response<byte[]> list = t.lpop("list".getBytes());
        Response<byte[]> hash = t.hget("hash".getBytes(), "foo".getBytes());
        Response<Set<byte[]>> zset = t.zrange("zset".getBytes(), 0L, -1L);
        Response<byte[]> set = t.spop("set".getBytes());
        t.exec();
        TransactionCommandsTest.assertArrayEquals((byte[])"foo".getBytes(), (byte[])string.get());
        TransactionCommandsTest.assertArrayEquals((byte[])"foo".getBytes(), (byte[])list.get());
        TransactionCommandsTest.assertArrayEquals((byte[])"bar".getBytes(), (byte[])hash.get());
        TransactionCommandsTest.assertArrayEquals((byte[])"foo".getBytes(), (byte[])zset.get().iterator().next());
        TransactionCommandsTest.assertArrayEquals((byte[])"foo".getBytes(), (byte[])set.get());
    }

    @Test(expected=JedisDataException.class)
    public void transactionResponseWithinPipeline() {
        this.jedis.set("string", "foo");
        Transaction t = this.jedis.multi();
        Response<String> string = t.get("string");
        string.get();
        t.exec();
    }

    @Test
    public void transactionResponseWithError() {
        Transaction t = this.jedis.multi();
        t.set("foo", "bar");
        Response<Set<String>> error = t.smembers("foo");
        Response<String> r = t.get("foo");
        List<Object> l = t.exec();
        TransactionCommandsTest.assertEquals(JedisDataException.class, l.get(1).getClass());
        try {
            error.get();
            TransactionCommandsTest.fail((String)"We expect exception here!");
        }
        catch (JedisDataException jedisDataException) {
            // empty catch block
        }
        TransactionCommandsTest.assertEquals((Object)r.get(), (Object)"bar");
    }

    @Test
    public void execGetResponse() {
        Transaction t = this.jedis.multi();
        t.set("foo", "bar");
        t.smembers("foo");
        t.get("foo");
        List<Response<?>> lr = t.execGetResponse();
        try {
            lr.get(1).get();
            TransactionCommandsTest.fail((String)"We expect exception here!");
        }
        catch (JedisDataException jedisDataException) {
            // empty catch block
        }
        TransactionCommandsTest.assertEquals((Object)"bar", lr.get(2).get());
    }

    @Test
    public void select() {
        this.jedis.select(1);
        this.jedis.set("foo", "bar");
        this.jedis.watch("foo");
        Transaction t = this.jedis.multi();
        t.select(0);
        t.set("bar", "foo");
        Jedis jedis2 = this.createJedis();
        jedis2.select(1);
        jedis2.set("foo", "bar2");
        List<Object> results = t.exec();
        TransactionCommandsTest.assertNull(results);
    }

    @Test
    public void testResetStateWhenInMulti() {
        this.jedis.auth("foobared");
        Transaction t = this.jedis.multi();
        t.set("foooo", "barrr");
        this.jedis.resetState();
        TransactionCommandsTest.assertEquals(null, (Object)this.jedis.get("foooo"));
    }

    @Test
    public void testResetStateWhenInMultiWithinPipeline() {
        this.jedis.auth("foobared");
        Pipeline p = this.jedis.pipelined();
        p.multi();
        p.set("foooo", "barrr");
        this.jedis.resetState();
        TransactionCommandsTest.assertEquals(null, (Object)this.jedis.get("foooo"));
    }

    @Test
    public void testResetStateWhenInWatch() {
        this.jedis.watch("mykey", "somekey");
        this.jedis.resetState();
        Transaction t = this.jedis.multi();
        this.nj.connect();
        this.nj.auth("foobared");
        this.nj.set("mykey", "bar");
        this.nj.disconnect();
        t.set("mykey", "foo");
        List<Object> resp = t.exec();
        TransactionCommandsTest.assertNotNull(resp);
        TransactionCommandsTest.assertEquals((long)1L, (long)resp.size());
        TransactionCommandsTest.assertEquals((Object)"foo", (Object)this.jedis.get("mykey"));
    }

    @Test
    public void testResetStateWithFullyExecutedTransaction() {
        Jedis jedis2 = new Jedis(this.jedis.getClient().getHost(), this.jedis.getClient().getPort());
        jedis2.auth("foobared");
        Transaction t = jedis2.multi();
        t.set("mykey", "foo");
        t.get("mykey");
        List<Object> resp = t.exec();
        TransactionCommandsTest.assertNotNull(resp);
        TransactionCommandsTest.assertEquals((long)2L, (long)resp.size());
        jedis2.resetState();
        jedis2.close();
    }

    @Test
    public void testCloseable() throws IOException {
        Jedis jedis2 = new Jedis(hnp.getHost(), hnp.getPort(), 500);
        jedis2.auth("foobared");
        Transaction transaction = jedis2.multi();
        transaction.set("a", "1");
        transaction.set("b", "2");
        transaction.close();
        try {
            transaction.exec();
            TransactionCommandsTest.fail((String)"close should discard transaction");
        }
        catch (JedisDataException e) {
            TransactionCommandsTest.assertTrue((boolean)e.getMessage().contains("EXEC without MULTI"));
        }
    }
}

