/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.commands;

import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.tests.commands.JedisCommandTestBase;

public class StringValuesCommandsTest
extends JedisCommandTestBase {
    @Test
    public void setAndGet() {
        String status = this.jedis.set("foo", "bar");
        StringValuesCommandsTest.assertEquals((Object)"OK", (Object)status);
        String value = this.jedis.get("foo");
        StringValuesCommandsTest.assertEquals((Object)"bar", (Object)value);
        StringValuesCommandsTest.assertEquals(null, (Object)this.jedis.get("bar"));
    }

    @Test
    public void getSet() {
        String value = this.jedis.getSet("foo", "bar");
        StringValuesCommandsTest.assertEquals(null, (Object)value);
        value = this.jedis.get("foo");
        StringValuesCommandsTest.assertEquals((Object)"bar", (Object)value);
    }

    @Test
    public void mget() {
        List<String> values = this.jedis.mget("foo", "bar");
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(null);
        expected.add(null);
        StringValuesCommandsTest.assertEquals(expected, values);
        this.jedis.set("foo", "bar");
        expected = new ArrayList();
        expected.add("bar");
        expected.add(null);
        values = this.jedis.mget("foo", "bar");
        StringValuesCommandsTest.assertEquals(expected, values);
        this.jedis.set("bar", "foo");
        expected = new ArrayList();
        expected.add("bar");
        expected.add("foo");
        values = this.jedis.mget("foo", "bar");
        StringValuesCommandsTest.assertEquals(expected, values);
    }

    @Test
    public void setnx() {
        long status = this.jedis.setnx("foo", "bar");
        StringValuesCommandsTest.assertEquals((long)1L, (long)status);
        StringValuesCommandsTest.assertEquals((Object)"bar", (Object)this.jedis.get("foo"));
        status = this.jedis.setnx("foo", "bar2");
        StringValuesCommandsTest.assertEquals((long)0L, (long)status);
        StringValuesCommandsTest.assertEquals((Object)"bar", (Object)this.jedis.get("foo"));
    }

    @Test
    public void setex() {
        String status = this.jedis.setex("foo", 20, "bar");
        StringValuesCommandsTest.assertEquals((Object)"OK", (Object)status);
        long ttl = this.jedis.ttl("foo");
        StringValuesCommandsTest.assertTrue((ttl > 0L && ttl <= 20L ? 1 : 0) != 0);
    }

    @Test
    public void mset() {
        String status = this.jedis.mset("foo", "bar", "bar", "foo");
        StringValuesCommandsTest.assertEquals((Object)"OK", (Object)status);
        StringValuesCommandsTest.assertEquals((Object)"bar", (Object)this.jedis.get("foo"));
        StringValuesCommandsTest.assertEquals((Object)"foo", (Object)this.jedis.get("bar"));
    }

    @Test
    public void msetnx() {
        long status = this.jedis.msetnx("foo", "bar", "bar", "foo");
        StringValuesCommandsTest.assertEquals((long)1L, (long)status);
        StringValuesCommandsTest.assertEquals((Object)"bar", (Object)this.jedis.get("foo"));
        StringValuesCommandsTest.assertEquals((Object)"foo", (Object)this.jedis.get("bar"));
        status = this.jedis.msetnx("foo", "bar1", "bar2", "foo2");
        StringValuesCommandsTest.assertEquals((long)0L, (long)status);
        StringValuesCommandsTest.assertEquals((Object)"bar", (Object)this.jedis.get("foo"));
        StringValuesCommandsTest.assertEquals((Object)"foo", (Object)this.jedis.get("bar"));
    }

    @Test(expected=JedisDataException.class)
    public void incrWrongValue() {
        this.jedis.set("foo", "bar");
        this.jedis.incr("foo");
    }

    @Test
    public void incr() {
        long value = this.jedis.incr("foo");
        StringValuesCommandsTest.assertEquals((long)1L, (long)value);
        value = this.jedis.incr("foo");
        StringValuesCommandsTest.assertEquals((long)2L, (long)value);
    }

    @Test(expected=JedisDataException.class)
    public void incrByWrongValue() {
        this.jedis.set("foo", "bar");
        this.jedis.incrBy("foo", 2L);
    }

    @Test
    public void incrBy() {
        long value = this.jedis.incrBy("foo", 2L);
        StringValuesCommandsTest.assertEquals((long)2L, (long)value);
        value = this.jedis.incrBy("foo", 2L);
        StringValuesCommandsTest.assertEquals((long)4L, (long)value);
    }

    @Test(expected=JedisDataException.class)
    public void incrByFloatWrongValue() {
        this.jedis.set("foo", "bar");
        this.jedis.incrByFloat("foo", 2.0);
    }

    @Test(expected=JedisDataException.class)
    public void decrWrongValue() {
        this.jedis.set("foo", "bar");
        this.jedis.decr("foo");
    }

    @Test
    public void decr() {
        long value = this.jedis.decr("foo");
        StringValuesCommandsTest.assertEquals((long)-1L, (long)value);
        value = this.jedis.decr("foo");
        StringValuesCommandsTest.assertEquals((long)-2L, (long)value);
    }

    @Test(expected=JedisDataException.class)
    public void decrByWrongValue() {
        this.jedis.set("foo", "bar");
        this.jedis.decrBy("foo", 2L);
    }

    @Test
    public void decrBy() {
        long value = this.jedis.decrBy("foo", 2L);
        StringValuesCommandsTest.assertEquals((long)-2L, (long)value);
        value = this.jedis.decrBy("foo", 2L);
        StringValuesCommandsTest.assertEquals((long)-4L, (long)value);
    }

    @Test
    public void append() {
        long value = this.jedis.append("foo", "bar");
        StringValuesCommandsTest.assertEquals((long)3L, (long)value);
        StringValuesCommandsTest.assertEquals((Object)"bar", (Object)this.jedis.get("foo"));
        value = this.jedis.append("foo", "bar");
        StringValuesCommandsTest.assertEquals((long)6L, (long)value);
        StringValuesCommandsTest.assertEquals((Object)"barbar", (Object)this.jedis.get("foo"));
    }

    @Test
    public void substr() {
        this.jedis.set("s", "This is a string");
        StringValuesCommandsTest.assertEquals((Object)"This", (Object)this.jedis.substr("s", 0, 3));
        StringValuesCommandsTest.assertEquals((Object)"ing", (Object)this.jedis.substr("s", -3, -1));
        StringValuesCommandsTest.assertEquals((Object)"This is a string", (Object)this.jedis.substr("s", 0, -1));
        StringValuesCommandsTest.assertEquals((Object)" string", (Object)this.jedis.substr("s", 9, 100000));
    }

    @Test
    public void strlen() {
        this.jedis.set("s", "This is a string");
        StringValuesCommandsTest.assertEquals((long)"This is a string".length(), (long)this.jedis.strlen("s").intValue());
    }

    @Test
    public void incrLargeNumbers() {
        long value = this.jedis.incr("foo");
        StringValuesCommandsTest.assertEquals((long)1L, (long)value);
        StringValuesCommandsTest.assertEquals((long)0x80000000L, (long)this.jedis.incrBy("foo", Integer.MAX_VALUE));
    }

    @Test(expected=JedisDataException.class)
    public void incrReallyLargeNumbers() {
        this.jedis.set("foo", Long.toString(Long.MAX_VALUE));
        long value = this.jedis.incr("foo");
        StringValuesCommandsTest.assertEquals((long)Long.MIN_VALUE, (long)value);
    }

    @Test
    public void incrByFloat() {
        double value = this.jedis.incrByFloat("foo", 10.5);
        StringValuesCommandsTest.assertEquals((double)10.5, (double)value, (double)0.0);
        value = this.jedis.incrByFloat("foo", 0.1);
        StringValuesCommandsTest.assertEquals((double)10.6, (double)value, (double)0.0);
    }

    @Test
    public void psetex() {
        String status = this.jedis.psetex("foo", 20000, "bar");
        StringValuesCommandsTest.assertEquals((Object)"OK", (Object)status);
        long ttl = this.jedis.ttl("foo");
        StringValuesCommandsTest.assertTrue((ttl > 0L && ttl <= 20000L ? 1 : 0) != 0);
    }
}

