/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.commands;

import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.tests.commands.JedisCommandTestBase;

public class SortingCommandsTest
extends JedisCommandTestBase {
    final byte[] bfoo = new byte[]{1, 2, 3, 4};
    final byte[] bbar1 = new byte[]{5, 6, 7, 8, 49};
    final byte[] bbar2 = new byte[]{5, 6, 7, 8, 50};
    final byte[] bbar3 = new byte[]{5, 6, 7, 8, 51};
    final byte[] bbar10 = new byte[]{5, 6, 7, 8, 49, 48};
    final byte[] bbarstar = new byte[]{5, 6, 7, 8, 42};
    final byte[] bcar1 = new byte[]{10, 11, 12, 13, 49};
    final byte[] bcar2 = new byte[]{10, 11, 12, 13, 50};
    final byte[] bcar10 = new byte[]{10, 11, 12, 13, 49, 48};
    final byte[] bcarstar = new byte[]{10, 11, 12, 13, 42};
    final byte[] b1 = new byte[]{49};
    final byte[] b2 = new byte[]{50};
    final byte[] b3 = new byte[]{51};
    final byte[] b10 = new byte[]{49, 48};

    @Test
    public void sort() {
        this.jedis.lpush("foo", "3");
        this.jedis.lpush("foo", "2");
        this.jedis.lpush("foo", "1");
        List<String> result = this.jedis.sort("foo");
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("1");
        expected.add("2");
        expected.add("3");
        SortingCommandsTest.assertEquals(expected, result);
        this.jedis.lpush(this.bfoo, new byte[][]{this.b3});
        this.jedis.lpush(this.bfoo, new byte[][]{this.b2});
        this.jedis.lpush(this.bfoo, new byte[][]{this.b1});
        List<byte[]> bresult = this.jedis.sort(this.bfoo);
        ArrayList<byte[]> bexpected = new ArrayList<byte[]>();
        bexpected.add(this.b1);
        bexpected.add(this.b2);
        bexpected.add(this.b3);
        this.assertEquals(bexpected, bresult);
    }

    @Test
    public void sortBy() {
        this.jedis.lpush("foo", "2");
        this.jedis.lpush("foo", "3");
        this.jedis.lpush("foo", "1");
        this.jedis.set("bar1", "3");
        this.jedis.set("bar2", "2");
        this.jedis.set("bar3", "1");
        SortingParams sp = new SortingParams();
        sp.by("bar*");
        List<String> result = this.jedis.sort("foo", sp);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("3");
        expected.add("2");
        expected.add("1");
        SortingCommandsTest.assertEquals(expected, result);
        this.jedis.lpush(this.bfoo, new byte[][]{this.b2});
        this.jedis.lpush(this.bfoo, new byte[][]{this.b3});
        this.jedis.lpush(this.bfoo, new byte[][]{this.b1});
        this.jedis.set(this.bbar1, this.b3);
        this.jedis.set(this.bbar2, this.b2);
        this.jedis.set(this.bbar3, this.b1);
        SortingParams bsp = new SortingParams();
        bsp.by(this.bbarstar);
        List<byte[]> bresult = this.jedis.sort(this.bfoo, bsp);
        ArrayList<byte[]> bexpected = new ArrayList<byte[]>();
        bexpected.add(this.b3);
        bexpected.add(this.b2);
        bexpected.add(this.b1);
        this.assertEquals(bexpected, bresult);
    }

    @Test
    public void sortDesc() {
        this.jedis.lpush("foo", "3");
        this.jedis.lpush("foo", "2");
        this.jedis.lpush("foo", "1");
        SortingParams sp = new SortingParams();
        sp.desc();
        List<String> result = this.jedis.sort("foo", sp);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("3");
        expected.add("2");
        expected.add("1");
        SortingCommandsTest.assertEquals(expected, result);
        this.jedis.lpush(this.bfoo, new byte[][]{this.b3});
        this.jedis.lpush(this.bfoo, new byte[][]{this.b2});
        this.jedis.lpush(this.bfoo, new byte[][]{this.b1});
        SortingParams bsp = new SortingParams();
        bsp.desc();
        List<byte[]> bresult = this.jedis.sort(this.bfoo, bsp);
        ArrayList<byte[]> bexpected = new ArrayList<byte[]>();
        bexpected.add(this.b3);
        bexpected.add(this.b2);
        bexpected.add(this.b1);
        this.assertEquals(bexpected, bresult);
    }

    @Test
    public void sortLimit() {
        int n = 10;
        while (n > 0) {
            this.jedis.lpush("foo", String.valueOf(n));
            --n;
        }
        SortingParams sp = new SortingParams();
        sp.limit(0, 3);
        List<String> result = this.jedis.sort("foo", sp);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("1");
        expected.add("2");
        expected.add("3");
        SortingCommandsTest.assertEquals(expected, result);
        this.jedis.rpush(this.bfoo, new byte[][]{{52}});
        this.jedis.rpush(this.bfoo, new byte[][]{{51}});
        this.jedis.rpush(this.bfoo, new byte[][]{{50}});
        this.jedis.rpush(this.bfoo, new byte[][]{{49}});
        SortingParams bsp = new SortingParams();
        bsp.limit(0, 3);
        List<byte[]> bresult = this.jedis.sort(this.bfoo, bsp);
        ArrayList<byte[]> bexpected = new ArrayList<byte[]>();
        bexpected.add(this.b1);
        bexpected.add(this.b2);
        bexpected.add(this.b3);
        this.assertEquals(bexpected, bresult);
    }

    @Test
    public void sortAlpha() {
        this.jedis.lpush("foo", "1");
        this.jedis.lpush("foo", "2");
        this.jedis.lpush("foo", "10");
        SortingParams sp = new SortingParams();
        sp.alpha();
        List<String> result = this.jedis.sort("foo", sp);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("1");
        expected.add("10");
        expected.add("2");
        SortingCommandsTest.assertEquals(expected, result);
        this.jedis.lpush(this.bfoo, new byte[][]{this.b1});
        this.jedis.lpush(this.bfoo, new byte[][]{this.b2});
        this.jedis.lpush(this.bfoo, new byte[][]{this.b10});
        SortingParams bsp = new SortingParams();
        bsp.alpha();
        List<byte[]> bresult = this.jedis.sort(this.bfoo, bsp);
        ArrayList<byte[]> bexpected = new ArrayList<byte[]>();
        bexpected.add(this.b1);
        bexpected.add(this.b10);
        bexpected.add(this.b2);
        this.assertEquals(bexpected, bresult);
    }

    @Test
    public void sortGet() {
        this.jedis.lpush("foo", "1");
        this.jedis.lpush("foo", "2");
        this.jedis.lpush("foo", "10");
        this.jedis.set("bar1", "bar1");
        this.jedis.set("bar2", "bar2");
        this.jedis.set("bar10", "bar10");
        this.jedis.set("car1", "car1");
        this.jedis.set("car2", "car2");
        this.jedis.set("car10", "car10");
        SortingParams sp = new SortingParams();
        sp.get("car*", "bar*");
        List<String> result = this.jedis.sort("foo", sp);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("car1");
        expected.add("bar1");
        expected.add("car2");
        expected.add("bar2");
        expected.add("car10");
        expected.add("bar10");
        SortingCommandsTest.assertEquals(expected, result);
        this.jedis.lpush(this.bfoo, new byte[][]{this.b1});
        this.jedis.lpush(this.bfoo, new byte[][]{this.b2});
        this.jedis.lpush(this.bfoo, new byte[][]{this.b10});
        this.jedis.set(this.bbar1, this.bbar1);
        this.jedis.set(this.bbar2, this.bbar2);
        this.jedis.set(this.bbar10, this.bbar10);
        this.jedis.set(this.bcar1, this.bcar1);
        this.jedis.set(this.bcar2, this.bcar2);
        this.jedis.set(this.bcar10, this.bcar10);
        SortingParams bsp = new SortingParams();
        bsp.get(this.bcarstar, this.bbarstar);
        List<byte[]> bresult = this.jedis.sort(this.bfoo, bsp);
        ArrayList<byte[]> bexpected = new ArrayList<byte[]>();
        bexpected.add(this.bcar1);
        bexpected.add(this.bbar1);
        bexpected.add(this.bcar2);
        bexpected.add(this.bbar2);
        bexpected.add(this.bcar10);
        bexpected.add(this.bbar10);
        this.assertEquals(bexpected, bresult);
    }

    @Test
    public void sortStore() {
        this.jedis.lpush("foo", "1");
        this.jedis.lpush("foo", "2");
        this.jedis.lpush("foo", "10");
        long result = this.jedis.sort("foo", "result");
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("1");
        expected.add("2");
        expected.add("10");
        SortingCommandsTest.assertEquals((long)3L, (long)result);
        SortingCommandsTest.assertEquals(expected, this.jedis.lrange("result", 0L, 1000L));
        this.jedis.lpush(this.bfoo, new byte[][]{this.b1});
        this.jedis.lpush(this.bfoo, new byte[][]{this.b2});
        this.jedis.lpush(this.bfoo, new byte[][]{this.b10});
        byte[] bkresult = new byte[]{9, 10, 11, 12};
        long bresult = this.jedis.sort(this.bfoo, bkresult);
        ArrayList<byte[]> bexpected = new ArrayList<byte[]>();
        bexpected.add(this.b1);
        bexpected.add(this.b2);
        bexpected.add(this.b10);
        SortingCommandsTest.assertEquals((long)3L, (long)bresult);
        this.assertEquals(bexpected, this.jedis.lrange(bkresult, 0L, 1000L));
    }
}

