/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.commands;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.junit.Test;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.params.sortedset.ZAddParams;
import redis.clients.jedis.params.sortedset.ZIncrByParams;
import redis.clients.jedis.tests.commands.JedisCommandTestBase;
import redis.clients.util.SafeEncoder;

public class SortedSetCommandsTest
extends JedisCommandTestBase {
    final byte[] bfoo = new byte[]{1, 2, 3, 4};
    final byte[] bbar = new byte[]{5, 6, 7, 8};
    final byte[] bcar = new byte[]{9, 10, 11, 12};
    final byte[] ba = new byte[]{10};
    final byte[] bb = new byte[]{11};
    final byte[] bc = new byte[]{12};
    final byte[] bbar1 = new byte[]{5, 6, 7, 8, 10};
    final byte[] bbar2 = new byte[]{5, 6, 7, 8, 11};
    final byte[] bbar3 = new byte[]{5, 6, 7, 8, 12};
    final byte[] bbarstar = new byte[]{5, 6, 7, 8, 42};
    final byte[] bInclusiveB = new byte[]{91, 11};
    final byte[] bExclusiveC = new byte[]{40, 12};
    final byte[] bLexMinusInf = new byte[]{45};
    final byte[] bLexPlusInf = new byte[]{43};

    @Test
    public void zadd() {
        long status = this.jedis.zadd("foo", 1.0, "a");
        SortedSetCommandsTest.assertEquals((long)1L, (long)status);
        status = this.jedis.zadd("foo", 10.0, "b");
        SortedSetCommandsTest.assertEquals((long)1L, (long)status);
        status = this.jedis.zadd("foo", 0.1, "c");
        SortedSetCommandsTest.assertEquals((long)1L, (long)status);
        status = this.jedis.zadd("foo", 2.0, "a");
        SortedSetCommandsTest.assertEquals((long)0L, (long)status);
        long bstatus = this.jedis.zadd(this.bfoo, 1.0, this.ba);
        SortedSetCommandsTest.assertEquals((long)1L, (long)bstatus);
        bstatus = this.jedis.zadd(this.bfoo, 10.0, this.bb);
        SortedSetCommandsTest.assertEquals((long)1L, (long)bstatus);
        bstatus = this.jedis.zadd(this.bfoo, 0.1, this.bc);
        SortedSetCommandsTest.assertEquals((long)1L, (long)bstatus);
        bstatus = this.jedis.zadd(this.bfoo, 2.0, this.ba);
        SortedSetCommandsTest.assertEquals((long)0L, (long)bstatus);
    }

    @Test
    public void zaddWithParams() {
        this.jedis.del("foo");
        long status = this.jedis.zadd("foo", 1.0, "a", ZAddParams.zAddParams().xx());
        SortedSetCommandsTest.assertEquals((long)0L, (long)status);
        this.jedis.zadd("foo", 1.0, "a");
        status = this.jedis.zadd("foo", 2.0, "a", ZAddParams.zAddParams().nx());
        SortedSetCommandsTest.assertEquals((long)0L, (long)status);
        SortedSetCommandsTest.assertEquals((Object)1.0, (Object)this.jedis.zscore("foo", "a"));
        HashMap<String, Double> scoreMembers = new HashMap<String, Double>();
        scoreMembers.put("a", 2.0);
        scoreMembers.put("b", 1.0);
        status = this.jedis.zadd("foo", scoreMembers, ZAddParams.zAddParams().ch());
        SortedSetCommandsTest.assertEquals((long)2L, (long)status);
        this.jedis.del(this.bfoo);
        status = this.jedis.zadd(this.bfoo, 1.0, this.ba, ZAddParams.zAddParams().xx());
        SortedSetCommandsTest.assertEquals((long)0L, (long)status);
        this.jedis.zadd(this.bfoo, 1.0, this.ba);
        status = this.jedis.zadd(this.bfoo, 2.0, this.ba, ZAddParams.zAddParams().nx());
        SortedSetCommandsTest.assertEquals((long)0L, (long)status);
        SortedSetCommandsTest.assertEquals((Object)1.0, (Object)this.jedis.zscore(this.bfoo, this.ba));
        HashMap<byte[], Double> binaryScoreMembers = new HashMap<byte[], Double>();
        binaryScoreMembers.put(this.ba, 2.0);
        binaryScoreMembers.put(this.bb, 1.0);
        status = this.jedis.zadd(this.bfoo, binaryScoreMembers, ZAddParams.zAddParams().ch());
        SortedSetCommandsTest.assertEquals((long)2L, (long)status);
    }

    @Test
    public void zrange() {
        this.jedis.zadd("foo", 1.0, "a");
        this.jedis.zadd("foo", 10.0, "b");
        this.jedis.zadd("foo", 0.1, "c");
        this.jedis.zadd("foo", 2.0, "a");
        LinkedHashSet<String> expected = new LinkedHashSet<String>();
        expected.add("c");
        expected.add("a");
        Set<String> range = this.jedis.zrange("foo", 0L, 1L);
        SortedSetCommandsTest.assertEquals(expected, range);
        expected.add("b");
        range = this.jedis.zrange("foo", 0L, 100L);
        SortedSetCommandsTest.assertEquals(expected, range);
        this.jedis.zadd(this.bfoo, 1.0, this.ba);
        this.jedis.zadd(this.bfoo, 10.0, this.bb);
        this.jedis.zadd(this.bfoo, 0.1, this.bc);
        this.jedis.zadd(this.bfoo, 2.0, this.ba);
        LinkedHashSet<byte[]> bexpected = new LinkedHashSet<byte[]>();
        bexpected.add(this.bc);
        bexpected.add(this.ba);
        Set<byte[]> brange = this.jedis.zrange(this.bfoo, 0L, 1L);
        this.assertEquals(bexpected, brange);
        bexpected.add(this.bb);
        brange = this.jedis.zrange(this.bfoo, 0L, 100L);
        this.assertEquals(bexpected, brange);
    }

    @Test
    public void zrangeByLex() {
        this.jedis.zadd("foo", 1.0, "aa");
        this.jedis.zadd("foo", 1.0, "c");
        this.jedis.zadd("foo", 1.0, "bb");
        this.jedis.zadd("foo", 1.0, "d");
        LinkedHashSet<String> expected = new LinkedHashSet<String>();
        expected.add("bb");
        expected.add("c");
        SortedSetCommandsTest.assertEquals(expected, this.jedis.zrangeByLex("foo", "(aa", "[c"));
        expected.clear();
        expected.add("bb");
        expected.add("c");
        SortedSetCommandsTest.assertEquals(expected, this.jedis.zrangeByLex("foo", "-", "+", 1, 2));
    }

    @Test
    public void zrangeByLexBinary() {
        this.jedis.zadd(this.bfoo, 1.0, this.ba);
        this.jedis.zadd(this.bfoo, 1.0, this.bc);
        this.jedis.zadd(this.bfoo, 1.0, this.bb);
        LinkedHashSet<byte[]> bExpected = new LinkedHashSet<byte[]>();
        bExpected.add(this.bb);
        this.assertEquals(bExpected, this.jedis.zrangeByLex(this.bfoo, this.bInclusiveB, this.bExclusiveC));
        bExpected.clear();
        bExpected.add(this.ba);
        bExpected.add(this.bb);
        this.assertEquals(bExpected, this.jedis.zrangeByLex(this.bfoo, this.bLexMinusInf, this.bLexPlusInf, 0, 2));
    }

    @Test
    public void zrevrangeByLex() {
        this.jedis.zadd("foo", 1.0, "aa");
        this.jedis.zadd("foo", 1.0, "c");
        this.jedis.zadd("foo", 1.0, "bb");
        this.jedis.zadd("foo", 1.0, "d");
        LinkedHashSet<String> expected = new LinkedHashSet<String>();
        expected.add("c");
        expected.add("bb");
        SortedSetCommandsTest.assertEquals(expected, this.jedis.zrevrangeByLex("foo", "[c", "(aa"));
        expected.clear();
        expected.add("c");
        expected.add("bb");
        SortedSetCommandsTest.assertEquals(expected, this.jedis.zrevrangeByLex("foo", "+", "-", 1, 2));
    }

    @Test
    public void zrevrangeByLexBinary() {
        this.jedis.zadd(this.bfoo, 1.0, this.ba);
        this.jedis.zadd(this.bfoo, 1.0, this.bc);
        this.jedis.zadd(this.bfoo, 1.0, this.bb);
        LinkedHashSet<byte[]> bExpected = new LinkedHashSet<byte[]>();
        bExpected.add(this.bb);
        this.assertEquals(bExpected, this.jedis.zrevrangeByLex(this.bfoo, this.bExclusiveC, this.bInclusiveB));
        bExpected.clear();
        bExpected.add(this.bb);
        bExpected.add(this.ba);
        this.assertEquals(bExpected, this.jedis.zrevrangeByLex(this.bfoo, this.bLexPlusInf, this.bLexMinusInf, 0, 2));
    }

    @Test
    public void zrevrange() {
        this.jedis.zadd("foo", 1.0, "a");
        this.jedis.zadd("foo", 10.0, "b");
        this.jedis.zadd("foo", 0.1, "c");
        this.jedis.zadd("foo", 2.0, "a");
        LinkedHashSet<String> expected = new LinkedHashSet<String>();
        expected.add("b");
        expected.add("a");
        Set<String> range = this.jedis.zrevrange("foo", 0L, 1L);
        SortedSetCommandsTest.assertEquals(expected, range);
        expected.add("c");
        range = this.jedis.zrevrange("foo", 0L, 100L);
        SortedSetCommandsTest.assertEquals(expected, range);
        this.jedis.zadd(this.bfoo, 1.0, this.ba);
        this.jedis.zadd(this.bfoo, 10.0, this.bb);
        this.jedis.zadd(this.bfoo, 0.1, this.bc);
        this.jedis.zadd(this.bfoo, 2.0, this.ba);
        LinkedHashSet<byte[]> bexpected = new LinkedHashSet<byte[]>();
        bexpected.add(this.bb);
        bexpected.add(this.ba);
        Set<byte[]> brange = this.jedis.zrevrange(this.bfoo, 0L, 1L);
        this.assertEquals(bexpected, brange);
        bexpected.add(this.bc);
        brange = this.jedis.zrevrange(this.bfoo, 0L, 100L);
        this.assertEquals(bexpected, brange);
    }

    @Test
    public void zrem() {
        this.jedis.zadd("foo", 1.0, "a");
        this.jedis.zadd("foo", 2.0, "b");
        long status = this.jedis.zrem("foo", "a");
        LinkedHashSet<String> expected = new LinkedHashSet<String>();
        expected.add("b");
        SortedSetCommandsTest.assertEquals((long)1L, (long)status);
        SortedSetCommandsTest.assertEquals(expected, this.jedis.zrange("foo", 0L, 100L));
        status = this.jedis.zrem("foo", "bar");
        SortedSetCommandsTest.assertEquals((long)0L, (long)status);
        this.jedis.zadd(this.bfoo, 1.0, this.ba);
        this.jedis.zadd(this.bfoo, 2.0, this.bb);
        long bstatus = this.jedis.zrem(this.bfoo, new byte[][]{this.ba});
        LinkedHashSet<byte[]> bexpected = new LinkedHashSet<byte[]>();
        bexpected.add(this.bb);
        SortedSetCommandsTest.assertEquals((long)1L, (long)bstatus);
        this.assertEquals(bexpected, this.jedis.zrange(this.bfoo, 0L, 100L));
        bstatus = this.jedis.zrem(this.bfoo, new byte[][]{this.bbar});
        SortedSetCommandsTest.assertEquals((long)0L, (long)bstatus);
    }

    @Test
    public void zincrby() {
        this.jedis.zadd("foo", 1.0, "a");
        this.jedis.zadd("foo", 2.0, "b");
        double score = this.jedis.zincrby("foo", 2.0, "a");
        LinkedHashSet<String> expected = new LinkedHashSet<String>();
        expected.add("a");
        expected.add("b");
        SortedSetCommandsTest.assertEquals((double)3.0, (double)score, (double)0.0);
        SortedSetCommandsTest.assertEquals(expected, this.jedis.zrange("foo", 0L, 100L));
        this.jedis.zadd(this.bfoo, 1.0, this.ba);
        this.jedis.zadd(this.bfoo, 2.0, this.bb);
        double bscore = this.jedis.zincrby(this.bfoo, 2.0, this.ba);
        LinkedHashSet<byte[]> bexpected = new LinkedHashSet<byte[]>();
        bexpected.add(this.bb);
        bexpected.add(this.ba);
        SortedSetCommandsTest.assertEquals((double)3.0, (double)bscore, (double)0.0);
        this.assertEquals(bexpected, this.jedis.zrange(this.bfoo, 0L, 100L));
    }

    @Test
    public void zincrbyWithParams() {
        this.jedis.del("foo");
        Double score = this.jedis.zincrby("foo", 2.0, "a", ZIncrByParams.zIncrByParams().xx());
        SortedSetCommandsTest.assertNull((Object)score);
        this.jedis.zadd("foo", 2.0, "a");
        score = this.jedis.zincrby("foo", 1.0, "a", ZIncrByParams.zIncrByParams().nx());
        SortedSetCommandsTest.assertNull((Object)score);
        SortedSetCommandsTest.assertEquals((Object)2.0, (Object)this.jedis.zscore("foo", "a"));
        this.jedis.del(this.bfoo);
        score = this.jedis.zincrby(this.bfoo, 2.0, this.ba, ZIncrByParams.zIncrByParams().xx());
        SortedSetCommandsTest.assertNull((Object)score);
        this.jedis.zadd(this.bfoo, 2.0, this.ba);
        score = this.jedis.zincrby(this.bfoo, 1.0, this.ba, ZIncrByParams.zIncrByParams().nx());
        SortedSetCommandsTest.assertNull((Object)score);
        SortedSetCommandsTest.assertEquals((Object)2.0, (Object)this.jedis.zscore(this.bfoo, this.ba));
    }

    @Test
    public void zrank() {
        this.jedis.zadd("foo", 1.0, "a");
        this.jedis.zadd("foo", 2.0, "b");
        long rank = this.jedis.zrank("foo", "a");
        SortedSetCommandsTest.assertEquals((long)0L, (long)rank);
        rank = this.jedis.zrank("foo", "b");
        SortedSetCommandsTest.assertEquals((long)1L, (long)rank);
        SortedSetCommandsTest.assertNull((Object)this.jedis.zrank("car", "b"));
        this.jedis.zadd(this.bfoo, 1.0, this.ba);
        this.jedis.zadd(this.bfoo, 2.0, this.bb);
        long brank = this.jedis.zrank(this.bfoo, this.ba);
        SortedSetCommandsTest.assertEquals((long)0L, (long)brank);
        brank = this.jedis.zrank(this.bfoo, this.bb);
        SortedSetCommandsTest.assertEquals((long)1L, (long)brank);
        SortedSetCommandsTest.assertNull((Object)this.jedis.zrank(this.bcar, this.bb));
    }

    @Test
    public void zrevrank() {
        this.jedis.zadd("foo", 1.0, "a");
        this.jedis.zadd("foo", 2.0, "b");
        long rank = this.jedis.zrevrank("foo", "a");
        SortedSetCommandsTest.assertEquals((long)1L, (long)rank);
        rank = this.jedis.zrevrank("foo", "b");
        SortedSetCommandsTest.assertEquals((long)0L, (long)rank);
        this.jedis.zadd(this.bfoo, 1.0, this.ba);
        this.jedis.zadd(this.bfoo, 2.0, this.bb);
        long brank = this.jedis.zrevrank(this.bfoo, this.ba);
        SortedSetCommandsTest.assertEquals((long)1L, (long)brank);
        brank = this.jedis.zrevrank(this.bfoo, this.bb);
        SortedSetCommandsTest.assertEquals((long)0L, (long)brank);
    }

    @Test
    public void zrangeWithScores() {
        this.jedis.zadd("foo", 1.0, "a");
        this.jedis.zadd("foo", 10.0, "b");
        this.jedis.zadd("foo", 0.1, "c");
        this.jedis.zadd("foo", 2.0, "a");
        LinkedHashSet<Tuple> expected = new LinkedHashSet<Tuple>();
        expected.add(new Tuple("c", (Double)0.1));
        expected.add(new Tuple("a", (Double)2.0));
        Set<Tuple> range = this.jedis.zrangeWithScores("foo", 0L, 1L);
        SortedSetCommandsTest.assertEquals(expected, range);
        expected.add(new Tuple("b", (Double)10.0));
        range = this.jedis.zrangeWithScores("foo", 0L, 100L);
        SortedSetCommandsTest.assertEquals(expected, range);
        this.jedis.zadd(this.bfoo, 1.0, this.ba);
        this.jedis.zadd(this.bfoo, 10.0, this.bb);
        this.jedis.zadd(this.bfoo, 0.1, this.bc);
        this.jedis.zadd(this.bfoo, 2.0, this.ba);
        LinkedHashSet<Tuple> bexpected = new LinkedHashSet<Tuple>();
        bexpected.add(new Tuple(this.bc, (Double)0.1));
        bexpected.add(new Tuple(this.ba, (Double)2.0));
        Set<Tuple> brange = this.jedis.zrangeWithScores(this.bfoo, 0L, 1L);
        SortedSetCommandsTest.assertEquals(bexpected, brange);
        bexpected.add(new Tuple(this.bb, (Double)10.0));
        brange = this.jedis.zrangeWithScores(this.bfoo, 0L, 100L);
        SortedSetCommandsTest.assertEquals(bexpected, brange);
    }

    @Test
    public void zrevrangeWithScores() {
        this.jedis.zadd("foo", 1.0, "a");
        this.jedis.zadd("foo", 10.0, "b");
        this.jedis.zadd("foo", 0.1, "c");
        this.jedis.zadd("foo", 2.0, "a");
        LinkedHashSet<Tuple> expected = new LinkedHashSet<Tuple>();
        expected.add(new Tuple("b", (Double)10.0));
        expected.add(new Tuple("a", (Double)2.0));
        Set<Tuple> range = this.jedis.zrevrangeWithScores("foo", 0L, 1L);
        SortedSetCommandsTest.assertEquals(expected, range);
        expected.add(new Tuple("c", (Double)0.1));
        range = this.jedis.zrevrangeWithScores("foo", 0L, 100L);
        SortedSetCommandsTest.assertEquals(expected, range);
        this.jedis.zadd(this.bfoo, 1.0, this.ba);
        this.jedis.zadd(this.bfoo, 10.0, this.bb);
        this.jedis.zadd(this.bfoo, 0.1, this.bc);
        this.jedis.zadd(this.bfoo, 2.0, this.ba);
        LinkedHashSet<Tuple> bexpected = new LinkedHashSet<Tuple>();
        bexpected.add(new Tuple(this.bb, (Double)10.0));
        bexpected.add(new Tuple(this.ba, (Double)2.0));
        Set<Tuple> brange = this.jedis.zrevrangeWithScores(this.bfoo, 0L, 1L);
        SortedSetCommandsTest.assertEquals(bexpected, brange);
        bexpected.add(new Tuple(this.bc, (Double)0.1));
        brange = this.jedis.zrevrangeWithScores(this.bfoo, 0L, 100L);
        SortedSetCommandsTest.assertEquals(bexpected, brange);
    }

    @Test
    public void zcard() {
        this.jedis.zadd("foo", 1.0, "a");
        this.jedis.zadd("foo", 10.0, "b");
        this.jedis.zadd("foo", 0.1, "c");
        this.jedis.zadd("foo", 2.0, "a");
        long size = this.jedis.zcard("foo");
        SortedSetCommandsTest.assertEquals((long)3L, (long)size);
        this.jedis.zadd(this.bfoo, 1.0, this.ba);
        this.jedis.zadd(this.bfoo, 10.0, this.bb);
        this.jedis.zadd(this.bfoo, 0.1, this.bc);
        this.jedis.zadd(this.bfoo, 2.0, this.ba);
        long bsize = this.jedis.zcard(this.bfoo);
        SortedSetCommandsTest.assertEquals((long)3L, (long)bsize);
    }

    @Test
    public void zscore() {
        this.jedis.zadd("foo", 1.0, "a");
        this.jedis.zadd("foo", 10.0, "b");
        this.jedis.zadd("foo", 0.1, "c");
        this.jedis.zadd("foo", 2.0, "a");
        Double score = this.jedis.zscore("foo", "b");
        SortedSetCommandsTest.assertEquals((Object)10.0, (Object)score);
        score = this.jedis.zscore("foo", "c");
        SortedSetCommandsTest.assertEquals((Object)0.1, (Object)score);
        score = this.jedis.zscore("foo", "s");
        SortedSetCommandsTest.assertNull((Object)score);
        this.jedis.zadd(this.bfoo, 1.0, this.ba);
        this.jedis.zadd(this.bfoo, 10.0, this.bb);
        this.jedis.zadd(this.bfoo, 0.1, this.bc);
        this.jedis.zadd(this.bfoo, 2.0, this.ba);
        Double bscore = this.jedis.zscore(this.bfoo, this.bb);
        SortedSetCommandsTest.assertEquals((Object)10.0, (Object)bscore);
        bscore = this.jedis.zscore(this.bfoo, this.bc);
        SortedSetCommandsTest.assertEquals((Object)0.1, (Object)bscore);
        bscore = this.jedis.zscore(this.bfoo, SafeEncoder.encode("s"));
        SortedSetCommandsTest.assertNull((Object)bscore);
    }

    @Test
    public void zcount() {
        this.jedis.zadd("foo", 1.0, "a");
        this.jedis.zadd("foo", 10.0, "b");
        this.jedis.zadd("foo", 0.1, "c");
        this.jedis.zadd("foo", 2.0, "a");
        long result = this.jedis.zcount("foo", 0.01, 2.1);
        SortedSetCommandsTest.assertEquals((long)2L, (long)result);
        result = this.jedis.zcount("foo", "(0.01", "+inf");
        SortedSetCommandsTest.assertEquals((long)3L, (long)result);
        this.jedis.zadd(this.bfoo, 1.0, this.ba);
        this.jedis.zadd(this.bfoo, 10.0, this.bb);
        this.jedis.zadd(this.bfoo, 0.1, this.bc);
        this.jedis.zadd(this.bfoo, 2.0, this.ba);
        long bresult = this.jedis.zcount(this.bfoo, 0.01, 2.1);
        SortedSetCommandsTest.assertEquals((long)2L, (long)bresult);
        bresult = this.jedis.zcount(this.bfoo, SafeEncoder.encode("(0.01"), SafeEncoder.encode("+inf"));
        SortedSetCommandsTest.assertEquals((long)3L, (long)bresult);
    }

    @Test
    public void zlexcount() {
        this.jedis.zadd("foo", 1.0, "a");
        this.jedis.zadd("foo", 1.0, "b");
        this.jedis.zadd("foo", 1.0, "c");
        this.jedis.zadd("foo", 1.0, "aa");
        long result = this.jedis.zlexcount("foo", "[aa", "(c");
        SortedSetCommandsTest.assertEquals((long)2L, (long)result);
        result = this.jedis.zlexcount("foo", "-", "+");
        SortedSetCommandsTest.assertEquals((long)4L, (long)result);
        result = this.jedis.zlexcount("foo", "-", "(c");
        SortedSetCommandsTest.assertEquals((long)3L, (long)result);
        result = this.jedis.zlexcount("foo", "[aa", "+");
        SortedSetCommandsTest.assertEquals((long)3L, (long)result);
    }

    @Test
    public void zlexcountBinary() {
        this.jedis.zadd(this.bfoo, 1.0, this.ba);
        this.jedis.zadd(this.bfoo, 1.0, this.bc);
        this.jedis.zadd(this.bfoo, 1.0, this.bb);
        long result = this.jedis.zlexcount(this.bfoo, this.bInclusiveB, this.bExclusiveC);
        SortedSetCommandsTest.assertEquals((long)1L, (long)result);
        result = this.jedis.zlexcount(this.bfoo, this.bLexMinusInf, this.bLexPlusInf);
        SortedSetCommandsTest.assertEquals((long)3L, (long)result);
    }

    @Test
    public void zrangebyscore() {
        this.jedis.zadd("foo", 1.0, "a");
        this.jedis.zadd("foo", 10.0, "b");
        this.jedis.zadd("foo", 0.1, "c");
        this.jedis.zadd("foo", 2.0, "a");
        Set<String> range = this.jedis.zrangeByScore("foo", 0.0, 2.0);
        LinkedHashSet<String> expected = new LinkedHashSet<String>();
        expected.add("c");
        expected.add("a");
        SortedSetCommandsTest.assertEquals(expected, range);
        range = this.jedis.zrangeByScore("foo", 0.0, 2.0, 0, 1);
        expected = new LinkedHashSet();
        expected.add("c");
        SortedSetCommandsTest.assertEquals(expected, range);
        range = this.jedis.zrangeByScore("foo", 0.0, 2.0, 1, 1);
        Set<String> range2 = this.jedis.zrangeByScore("foo", "-inf", "(2");
        SortedSetCommandsTest.assertEquals(expected, range2);
        expected = new LinkedHashSet();
        expected.add("a");
        SortedSetCommandsTest.assertEquals(expected, range);
        this.jedis.zadd(this.bfoo, 1.0, this.ba);
        this.jedis.zadd(this.bfoo, 10.0, this.bb);
        this.jedis.zadd(this.bfoo, 0.1, this.bc);
        this.jedis.zadd(this.bfoo, 2.0, this.ba);
        Set<byte[]> brange = this.jedis.zrangeByScore(this.bfoo, 0.0, 2.0);
        LinkedHashSet<Object> bexpected = new LinkedHashSet<byte[]>();
        bexpected.add(this.bc);
        bexpected.add(this.ba);
        this.assertEquals(bexpected, brange);
        brange = this.jedis.zrangeByScore(this.bfoo, 0.0, 2.0, 0, 1);
        bexpected = new LinkedHashSet();
        bexpected.add(this.bc);
        this.assertEquals(bexpected, brange);
        brange = this.jedis.zrangeByScore(this.bfoo, 0.0, 2.0, 1, 1);
        Set<byte[]> brange2 = this.jedis.zrangeByScore(this.bfoo, SafeEncoder.encode("-inf"), SafeEncoder.encode("(2"));
        this.assertEquals(bexpected, brange2);
        bexpected = new LinkedHashSet();
        bexpected.add(this.ba);
        this.assertEquals(bexpected, brange);
    }

    @Test
    public void zrevrangebyscore() {
        this.jedis.zadd("foo", 1.0, "a");
        this.jedis.zadd("foo", 2.0, "b");
        this.jedis.zadd("foo", 3.0, "c");
        this.jedis.zadd("foo", 4.0, "d");
        this.jedis.zadd("foo", 5.0, "e");
        Set<String> range = this.jedis.zrevrangeByScore("foo", 3.0, Double.NEGATIVE_INFINITY, 0, 1);
        LinkedHashSet<String> expected = new LinkedHashSet<String>();
        expected.add("c");
        SortedSetCommandsTest.assertEquals(expected, range);
        range = this.jedis.zrevrangeByScore("foo", 3.5, Double.NEGATIVE_INFINITY, 0, 2);
        expected = new LinkedHashSet();
        expected.add("c");
        expected.add("b");
        SortedSetCommandsTest.assertEquals(expected, range);
        range = this.jedis.zrevrangeByScore("foo", 3.5, Double.NEGATIVE_INFINITY, 1, 1);
        expected = new LinkedHashSet();
        expected.add("b");
        SortedSetCommandsTest.assertEquals(expected, range);
        range = this.jedis.zrevrangeByScore("foo", 4.0, 2.0);
        expected = new LinkedHashSet();
        expected.add("d");
        expected.add("c");
        expected.add("b");
        SortedSetCommandsTest.assertEquals(expected, range);
        range = this.jedis.zrevrangeByScore("foo", "+inf", "(4");
        expected = new LinkedHashSet();
        expected.add("e");
        SortedSetCommandsTest.assertEquals(expected, range);
        this.jedis.zadd(this.bfoo, 1.0, this.ba);
        this.jedis.zadd(this.bfoo, 10.0, this.bb);
        this.jedis.zadd(this.bfoo, 0.1, this.bc);
        this.jedis.zadd(this.bfoo, 2.0, this.ba);
        Set<byte[]> brange = this.jedis.zrevrangeByScore(this.bfoo, 2.0, 0.0);
        LinkedHashSet<Object> bexpected = new LinkedHashSet<byte[]>();
        bexpected.add(this.bc);
        bexpected.add(this.ba);
        this.assertEquals(bexpected, brange);
        brange = this.jedis.zrevrangeByScore(this.bfoo, 2.0, 0.0, 0, 1);
        bexpected = new LinkedHashSet();
        bexpected.add(this.ba);
        this.assertEquals(bexpected, brange);
        Set<byte[]> brange2 = this.jedis.zrevrangeByScore(this.bfoo, SafeEncoder.encode("+inf"), SafeEncoder.encode("(2"));
        bexpected = new LinkedHashSet();
        bexpected.add(this.bb);
        this.assertEquals(bexpected, brange2);
        brange = this.jedis.zrevrangeByScore(this.bfoo, 2.0, 0.0, 1, 1);
        bexpected = new LinkedHashSet();
        bexpected.add(this.bc);
        this.assertEquals(bexpected, brange);
    }

    @Test
    public void zrangebyscoreWithScores() {
        this.jedis.zadd("foo", 1.0, "a");
        this.jedis.zadd("foo", 10.0, "b");
        this.jedis.zadd("foo", 0.1, "c");
        this.jedis.zadd("foo", 2.0, "a");
        Set<Tuple> range = this.jedis.zrangeByScoreWithScores("foo", 0.0, 2.0);
        LinkedHashSet<Tuple> expected = new LinkedHashSet<Tuple>();
        expected.add(new Tuple("c", (Double)0.1));
        expected.add(new Tuple("a", (Double)2.0));
        SortedSetCommandsTest.assertEquals(expected, range);
        range = this.jedis.zrangeByScoreWithScores("foo", 0.0, 2.0, 0, 1);
        expected = new LinkedHashSet();
        expected.add(new Tuple("c", (Double)0.1));
        SortedSetCommandsTest.assertEquals(expected, range);
        range = this.jedis.zrangeByScoreWithScores("foo", 0.0, 2.0, 1, 1);
        expected = new LinkedHashSet();
        expected.add(new Tuple("a", (Double)2.0));
        SortedSetCommandsTest.assertEquals(expected, range);
        this.jedis.zadd(this.bfoo, 1.0, this.ba);
        this.jedis.zadd(this.bfoo, 10.0, this.bb);
        this.jedis.zadd(this.bfoo, 0.1, this.bc);
        this.jedis.zadd(this.bfoo, 2.0, this.ba);
        Set<Tuple> brange = this.jedis.zrangeByScoreWithScores(this.bfoo, 0.0, 2.0);
        LinkedHashSet<Tuple> bexpected = new LinkedHashSet<Tuple>();
        bexpected.add(new Tuple(this.bc, (Double)0.1));
        bexpected.add(new Tuple(this.ba, (Double)2.0));
        SortedSetCommandsTest.assertEquals(bexpected, brange);
        brange = this.jedis.zrangeByScoreWithScores(this.bfoo, 0.0, 2.0, 0, 1);
        bexpected = new LinkedHashSet();
        bexpected.add(new Tuple(this.bc, (Double)0.1));
        SortedSetCommandsTest.assertEquals(bexpected, brange);
        brange = this.jedis.zrangeByScoreWithScores(this.bfoo, 0.0, 2.0, 1, 1);
        bexpected = new LinkedHashSet();
        bexpected.add(new Tuple(this.ba, (Double)2.0));
        SortedSetCommandsTest.assertEquals(bexpected, brange);
    }

    @Test
    public void zrevrangebyscoreWithScores() {
        this.jedis.zadd("foo", 1.0, "a");
        this.jedis.zadd("foo", 2.0, "b");
        this.jedis.zadd("foo", 3.0, "c");
        this.jedis.zadd("foo", 4.0, "d");
        this.jedis.zadd("foo", 5.0, "e");
        Set<Tuple> range = this.jedis.zrevrangeByScoreWithScores("foo", 3.0, Double.NEGATIVE_INFINITY, 0, 1);
        LinkedHashSet<Tuple> expected = new LinkedHashSet<Tuple>();
        expected.add(new Tuple("c", (Double)3.0));
        SortedSetCommandsTest.assertEquals(expected, range);
        range = this.jedis.zrevrangeByScoreWithScores("foo", 3.5, Double.NEGATIVE_INFINITY, 0, 2);
        expected = new LinkedHashSet();
        expected.add(new Tuple("c", (Double)3.0));
        expected.add(new Tuple("b", (Double)2.0));
        SortedSetCommandsTest.assertEquals(expected, range);
        range = this.jedis.zrevrangeByScoreWithScores("foo", 3.5, Double.NEGATIVE_INFINITY, 1, 1);
        expected = new LinkedHashSet();
        expected.add(new Tuple("b", (Double)2.0));
        SortedSetCommandsTest.assertEquals(expected, range);
        range = this.jedis.zrevrangeByScoreWithScores("foo", 4.0, 2.0);
        expected = new LinkedHashSet();
        expected.add(new Tuple("d", (Double)4.0));
        expected.add(new Tuple("c", (Double)3.0));
        expected.add(new Tuple("b", (Double)2.0));
        SortedSetCommandsTest.assertEquals(expected, range);
        this.jedis.zadd(this.bfoo, 1.0, this.ba);
        this.jedis.zadd(this.bfoo, 10.0, this.bb);
        this.jedis.zadd(this.bfoo, 0.1, this.bc);
        this.jedis.zadd(this.bfoo, 2.0, this.ba);
        Set<Tuple> brange = this.jedis.zrevrangeByScoreWithScores(this.bfoo, 2.0, 0.0);
        LinkedHashSet<Tuple> bexpected = new LinkedHashSet<Tuple>();
        bexpected.add(new Tuple(this.bc, (Double)0.1));
        bexpected.add(new Tuple(this.ba, (Double)2.0));
        SortedSetCommandsTest.assertEquals(bexpected, brange);
        brange = this.jedis.zrevrangeByScoreWithScores(this.bfoo, 2.0, 0.0, 0, 1);
        bexpected = new LinkedHashSet();
        bexpected.add(new Tuple(this.ba, (Double)2.0));
        SortedSetCommandsTest.assertEquals(bexpected, brange);
        brange = this.jedis.zrevrangeByScoreWithScores(this.bfoo, 2.0, 0.0, 1, 1);
        bexpected = new LinkedHashSet();
        bexpected.add(new Tuple(this.bc, (Double)0.1));
        SortedSetCommandsTest.assertEquals(bexpected, brange);
    }

    @Test
    public void zremrangeByRank() {
        this.jedis.zadd("foo", 1.0, "a");
        this.jedis.zadd("foo", 10.0, "b");
        this.jedis.zadd("foo", 0.1, "c");
        this.jedis.zadd("foo", 2.0, "a");
        long result = this.jedis.zremrangeByRank("foo", 0L, 0L);
        SortedSetCommandsTest.assertEquals((long)1L, (long)result);
        LinkedHashSet<String> expected = new LinkedHashSet<String>();
        expected.add("a");
        expected.add("b");
        SortedSetCommandsTest.assertEquals(expected, this.jedis.zrange("foo", 0L, 100L));
        this.jedis.zadd(this.bfoo, 1.0, this.ba);
        this.jedis.zadd(this.bfoo, 10.0, this.bb);
        this.jedis.zadd(this.bfoo, 0.1, this.bc);
        this.jedis.zadd(this.bfoo, 2.0, this.ba);
        long bresult = this.jedis.zremrangeByRank(this.bfoo, 0L, 0L);
        SortedSetCommandsTest.assertEquals((long)1L, (long)bresult);
        LinkedHashSet<byte[]> bexpected = new LinkedHashSet<byte[]>();
        bexpected.add(this.ba);
        bexpected.add(this.bb);
        this.assertEquals(bexpected, this.jedis.zrange(this.bfoo, 0L, 100L));
    }

    @Test
    public void zremrangeByScore() {
        this.jedis.zadd("foo", 1.0, "a");
        this.jedis.zadd("foo", 10.0, "b");
        this.jedis.zadd("foo", 0.1, "c");
        this.jedis.zadd("foo", 2.0, "a");
        long result = this.jedis.zremrangeByScore("foo", 0.0, 2.0);
        SortedSetCommandsTest.assertEquals((long)2L, (long)result);
        LinkedHashSet<String> expected = new LinkedHashSet<String>();
        expected.add("b");
        SortedSetCommandsTest.assertEquals(expected, this.jedis.zrange("foo", 0L, 100L));
        this.jedis.zadd(this.bfoo, 1.0, this.ba);
        this.jedis.zadd(this.bfoo, 10.0, this.bb);
        this.jedis.zadd(this.bfoo, 0.1, this.bc);
        this.jedis.zadd(this.bfoo, 2.0, this.ba);
        long bresult = this.jedis.zremrangeByScore(this.bfoo, 0.0, 2.0);
        SortedSetCommandsTest.assertEquals((long)2L, (long)bresult);
        LinkedHashSet<byte[]> bexpected = new LinkedHashSet<byte[]>();
        bexpected.add(this.bb);
        this.assertEquals(bexpected, this.jedis.zrange(this.bfoo, 0L, 100L));
    }

    @Test
    public void zremrangeByLex() {
        this.jedis.zadd("foo", 1.0, "a");
        this.jedis.zadd("foo", 1.0, "b");
        this.jedis.zadd("foo", 1.0, "c");
        this.jedis.zadd("foo", 1.0, "aa");
        long result = this.jedis.zremrangeByLex("foo", "[aa", "(c");
        SortedSetCommandsTest.assertEquals((long)2L, (long)result);
        LinkedHashSet<String> expected = new LinkedHashSet<String>();
        expected.add("a");
        expected.add("c");
        SortedSetCommandsTest.assertEquals(expected, this.jedis.zrangeByLex("foo", "-", "+"));
    }

    @Test
    public void zremrangeByLexBinary() {
        this.jedis.zadd(this.bfoo, 1.0, this.ba);
        this.jedis.zadd(this.bfoo, 1.0, this.bc);
        this.jedis.zadd(this.bfoo, 1.0, this.bb);
        long bresult = this.jedis.zremrangeByLex(this.bfoo, this.bInclusiveB, this.bExclusiveC);
        SortedSetCommandsTest.assertEquals((long)1L, (long)bresult);
        LinkedHashSet<byte[]> bexpected = new LinkedHashSet<byte[]>();
        bexpected.add(this.ba);
        bexpected.add(this.bc);
        this.assertEquals(bexpected, this.jedis.zrangeByLex(this.bfoo, this.bLexMinusInf, this.bLexPlusInf));
    }

    @Test
    public void zunionstore() {
        this.jedis.zadd("foo", 1.0, "a");
        this.jedis.zadd("foo", 2.0, "b");
        this.jedis.zadd("bar", 2.0, "a");
        this.jedis.zadd("bar", 2.0, "b");
        long result = this.jedis.zunionstore("dst", "foo", "bar");
        SortedSetCommandsTest.assertEquals((long)2L, (long)result);
        LinkedHashSet<Tuple> expected = new LinkedHashSet<Tuple>();
        expected.add(new Tuple("b", new Double(4.0)));
        expected.add(new Tuple("a", new Double(3.0)));
        SortedSetCommandsTest.assertEquals(expected, this.jedis.zrangeWithScores("dst", 0L, 100L));
        this.jedis.zadd(this.bfoo, 1.0, this.ba);
        this.jedis.zadd(this.bfoo, 2.0, this.bb);
        this.jedis.zadd(this.bbar, 2.0, this.ba);
        this.jedis.zadd(this.bbar, 2.0, this.bb);
        long bresult = this.jedis.zunionstore(SafeEncoder.encode("dst"), this.bfoo, this.bbar);
        SortedSetCommandsTest.assertEquals((long)2L, (long)bresult);
        LinkedHashSet<Tuple> bexpected = new LinkedHashSet<Tuple>();
        bexpected.add(new Tuple(this.bb, new Double(4.0)));
        bexpected.add(new Tuple(this.ba, new Double(3.0)));
        SortedSetCommandsTest.assertEquals(bexpected, this.jedis.zrangeWithScores(SafeEncoder.encode("dst"), 0L, 100L));
    }

    @Test
    public void zunionstoreParams() {
        this.jedis.zadd("foo", 1.0, "a");
        this.jedis.zadd("foo", 2.0, "b");
        this.jedis.zadd("bar", 2.0, "a");
        this.jedis.zadd("bar", 2.0, "b");
        ZParams params = new ZParams();
        params.weightsByDouble(2.0, 2.5);
        params.aggregate(ZParams.Aggregate.SUM);
        long result = this.jedis.zunionstore("dst", params, "foo", "bar");
        SortedSetCommandsTest.assertEquals((long)2L, (long)result);
        LinkedHashSet<Tuple> expected = new LinkedHashSet<Tuple>();
        expected.add(new Tuple("b", new Double(9.0)));
        expected.add(new Tuple("a", new Double(7.0)));
        SortedSetCommandsTest.assertEquals(expected, this.jedis.zrangeWithScores("dst", 0L, 100L));
        this.jedis.zadd(this.bfoo, 1.0, this.ba);
        this.jedis.zadd(this.bfoo, 2.0, this.bb);
        this.jedis.zadd(this.bbar, 2.0, this.ba);
        this.jedis.zadd(this.bbar, 2.0, this.bb);
        ZParams bparams = new ZParams();
        bparams.weightsByDouble(2.0, 2.5);
        bparams.aggregate(ZParams.Aggregate.SUM);
        long bresult = this.jedis.zunionstore(SafeEncoder.encode("dst"), bparams, (byte[][])new byte[][]{this.bfoo, this.bbar});
        SortedSetCommandsTest.assertEquals((long)2L, (long)bresult);
        LinkedHashSet<Tuple> bexpected = new LinkedHashSet<Tuple>();
        bexpected.add(new Tuple(this.bb, new Double(9.0)));
        bexpected.add(new Tuple(this.ba, new Double(7.0)));
        SortedSetCommandsTest.assertEquals(bexpected, this.jedis.zrangeWithScores(SafeEncoder.encode("dst"), 0L, 100L));
    }

    @Test
    public void zinterstore() {
        this.jedis.zadd("foo", 1.0, "a");
        this.jedis.zadd("foo", 2.0, "b");
        this.jedis.zadd("bar", 2.0, "a");
        long result = this.jedis.zinterstore("dst", "foo", "bar");
        SortedSetCommandsTest.assertEquals((long)1L, (long)result);
        LinkedHashSet<Tuple> expected = new LinkedHashSet<Tuple>();
        expected.add(new Tuple("a", new Double(3.0)));
        SortedSetCommandsTest.assertEquals(expected, this.jedis.zrangeWithScores("dst", 0L, 100L));
        this.jedis.zadd(this.bfoo, 1.0, this.ba);
        this.jedis.zadd(this.bfoo, 2.0, this.bb);
        this.jedis.zadd(this.bbar, 2.0, this.ba);
        long bresult = this.jedis.zinterstore(SafeEncoder.encode("dst"), this.bfoo, this.bbar);
        SortedSetCommandsTest.assertEquals((long)1L, (long)bresult);
        LinkedHashSet<Tuple> bexpected = new LinkedHashSet<Tuple>();
        bexpected.add(new Tuple(this.ba, new Double(3.0)));
        SortedSetCommandsTest.assertEquals(bexpected, this.jedis.zrangeWithScores(SafeEncoder.encode("dst"), 0L, 100L));
    }

    @Test
    public void zintertoreParams() {
        this.jedis.zadd("foo", 1.0, "a");
        this.jedis.zadd("foo", 2.0, "b");
        this.jedis.zadd("bar", 2.0, "a");
        ZParams params = new ZParams();
        params.weightsByDouble(2.0, 2.5);
        params.aggregate(ZParams.Aggregate.SUM);
        long result = this.jedis.zinterstore("dst", params, "foo", "bar");
        SortedSetCommandsTest.assertEquals((long)1L, (long)result);
        LinkedHashSet<Tuple> expected = new LinkedHashSet<Tuple>();
        expected.add(new Tuple("a", new Double(7.0)));
        SortedSetCommandsTest.assertEquals(expected, this.jedis.zrangeWithScores("dst", 0L, 100L));
        this.jedis.zadd(this.bfoo, 1.0, this.ba);
        this.jedis.zadd(this.bfoo, 2.0, this.bb);
        this.jedis.zadd(this.bbar, 2.0, this.ba);
        ZParams bparams = new ZParams();
        bparams.weightsByDouble(2.0, 2.5);
        bparams.aggregate(ZParams.Aggregate.SUM);
        long bresult = this.jedis.zinterstore(SafeEncoder.encode("dst"), bparams, (byte[][])new byte[][]{this.bfoo, this.bbar});
        SortedSetCommandsTest.assertEquals((long)1L, (long)bresult);
        LinkedHashSet<Tuple> bexpected = new LinkedHashSet<Tuple>();
        bexpected.add(new Tuple(this.ba, new Double(7.0)));
        SortedSetCommandsTest.assertEquals(bexpected, this.jedis.zrangeWithScores(SafeEncoder.encode("dst"), 0L, 100L));
    }

    @Test
    public void tupleCompare() {
        Tuple t1 = new Tuple("foo", (Double)1.0);
        Tuple t2 = new Tuple("bar", (Double)2.0);
        SortedSetCommandsTest.assertEquals((long)-1L, (long)t1.compareTo(t2));
        SortedSetCommandsTest.assertEquals((long)1L, (long)t2.compareTo(t1));
        SortedSetCommandsTest.assertEquals((long)0L, (long)t2.compareTo(t2));
    }

    @Test
    public void zscan() {
        this.jedis.zadd("foo", 1.0, "a");
        this.jedis.zadd("foo", 2.0, "b");
        ScanResult<Tuple> result = this.jedis.zscan("foo", ScanParams.SCAN_POINTER_START);
        SortedSetCommandsTest.assertEquals((Object)ScanParams.SCAN_POINTER_START, (Object)result.getStringCursor());
        SortedSetCommandsTest.assertFalse((boolean)result.getResult().isEmpty());
        this.jedis.zadd(this.bfoo, 1.0, this.ba);
        this.jedis.zadd(this.bfoo, 1.0, this.bb);
        ScanResult<Tuple> bResult = this.jedis.zscan(this.bfoo, ScanParams.SCAN_POINTER_START_BINARY);
        SortedSetCommandsTest.assertArrayEquals((byte[])ScanParams.SCAN_POINTER_START_BINARY, (byte[])bResult.getCursorAsBytes());
        SortedSetCommandsTest.assertFalse((boolean)bResult.getResult().isEmpty());
    }

    @Test
    public void zscanMatch() {
        ScanParams params = new ScanParams();
        params.match("a*");
        this.jedis.zadd("foo", 2.0, "b");
        this.jedis.zadd("foo", 1.0, "a");
        this.jedis.zadd("foo", 11.0, "aa");
        ScanResult<Tuple> result = this.jedis.zscan("foo", ScanParams.SCAN_POINTER_START, params);
        SortedSetCommandsTest.assertEquals((Object)ScanParams.SCAN_POINTER_START, (Object)result.getStringCursor());
        SortedSetCommandsTest.assertFalse((boolean)result.getResult().isEmpty());
        params = new ScanParams();
        params.match(this.bbarstar);
        this.jedis.zadd(this.bfoo, 2.0, this.bbar1);
        this.jedis.zadd(this.bfoo, 1.0, this.bbar2);
        this.jedis.zadd(this.bfoo, 11.0, this.bbar3);
        ScanResult<Tuple> bResult = this.jedis.zscan(this.bfoo, ScanParams.SCAN_POINTER_START_BINARY, params);
        SortedSetCommandsTest.assertArrayEquals((byte[])ScanParams.SCAN_POINTER_START_BINARY, (byte[])bResult.getCursorAsBytes());
        SortedSetCommandsTest.assertFalse((boolean)bResult.getResult().isEmpty());
    }

    @Test
    public void zscanCount() {
        ScanParams params = new ScanParams();
        params.count(2);
        this.jedis.zadd("foo", 1.0, "a1");
        this.jedis.zadd("foo", 2.0, "a2");
        this.jedis.zadd("foo", 3.0, "a3");
        this.jedis.zadd("foo", 4.0, "a4");
        this.jedis.zadd("foo", 5.0, "a5");
        ScanResult<Tuple> result = this.jedis.zscan("foo", ScanParams.SCAN_POINTER_START, params);
        SortedSetCommandsTest.assertFalse((boolean)result.getResult().isEmpty());
        params = new ScanParams();
        params.count(2);
        this.jedis.zadd(this.bfoo, 2.0, this.bbar1);
        this.jedis.zadd(this.bfoo, 1.0, this.bbar2);
        this.jedis.zadd(this.bfoo, 11.0, this.bbar3);
        ScanResult<Tuple> bResult = this.jedis.zscan(this.bfoo, ScanParams.SCAN_POINTER_START_BINARY, params);
        SortedSetCommandsTest.assertFalse((boolean)bResult.getResult().isEmpty());
    }
}

