/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.commands;

import java.util.List;
import org.junit.Test;
import redis.clients.jedis.tests.commands.JedisCommandTestBase;
import redis.clients.util.Slowlog;

public class SlowlogCommandsTest
extends JedisCommandTestBase {
    @Test
    public void slowlog() {
        this.jedis.configSet("slowlog-log-slower-than", "0");
        this.jedis.set("foo", "bar");
        this.jedis.set("foo2", "bar2");
        List<Slowlog> reducedLog = this.jedis.slowlogGet(1L);
        SlowlogCommandsTest.assertEquals((long)1L, (long)reducedLog.size());
        Slowlog log = reducedLog.get(0);
        SlowlogCommandsTest.assertTrue((log.getId() > 0L ? 1 : 0) != 0);
        SlowlogCommandsTest.assertTrue((log.getTimeStamp() > 0L ? 1 : 0) != 0);
        SlowlogCommandsTest.assertTrue((log.getExecutionTime() > 0L ? 1 : 0) != 0);
        SlowlogCommandsTest.assertNotNull(log.getArgs());
        List<byte[]> breducedLog = this.jedis.slowlogGetBinary(1L);
        SlowlogCommandsTest.assertEquals((long)1L, (long)breducedLog.size());
        List<Slowlog> log1 = this.jedis.slowlogGet();
        List<byte[]> blog1 = this.jedis.slowlogGetBinary();
        SlowlogCommandsTest.assertNotNull(log1);
        SlowlogCommandsTest.assertNotNull(blog1);
        long len1 = this.jedis.slowlogLen();
        this.jedis.slowlogReset();
        List<Slowlog> log2 = this.jedis.slowlogGet();
        List<byte[]> blog2 = this.jedis.slowlogGetBinary();
        long len2 = this.jedis.slowlogLen();
        SlowlogCommandsTest.assertTrue((len1 > len2 ? 1 : 0) != 0);
        SlowlogCommandsTest.assertTrue((log1.size() > log2.size() ? 1 : 0) != 0);
        SlowlogCommandsTest.assertTrue((blog1.size() > blog2.size() ? 1 : 0) != 0);
    }
}

