/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.commands;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.Test;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.tests.commands.JedisCommandTestBase;

public class SetCommandsTest
extends JedisCommandTestBase {
    final byte[] bfoo = new byte[]{1, 2, 3, 4};
    final byte[] bbar = new byte[]{5, 6, 7, 8};
    final byte[] bcar = new byte[]{9, 10, 11, 12};
    final byte[] ba = new byte[]{10};
    final byte[] bb = new byte[]{11};
    final byte[] bc = new byte[]{12};
    final byte[] bd = new byte[]{13};
    final byte[] bx = new byte[]{66};
    final byte[] bbar1 = new byte[]{5, 6, 7, 8, 10};
    final byte[] bbar2 = new byte[]{5, 6, 7, 8, 11};
    final byte[] bbar3 = new byte[]{5, 6, 7, 8, 12};
    final byte[] bbarstar = new byte[]{5, 6, 7, 8, 42};

    @Test
    public void sadd() {
        long status = this.jedis.sadd("foo", "a");
        SetCommandsTest.assertEquals((long)1L, (long)status);
        status = this.jedis.sadd("foo", "a");
        SetCommandsTest.assertEquals((long)0L, (long)status);
        long bstatus = this.jedis.sadd(this.bfoo, new byte[][]{this.ba});
        SetCommandsTest.assertEquals((long)1L, (long)bstatus);
        bstatus = this.jedis.sadd(this.bfoo, new byte[][]{this.ba});
        SetCommandsTest.assertEquals((long)0L, (long)bstatus);
    }

    @Test
    public void smembers() {
        this.jedis.sadd("foo", "a");
        this.jedis.sadd("foo", "b");
        HashSet<String> expected = new HashSet<String>();
        expected.add("a");
        expected.add("b");
        Set<String> members = this.jedis.smembers("foo");
        SetCommandsTest.assertEquals(expected, members);
        this.jedis.sadd(this.bfoo, new byte[][]{this.ba});
        this.jedis.sadd(this.bfoo, new byte[][]{this.bb});
        HashSet<byte[]> bexpected = new HashSet<byte[]>();
        bexpected.add(this.bb);
        bexpected.add(this.ba);
        Set<byte[]> bmembers = this.jedis.smembers(this.bfoo);
        this.assertEquals(bexpected, bmembers);
    }

    @Test
    public void srem() {
        this.jedis.sadd("foo", "a");
        this.jedis.sadd("foo", "b");
        long status = this.jedis.srem("foo", "a");
        HashSet<String> expected = new HashSet<String>();
        expected.add("b");
        SetCommandsTest.assertEquals((long)1L, (long)status);
        SetCommandsTest.assertEquals(expected, this.jedis.smembers("foo"));
        status = this.jedis.srem("foo", "bar");
        SetCommandsTest.assertEquals((long)0L, (long)status);
        this.jedis.sadd(this.bfoo, new byte[][]{this.ba});
        this.jedis.sadd(this.bfoo, new byte[][]{this.bb});
        long bstatus = this.jedis.srem(this.bfoo, new byte[][]{this.ba});
        HashSet<byte[]> bexpected = new HashSet<byte[]>();
        bexpected.add(this.bb);
        SetCommandsTest.assertEquals((long)1L, (long)bstatus);
        this.assertEquals(bexpected, this.jedis.smembers(this.bfoo));
        bstatus = this.jedis.srem(this.bfoo, new byte[][]{this.bbar});
        SetCommandsTest.assertEquals((long)0L, (long)bstatus);
    }

    @Test
    public void spop() {
        this.jedis.sadd("foo", "a");
        this.jedis.sadd("foo", "b");
        String member = this.jedis.spop("foo");
        SetCommandsTest.assertTrue(("a".equals(member) || "b".equals(member) ? 1 : 0) != 0);
        SetCommandsTest.assertEquals((long)1L, (long)this.jedis.smembers("foo").size());
        member = this.jedis.spop("bar");
        SetCommandsTest.assertNull((Object)member);
        this.jedis.sadd(this.bfoo, new byte[][]{this.ba});
        this.jedis.sadd(this.bfoo, new byte[][]{this.bb});
        byte[] bmember = this.jedis.spop(this.bfoo);
        SetCommandsTest.assertTrue((Arrays.equals(this.ba, bmember) || Arrays.equals(this.bb, bmember) ? 1 : 0) != 0);
        SetCommandsTest.assertEquals((long)1L, (long)this.jedis.smembers(this.bfoo).size());
        bmember = this.jedis.spop(this.bbar);
        SetCommandsTest.assertNull((Object)bmember);
    }

    @Test
    public void spopWithCount() {
        this.jedis.sadd("foo", "a");
        this.jedis.sadd("foo", "b");
        HashSet<String> expected = new HashSet<String>();
        expected.add("a");
        expected.add("b");
        Set<String> members = this.jedis.spop("foo", 2L);
        SetCommandsTest.assertEquals((long)2L, (long)members.size());
        SetCommandsTest.assertEquals(expected, members);
        members = this.jedis.spop("foo", 2L);
        SetCommandsTest.assertTrue((boolean)members.isEmpty());
        this.jedis.sadd(this.bfoo, new byte[][]{this.ba});
        this.jedis.sadd(this.bfoo, new byte[][]{this.bb});
        HashSet<byte[]> bexpected = new HashSet<byte[]>();
        bexpected.add(this.bb);
        bexpected.add(this.ba);
        Set<byte[]> bmembers = this.jedis.spop(this.bfoo, 2L);
        SetCommandsTest.assertEquals((long)2L, (long)bmembers.size());
        this.assertEquals(bexpected, bmembers);
        bmembers = this.jedis.spop(this.bfoo, 2L);
        SetCommandsTest.assertTrue((boolean)bmembers.isEmpty());
    }

    @Test
    public void smove() {
        this.jedis.sadd("foo", "a");
        this.jedis.sadd("foo", "b");
        this.jedis.sadd("bar", "c");
        long status = this.jedis.smove("foo", "bar", "a");
        HashSet<String> expectedSrc = new HashSet<String>();
        expectedSrc.add("b");
        HashSet<String> expectedDst = new HashSet<String>();
        expectedDst.add("c");
        expectedDst.add("a");
        SetCommandsTest.assertEquals((long)status, (long)1L);
        SetCommandsTest.assertEquals(expectedSrc, this.jedis.smembers("foo"));
        SetCommandsTest.assertEquals(expectedDst, this.jedis.smembers("bar"));
        status = this.jedis.smove("foo", "bar", "a");
        SetCommandsTest.assertEquals((long)status, (long)0L);
        this.jedis.sadd(this.bfoo, new byte[][]{this.ba});
        this.jedis.sadd(this.bfoo, new byte[][]{this.bb});
        this.jedis.sadd(this.bbar, new byte[][]{this.bc});
        long bstatus = this.jedis.smove(this.bfoo, this.bbar, this.ba);
        HashSet<byte[]> bexpectedSrc = new HashSet<byte[]>();
        bexpectedSrc.add(this.bb);
        HashSet<byte[]> bexpectedDst = new HashSet<byte[]>();
        bexpectedDst.add(this.bc);
        bexpectedDst.add(this.ba);
        SetCommandsTest.assertEquals((long)bstatus, (long)1L);
        this.assertEquals(bexpectedSrc, this.jedis.smembers(this.bfoo));
        this.assertEquals(bexpectedDst, this.jedis.smembers(this.bbar));
        bstatus = this.jedis.smove(this.bfoo, this.bbar, this.ba);
        SetCommandsTest.assertEquals((long)bstatus, (long)0L);
    }

    @Test
    public void scard() {
        this.jedis.sadd("foo", "a");
        this.jedis.sadd("foo", "b");
        long card = this.jedis.scard("foo");
        SetCommandsTest.assertEquals((long)2L, (long)card);
        card = this.jedis.scard("bar");
        SetCommandsTest.assertEquals((long)0L, (long)card);
        this.jedis.sadd(this.bfoo, new byte[][]{this.ba});
        this.jedis.sadd(this.bfoo, new byte[][]{this.bb});
        long bcard = this.jedis.scard(this.bfoo);
        SetCommandsTest.assertEquals((long)2L, (long)bcard);
        bcard = this.jedis.scard(this.bbar);
        SetCommandsTest.assertEquals((long)0L, (long)bcard);
    }

    @Test
    public void sismember() {
        this.jedis.sadd("foo", "a");
        this.jedis.sadd("foo", "b");
        SetCommandsTest.assertTrue((boolean)this.jedis.sismember("foo", "a"));
        SetCommandsTest.assertFalse((boolean)this.jedis.sismember("foo", "c"));
        this.jedis.sadd(this.bfoo, new byte[][]{this.ba});
        this.jedis.sadd(this.bfoo, new byte[][]{this.bb});
        SetCommandsTest.assertTrue((boolean)this.jedis.sismember(this.bfoo, this.ba));
        SetCommandsTest.assertFalse((boolean)this.jedis.sismember(this.bfoo, this.bc));
    }

    @Test
    public void sinter() {
        this.jedis.sadd("foo", "a");
        this.jedis.sadd("foo", "b");
        this.jedis.sadd("bar", "b");
        this.jedis.sadd("bar", "c");
        HashSet<String> expected = new HashSet<String>();
        expected.add("b");
        Set<String> intersection = this.jedis.sinter("foo", "bar");
        SetCommandsTest.assertEquals(expected, intersection);
        this.jedis.sadd(this.bfoo, new byte[][]{this.ba});
        this.jedis.sadd(this.bfoo, new byte[][]{this.bb});
        this.jedis.sadd(this.bbar, new byte[][]{this.bb});
        this.jedis.sadd(this.bbar, new byte[][]{this.bc});
        HashSet<byte[]> bexpected = new HashSet<byte[]>();
        bexpected.add(this.bb);
        Set<byte[]> bintersection = this.jedis.sinter(this.bfoo, this.bbar);
        this.assertEquals(bexpected, bintersection);
    }

    @Test
    public void sinterstore() {
        this.jedis.sadd("foo", "a");
        this.jedis.sadd("foo", "b");
        this.jedis.sadd("bar", "b");
        this.jedis.sadd("bar", "c");
        HashSet<String> expected = new HashSet<String>();
        expected.add("b");
        long status = this.jedis.sinterstore("car", "foo", "bar");
        SetCommandsTest.assertEquals((long)1L, (long)status);
        SetCommandsTest.assertEquals(expected, this.jedis.smembers("car"));
        this.jedis.sadd(this.bfoo, new byte[][]{this.ba});
        this.jedis.sadd(this.bfoo, new byte[][]{this.bb});
        this.jedis.sadd(this.bbar, new byte[][]{this.bb});
        this.jedis.sadd(this.bbar, new byte[][]{this.bc});
        HashSet<byte[]> bexpected = new HashSet<byte[]>();
        bexpected.add(this.bb);
        long bstatus = this.jedis.sinterstore(this.bcar, this.bfoo, this.bbar);
        SetCommandsTest.assertEquals((long)1L, (long)bstatus);
        this.assertEquals(bexpected, this.jedis.smembers(this.bcar));
    }

    @Test
    public void sunion() {
        this.jedis.sadd("foo", "a");
        this.jedis.sadd("foo", "b");
        this.jedis.sadd("bar", "b");
        this.jedis.sadd("bar", "c");
        HashSet<String> expected = new HashSet<String>();
        expected.add("a");
        expected.add("b");
        expected.add("c");
        Set<String> union = this.jedis.sunion("foo", "bar");
        SetCommandsTest.assertEquals(expected, union);
        this.jedis.sadd(this.bfoo, new byte[][]{this.ba});
        this.jedis.sadd(this.bfoo, new byte[][]{this.bb});
        this.jedis.sadd(this.bbar, new byte[][]{this.bb});
        this.jedis.sadd(this.bbar, new byte[][]{this.bc});
        HashSet<byte[]> bexpected = new HashSet<byte[]>();
        bexpected.add(this.bb);
        bexpected.add(this.bc);
        bexpected.add(this.ba);
        Set<byte[]> bunion = this.jedis.sunion(this.bfoo, this.bbar);
        this.assertEquals(bexpected, bunion);
    }

    @Test
    public void sunionstore() {
        this.jedis.sadd("foo", "a");
        this.jedis.sadd("foo", "b");
        this.jedis.sadd("bar", "b");
        this.jedis.sadd("bar", "c");
        HashSet<String> expected = new HashSet<String>();
        expected.add("a");
        expected.add("b");
        expected.add("c");
        long status = this.jedis.sunionstore("car", "foo", "bar");
        SetCommandsTest.assertEquals((long)3L, (long)status);
        SetCommandsTest.assertEquals(expected, this.jedis.smembers("car"));
        this.jedis.sadd(this.bfoo, new byte[][]{this.ba});
        this.jedis.sadd(this.bfoo, new byte[][]{this.bb});
        this.jedis.sadd(this.bbar, new byte[][]{this.bb});
        this.jedis.sadd(this.bbar, new byte[][]{this.bc});
        HashSet<byte[]> bexpected = new HashSet<byte[]>();
        bexpected.add(this.bb);
        bexpected.add(this.bc);
        bexpected.add(this.ba);
        long bstatus = this.jedis.sunionstore(this.bcar, this.bfoo, this.bbar);
        SetCommandsTest.assertEquals((long)3L, (long)bstatus);
        this.assertEquals(bexpected, this.jedis.smembers(this.bcar));
    }

    @Test
    public void sdiff() {
        this.jedis.sadd("foo", "x");
        this.jedis.sadd("foo", "a");
        this.jedis.sadd("foo", "b");
        this.jedis.sadd("foo", "c");
        this.jedis.sadd("bar", "c");
        this.jedis.sadd("car", "a");
        this.jedis.sadd("car", "d");
        HashSet<String> expected = new HashSet<String>();
        expected.add("x");
        expected.add("b");
        Set<String> diff = this.jedis.sdiff("foo", "bar", "car");
        SetCommandsTest.assertEquals(expected, diff);
        this.jedis.sadd(this.bfoo, new byte[][]{this.bx});
        this.jedis.sadd(this.bfoo, new byte[][]{this.ba});
        this.jedis.sadd(this.bfoo, new byte[][]{this.bb});
        this.jedis.sadd(this.bfoo, new byte[][]{this.bc});
        this.jedis.sadd(this.bbar, new byte[][]{this.bc});
        this.jedis.sadd(this.bcar, new byte[][]{this.ba});
        this.jedis.sadd(this.bcar, new byte[][]{this.bd});
        HashSet<byte[]> bexpected = new HashSet<byte[]>();
        bexpected.add(this.bb);
        bexpected.add(this.bx);
        Set<byte[]> bdiff = this.jedis.sdiff(this.bfoo, this.bbar, this.bcar);
        this.assertEquals(bexpected, bdiff);
    }

    @Test
    public void sdiffstore() {
        this.jedis.sadd("foo", "x");
        this.jedis.sadd("foo", "a");
        this.jedis.sadd("foo", "b");
        this.jedis.sadd("foo", "c");
        this.jedis.sadd("bar", "c");
        this.jedis.sadd("car", "a");
        this.jedis.sadd("car", "d");
        HashSet<String> expected = new HashSet<String>();
        expected.add("d");
        expected.add("a");
        long status = this.jedis.sdiffstore("tar", "foo", "bar", "car");
        SetCommandsTest.assertEquals((long)2L, (long)status);
        SetCommandsTest.assertEquals(expected, this.jedis.smembers("car"));
        this.jedis.sadd(this.bfoo, new byte[][]{this.bx});
        this.jedis.sadd(this.bfoo, new byte[][]{this.ba});
        this.jedis.sadd(this.bfoo, new byte[][]{this.bb});
        this.jedis.sadd(this.bfoo, new byte[][]{this.bc});
        this.jedis.sadd(this.bbar, new byte[][]{this.bc});
        this.jedis.sadd(this.bcar, new byte[][]{this.ba});
        this.jedis.sadd(this.bcar, new byte[][]{this.bd});
        HashSet<byte[]> bexpected = new HashSet<byte[]>();
        bexpected.add(this.bd);
        bexpected.add(this.ba);
        long bstatus = this.jedis.sdiffstore("tar".getBytes(), this.bfoo, this.bbar, this.bcar);
        SetCommandsTest.assertEquals((long)2L, (long)bstatus);
        this.assertEquals(bexpected, this.jedis.smembers(this.bcar));
    }

    @Test
    public void srandmember() {
        this.jedis.sadd("foo", "a");
        this.jedis.sadd("foo", "b");
        String member = this.jedis.srandmember("foo");
        SetCommandsTest.assertTrue(("a".equals(member) || "b".equals(member) ? 1 : 0) != 0);
        SetCommandsTest.assertEquals((long)2L, (long)this.jedis.smembers("foo").size());
        member = this.jedis.srandmember("bar");
        SetCommandsTest.assertNull((Object)member);
        this.jedis.sadd(this.bfoo, new byte[][]{this.ba});
        this.jedis.sadd(this.bfoo, new byte[][]{this.bb});
        byte[] bmember = this.jedis.srandmember(this.bfoo);
        SetCommandsTest.assertTrue((Arrays.equals(this.ba, bmember) || Arrays.equals(this.bb, bmember) ? 1 : 0) != 0);
        SetCommandsTest.assertEquals((long)2L, (long)this.jedis.smembers(this.bfoo).size());
        bmember = this.jedis.srandmember(this.bbar);
        SetCommandsTest.assertNull((Object)bmember);
    }

    @Test
    public void sscan() {
        this.jedis.sadd("foo", "a", "b");
        ScanResult<String> result = this.jedis.sscan("foo", ScanParams.SCAN_POINTER_START);
        SetCommandsTest.assertEquals((Object)ScanParams.SCAN_POINTER_START, (Object)result.getStringCursor());
        SetCommandsTest.assertFalse((boolean)result.getResult().isEmpty());
        this.jedis.sadd(this.bfoo, this.ba, this.bb);
        ScanResult<byte[]> bResult = this.jedis.sscan(this.bfoo, ScanParams.SCAN_POINTER_START_BINARY);
        SetCommandsTest.assertArrayEquals((byte[])ScanParams.SCAN_POINTER_START_BINARY, (byte[])bResult.getCursorAsBytes());
        SetCommandsTest.assertFalse((boolean)bResult.getResult().isEmpty());
    }

    @Test
    public void sscanMatch() {
        ScanParams params = new ScanParams();
        params.match("a*");
        this.jedis.sadd("foo", "b", "a", "aa");
        ScanResult<String> result = this.jedis.sscan("foo", ScanParams.SCAN_POINTER_START, params);
        SetCommandsTest.assertEquals((Object)ScanParams.SCAN_POINTER_START, (Object)result.getStringCursor());
        SetCommandsTest.assertFalse((boolean)result.getResult().isEmpty());
        params = new ScanParams();
        params.match(this.bbarstar);
        this.jedis.sadd(this.bfoo, this.bbar1, this.bbar2, this.bbar3);
        ScanResult<byte[]> bResult = this.jedis.sscan(this.bfoo, ScanParams.SCAN_POINTER_START_BINARY, params);
        SetCommandsTest.assertArrayEquals((byte[])ScanParams.SCAN_POINTER_START_BINARY, (byte[])bResult.getCursorAsBytes());
        SetCommandsTest.assertFalse((boolean)bResult.getResult().isEmpty());
    }

    @Test
    public void sscanCount() {
        ScanParams params = new ScanParams();
        params.count(2);
        this.jedis.sadd("foo", "a1", "a2", "a3", "a4", "a5");
        ScanResult<String> result = this.jedis.sscan("foo", ScanParams.SCAN_POINTER_START, params);
        SetCommandsTest.assertFalse((boolean)result.getResult().isEmpty());
        params = new ScanParams();
        params.count(2);
        this.jedis.sadd(this.bfoo, this.bbar1, this.bbar2, this.bbar3);
        ScanResult<byte[]> bResult = this.jedis.sscan(this.bfoo, ScanParams.SCAN_POINTER_START_BINARY, params);
        SetCommandsTest.assertFalse((boolean)bResult.getResult().isEmpty());
    }
}

