/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.tests.commands;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Test;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.tests.commands.JedisCommandTestBase;
import redis.clients.jedis.tests.utils.ClientKillerUtil;
import redis.clients.util.SafeEncoder;

public class ScriptingCommandsTest
extends JedisCommandTestBase {
    @Test
    public void evalMultiBulk() {
        String script = "return {KEYS[1],KEYS[2],ARGV[1],ARGV[2],ARGV[3]}";
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("key1");
        keys.add("key2");
        ArrayList<String> args = new ArrayList<String>();
        args.add("first");
        args.add("second");
        args.add("third");
        List response = (List)this.jedis.eval(script, keys, args);
        ScriptingCommandsTest.assertEquals((long)5L, (long)response.size());
        ScriptingCommandsTest.assertEquals((Object)"key1", response.get(0));
        ScriptingCommandsTest.assertEquals((Object)"key2", response.get(1));
        ScriptingCommandsTest.assertEquals((Object)"first", response.get(2));
        ScriptingCommandsTest.assertEquals((Object)"second", response.get(3));
        ScriptingCommandsTest.assertEquals((Object)"third", response.get(4));
    }

    @Test
    public void evalMultiBulkWithBinaryJedis() {
        String script = "return {KEYS[1],KEYS[2],ARGV[1],ARGV[2],ARGV[3]}";
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        keys.add("key1".getBytes());
        keys.add("key2".getBytes());
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add("first".getBytes());
        args.add("second".getBytes());
        args.add("third".getBytes());
        BinaryJedis binaryJedis = new BinaryJedis(hnp.getHost(), hnp.getPort(), 500);
        binaryJedis.connect();
        binaryJedis.auth("foobared");
        List responses = (List)binaryJedis.eval(script.getBytes(), keys, args);
        ScriptingCommandsTest.assertEquals((long)5L, (long)responses.size());
        ScriptingCommandsTest.assertEquals((Object)"key1", (Object)new String((byte[])responses.get(0)));
        ScriptingCommandsTest.assertEquals((Object)"key2", (Object)new String((byte[])responses.get(1)));
        ScriptingCommandsTest.assertEquals((Object)"first", (Object)new String((byte[])responses.get(2)));
        ScriptingCommandsTest.assertEquals((Object)"second", (Object)new String((byte[])responses.get(3)));
        ScriptingCommandsTest.assertEquals((Object)"third", (Object)new String((byte[])responses.get(4)));
        binaryJedis.close();
    }

    @Test
    public void evalBulk() {
        String script = "return KEYS[1]";
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("key1");
        ArrayList<String> args = new ArrayList<String>();
        args.add("first");
        String response = (String)this.jedis.eval(script, keys, args);
        ScriptingCommandsTest.assertEquals((Object)"key1", (Object)response);
    }

    @Test
    public void evalInt() {
        String script = "return 2";
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("key1");
        Long response = (Long)this.jedis.eval(script, keys, new ArrayList<String>());
        ScriptingCommandsTest.assertEquals((Object)new Long(2L), (Object)response);
    }

    @Test
    public void evalNestedLists() {
        String script = "return { {KEYS[1]} , {2} }";
        List results = (List)this.jedis.eval(script, 1, "key1");
        ScriptingCommandsTest.assertThat((Object)((List)results.get(0)), this.listWithItem("key1"));
        ScriptingCommandsTest.assertThat((Object)((List)results.get(1)), this.listWithItem(2L));
    }

    @Test
    public void evalNoArgs() {
        String script = "return KEYS[1]";
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("key1");
        String response = (String)this.jedis.eval(script, keys, new ArrayList<String>());
        ScriptingCommandsTest.assertEquals((Object)"key1", (Object)response);
    }

    @Test
    public void evalsha() {
        this.jedis.set("foo", "bar");
        this.jedis.eval("return redis.call('get','foo')");
        String result = (String)this.jedis.evalsha("6b1bf486c81ceb7edf3c093f4c48582e38c0e791");
        ScriptingCommandsTest.assertEquals((Object)"bar", (Object)result);
    }

    @Test(expected=JedisDataException.class)
    public void evalshaShaNotFound() {
        this.jedis.evalsha("ffffffffffffffffffffffffffffffffffffffff");
    }

    @Test
    public void scriptFlush() {
        this.jedis.set("foo", "bar");
        this.jedis.eval("return redis.call('get','foo')");
        this.jedis.scriptFlush();
        ScriptingCommandsTest.assertFalse((boolean)this.jedis.scriptExists("6b1bf486c81ceb7edf3c093f4c48582e38c0e791"));
    }

    @Test
    public void scriptExists() {
        this.jedis.scriptLoad("return redis.call('get','foo')");
        List<Boolean> exists = this.jedis.scriptExists("ffffffffffffffffffffffffffffffffffffffff", "6b1bf486c81ceb7edf3c093f4c48582e38c0e791");
        ScriptingCommandsTest.assertFalse((boolean)exists.get(0));
        ScriptingCommandsTest.assertTrue((boolean)exists.get(1));
    }

    @Test
    public void scriptExistsBinary() {
        this.jedis.scriptLoad(SafeEncoder.encode("return redis.call('get','foo')"));
        List<Long> exists = this.jedis.scriptExists(SafeEncoder.encode("ffffffffffffffffffffffffffffffffffffffff"), SafeEncoder.encode("6b1bf486c81ceb7edf3c093f4c48582e38c0e791"));
        ScriptingCommandsTest.assertEquals((Object)new Long(0L), (Object)exists.get(0));
        ScriptingCommandsTest.assertEquals((Object)new Long(1L), (Object)exists.get(1));
    }

    @Test
    public void scriptLoad() {
        this.jedis.scriptLoad("return redis.call('get','foo')");
        ScriptingCommandsTest.assertTrue((boolean)this.jedis.scriptExists("6b1bf486c81ceb7edf3c093f4c48582e38c0e791"));
    }

    @Test
    public void scriptLoadBinary() {
        this.jedis.scriptLoad(SafeEncoder.encode("return redis.call('get','foo')"));
        byte[][] scripts = new byte[][]{SafeEncoder.encode("6b1bf486c81ceb7edf3c093f4c48582e38c0e791")};
        List<Long> exists = this.jedis.scriptExists(scripts);
        ScriptingCommandsTest.assertEquals((Object)new Long(1L), (Object)exists.get(0));
    }

    @Test
    public void scriptKill() {
        try {
            this.jedis.scriptKill();
        }
        catch (JedisDataException e) {
            ScriptingCommandsTest.assertTrue((boolean)e.getMessage().contains("No scripts in execution right now."));
        }
    }

    @Test
    public void scriptEvalReturnNullValues() {
        this.jedis.del("key1");
        this.jedis.del("key2");
        String script = "return {redis.call('hget',KEYS[1],ARGV[1]),redis.call('hget',KEYS[2],ARGV[2])}";
        List results = (List)this.jedis.eval(script, 2, "key1", "key2", "1", "2");
        ScriptingCommandsTest.assertEquals((long)2L, (long)results.size());
        ScriptingCommandsTest.assertNull(results.get(0));
        ScriptingCommandsTest.assertNull(results.get(1));
    }

    @Test
    public void scriptEvalShaReturnNullValues() {
        this.jedis.del("key1");
        this.jedis.del("key2");
        String script = "return {redis.call('hget',KEYS[1],ARGV[1]),redis.call('hget',KEYS[2],ARGV[2])}";
        String sha = this.jedis.scriptLoad(script);
        List results = (List)this.jedis.evalsha(sha, 2, "key1", "key2", "1", "2");
        ScriptingCommandsTest.assertEquals((long)2L, (long)results.size());
        ScriptingCommandsTest.assertNull(results.get(0));
        ScriptingCommandsTest.assertNull(results.get(1));
    }

    @Test
    public void scriptExistsWithBrokenConnection() {
        Jedis deadClient = new Jedis(this.jedis.getClient().getHost(), this.jedis.getClient().getPort());
        deadClient.auth("foobared");
        deadClient.clientSetname("DEAD");
        ClientKillerUtil.killClient(deadClient, "DEAD");
        try {
            deadClient.scriptExists("abcdefg");
        }
        catch (JedisConnectionException jedisConnectionException) {
            // empty catch block
        }
        ScriptingCommandsTest.assertEquals((Object)true, (Object)deadClient.getClient().isBroken());
        deadClient.close();
    }

    private <T> Matcher<Iterable<? super T>> listWithItem(T expected) {
        return CoreMatchers.hasItem((Matcher)CoreMatchers.equalTo(expected));
    }
}

